/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2006,
 * @author JBoss Inc.
 */

package org.jboss.soa.esb.quickstart.test;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import org.jboss.soa.esb.testutils.IdentitySAXHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/**
 * Helper class for quickstart tests
 * 
 */

public class Helpers {

    public static String getQuickstartLocation(final String location)
        throws IOException
    {
        final File quickstartDir = new File(System.getProperty("org.jboss.esb.test.quickstarts.dir"), location) ;
        return quickstartDir.getCanonicalPath() ;
    }

    public static boolean compareNonXMLContent(final String content1, final String content2, final boolean trimLines) throws IOException {
        List<String> content1Lines = getLines(content1, trimLines);
        List<String> content2Lines = getLines(content2, trimLines);

        return content1Lines.equals(content2Lines);
    }

    private static List<String> getLines(final String string, final boolean trimLines) throws IOException {
        BufferedReader reader = new BufferedReader(new StringReader(string));
        List<String> lines = new ArrayList<String>();
        String line;

        while((line = reader.readLine()) != null) {
            if(trimLines) {
                lines.add(line.trim());
            } else {
                lines.add(line);
            }
        }

        return lines;
    }

    public static boolean compareXMLContent(final String content1, final String content2)
        throws ParserConfigurationException, SAXException, IOException
    {
        try {
            final SAXParserFactory parserFactory = SAXParserFactory.newInstance() ;
            parserFactory.setNamespaceAware(true) ;

            final SAXParser parser = parserFactory.newSAXParser() ;
            final IdentitySAXHandler handler1;
            final IdentitySAXHandler handler2;

            try {
                handler1 = new IdentitySAXHandler() ;
                parser.parse(new InputSource(new StringReader(content1)), handler1) ;
            } catch(SAXException e) {
                System.out.println("Failed to parse content1 [" + content1 + "].");
                throw e;
            }

            try {
                handler2 = new IdentitySAXHandler() ;
                parser.parse(new InputSource(new StringReader(content2)), handler2) ;
            } catch(SAXException e) {
                System.out.println("Failed to parse content2 [" + content2 + "].");
                throw e;
            }

            return (handler1.getRootElement().equals(handler2.getRootElement())) ;
        } catch(IOException e) {
            e.printStackTrace();
            throw e;
        }
    }
    
    public static void main(final String[] args)
    {
        final String content =
            "<test attr='1'>\n" +
            "    <inner inner1Attr='1'>\r\n" +
            "        innerContent1 \n" +
            "    </inner>\n" +
            "    testContent\n" +
            "    <inner inner2Attr='2'>\r\n" +
            "        innerContent2\n" +
            "    </inner>\n" +
            "    <inner3 inner3Attr='3'>\r\n" +
            "        innerContent3\n" +
            "    </inner3>\n" +
            " </test>" ;
        final SAXParserFactory parserFactory = SAXParserFactory.newInstance() ;
        parserFactory.setNamespaceAware(true) ;
        
        try
        {
            final SAXParser parser = parserFactory.newSAXParser() ;
            
            final IdentitySAXHandler handler1 = new IdentitySAXHandler() ;
            parser.parse(new InputSource(new StringReader(content)), handler1) ;
        }
        catch (final Throwable th)
        {
            th.printStackTrace() ;
        }
    }

} /* class */
