/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.bpel.runtime.ws;

import java.net.URL;
import java.net.URLClassLoader;

import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.Dispatch;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * This class implements the JAXWSInitializer interface to
 * provide JBossWS-Native specific initialization.
 * 
 * @author gbrown
 *
 */
public class JBossWSNativeJAXWSInitializer implements JAXWSInitializer {
	
	protected final Log log = LogFactory.getLog(getClass());
	
	/**
	 * This method initializes the web service stack in preparation for
	 * calling the service and port supplied as parameters.
	 * 
	 * @param serviceName The service name
	 * @param portName The port name
	 * @param baseURI The base URI of the deployment
	 */
	public void initializeStack(QName serviceName, QName portName, java.net.URI baseURI) {
	}
	
	/**
	 * This method is used to notify the initializer that the service has
	 * not been created.
	 * 
	 * @param serviceName The service name
	 * @param portName The port name
	 * @param baseURI The base URI of the deployment
	 * @param dispatch The dispatcher
	 */
	public void serviceCreated(QName serviceName, QName portName, java.net.URI baseURI,
						Dispatch<SOAPMessage> dispatcher) {
		try {
			URLClassLoader urlcl=new URLClassLoader(new URL[]{baseURI.toURL()});
			
			//String filename="jbossws-cxf-"+portName.getLocalPart()+".xml";
			String filename="jboss-wsse-client.xml";
		      
			URL configFile = urlcl.getResource(filename);
			
			log.debug("Web Stack initialization file: name="+filename+" file="+configFile);
			
			if (configFile != null) {
				if (dispatcher instanceof org.jboss.ws.core.jaxws.client.DispatchImpl) {
					((org.jboss.ws.core.jaxws.client.DispatchImpl)dispatcher).setSecurityConfig(configFile.toExternalForm());
					((org.jboss.ws.core.jaxws.client.DispatchImpl)dispatcher).setConfigName("Standard WSSecurity Client");
					//((org.jboss.ws.core.jaxws.client.DispatchImpl)dispatcher).setConfigName(
					//		"Standard WSSecurity Client", configFile.toString());
//					((org.jboss.ws.core.jaxws.client.DispatchImpl)dispatcher).setSecurityConfig("Standard WSSecurity Client");
				} else {
					log.error("WS-Security client config provided, " +
							"but dispatcher is not expected jbossws-native implementation");
				}
			}
		      	
		} catch(Exception e) {
			log.error("Failed to check for WS-Security support in native stack", e);
		}
	}
	
	/**
	 * This method is used to notify the initializer that the service has
	 * not been created.
	 * 
	 */
	@Deprecated
	public void serviceCreated() {
	}
	
}
