/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package riftsaw124;

import junit.framework.TestCase;

import org.jboss.soa.dsp.ws.WSDLParser;

import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;

/**
 * https://jira.jboss.org/jira/browse/RIFTSAW-124
 */
public class Riftsaw124TestCase extends TestCase
{
  final String WSDL_FILE = "src/test/resources/riftsaw124/HelloWorldInvokeProcessArtifacts.wsdl";
                                     
  private static final String TNS = "http://jboss.com/bpel/HelloWorldInvoke";
  final QName messageElementName = new QName(TNS, "HelloWorldInvokeProcessRequest");
  final QName serviceName = new QName(TNS, "HelloWorldInvokeService");
  final String portName = "HelloWorldInvokePort";
  
  private WSDLParser wsdlParser;

  @Override
  protected void setUp() throws Exception
  {
    WSDLReader wsdlReader = WSDLFactory.newInstance().newWSDLReader();
    Definition wsdlDefinition = wsdlReader.readWSDL(WSDL_FILE);
    wsdlParser = new WSDLParser(wsdlDefinition);
  }

  public void testParse() throws Exception
  {
    Operation op = wsdlParser.getDocLitOperation(serviceName, portName, messageElementName);
    assertNotNull(op);

    System.out.println("WSDL Operation: " +op.getName());
  }
}
