/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package riftsaw277;

import javax.xml.soap.SOAPMessage;

import org.jboss.soa.dsp.ws.SOAPMessageAdapter;

import junit.framework.TestCase;

/**
 * https://jira.jboss.org/jira/browse/RIFTSAW-277
 */
public class Riftsaw277TestCase extends TestCase {

	public Riftsaw277TestCase() {
	}
	
	public void testSOAPFaultWithNoDetails() {
		try {
			org.w3c.dom.Document doc = javax.xml.parsers.DocumentBuilderFactory.
				newInstance().newDocumentBuilder().newDocument();

			org.w3c.dom.Element odeMessage=doc.createElement("message");
			
			doc.appendChild(odeMessage);
			
			String str="<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">"+
				"<soap:Body><soap:Fault><faultcode>soap:Client</faultcode>"+
				"<faultstring>Server did not recognize the value of HTTP Header SOAPAction: .</faultstring>"+
				"<detail/></soap:Fault></soap:Body></soap:Envelope>";

			java.io.InputStream is=new java.io.ByteArrayInputStream(str.getBytes());
			
			SOAPMessage soapMessage=javax.xml.soap.MessageFactory.newInstance().createMessage(null,
								is);
			
			is.close();
			
			javax.wsdl.factory.WSDLFactory fact=
				javax.wsdl.factory.WSDLFactory.newInstance();
			javax.wsdl.Definition defn=fact.newDefinition();
			javax.wsdl.Operation operation=defn.createOperation();
		    
		    javax.wsdl.Fault fault=SOAPMessageAdapter.parseSoapFault(odeMessage,
		    				soapMessage, operation);

		    if (fault != null) {
		    	fail("No fault should be returned");
		    }
		} catch(Exception e) {
			e.printStackTrace();
			fail("Failed to run test: "+e);
		}
	}
}
