/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.bpel.uddi;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.v3.client.mapping.URLLocalizer;
import org.jboss.soa.bpel.runtime.JBossDSPFactory;
import org.jboss.soa.bpel.runtime.engine.ode.BPELEngineImpl;
import org.jboss.soa.dsp.server.ServerConfig;

/**
 * 
 * * @author Kurt T Stam <kurt.stam@jboss.com>
 *
 */
public class JBossURLLocalizer  implements URLLocalizer {

	protected static final Log log = LogFactory.getLog(JBossURLLocalizer.class);
	private Properties properties = new Properties();
	
	public JBossURLLocalizer(Properties properties) {
		super();
		this.properties = properties;
	}

	/**
	 * 
	 * @param urlIn
	 * @return
	 */
	public String rewriteToWSDLURL(URL url) {
		String path = url.getPath();
		if (! path.startsWith("/")) path = "/" + path;
		return getWebserviceBaseUrl() + path + "?wsdl";
	}
	/**
	 * 
	 * @param urlIn
	 * @return
	 */
	public String rewrite(URL url) {
		String path = url.getPath();
		if (! path.startsWith("/")) path = "/" + path;
		return getWebserviceBaseUrl() + path;
	}
	/**
	 * 
	 * @return
	 */
	private String getWebserviceBaseUrl() {
		String url = properties.getProperty(BPELEngineImpl.BPEL_WEBSERVICE_BASEURL);
		if (url != null) {
			if (url.endsWith("/")) url = url.substring(0,url.length()-1);
			return url;
		}
		return getDefaultWebServiceBaseUrl();
	}

	private String getDefaultWebServiceBaseUrl() {
		try {		
			ServerConfig serverConfig=JBossDSPFactory.getServerConfig();
			String webServiceHost = serverConfig.getWebServiceHost();
			int webServicePort = serverConfig.getWebServicePort();
			URL theURL = new URL("http://" + webServiceHost + ":" + webServicePort);
			if (Boolean.valueOf(properties.getProperty(BPELEngineImpl.BPEL_WEBSERVICE_SECURE, "false"))) {
				int secureWebServicePort = serverConfig.getWebServicePort();
				theURL = new URL("https://" + webServiceHost + ":" + secureWebServicePort);
			}
			String url = theURL.toExternalForm();
			if (url.endsWith("/")) url = url.substring(0, url.length()-1);
			return url;
		} catch (MalformedURLException e) {
			log.error("Error in constructing the webservice base url.", e);
			return null;
		}
	}
}
