package org.jboss.riftsaw.management;

import org.apache.commons.httpclient.*;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.jboss.bpm.console.client.model.*;

import java.io.IOException;
import java.net.URLDecoder;
import java.net.URLEncoder;

import org.jboss.soa.bpel.console.ModelAdaptor;

import com.google.gson.*;


/**
 * User: Jeff Yu
 * Date: 1/04/11
 */
public class ManagementClient {

    private static final String deployment_url = "http://localhost:8080/gwt-console-server/rs/engine/deployments";

    private static final String definitions_url = "http://localhost:8080/gwt-console-server/rs/process/definitions";

    private static final String authentication_url = "http://localhost:8080/gwt-console-server/rs/identity/secure/j_security_check";

    private static final String history_search_url = "http://localhost:8080/gwt-console-server/rs/history/definition/";

    private String username;
    private String password;

    public ManagementClient(String u, String p) {
System.out.println("U="+u+" P="+p);
	username = u;
	password = p;
    }

    public void showAllDeployments() throws Exception {
        System.out.println("-----------------------------");
        System.out.println("Get all of deployments: ");
        String result = getDataFromService(deployment_url, "GET");

        System.out.println("-----------------------------");
        System.out.println("Marshall the Json data into java class.");

        Gson gson = GsonFactory.createInstance();
        DeploymentRefWrapper wrapper = gson.fromJson(result, DeploymentRefWrapper.class);

        for (DeploymentRef ref : wrapper.getDeployments()) {
            System.out.println("deployment name is: " + ref.getName());
        }

    }

    public void showAllDefinitions() throws Exception {
        System.out.println("-----------------------------");
        System.out.println("Get all of process definitions: ");
        String result = getDataFromService(definitions_url, "GET");

        System.out.println("-----------------------------");
        System.out.println("Marshall the Json data into java class.");

        Gson gson = GsonFactory.createInstance();
        ProcessDefinitionRefWrapper wrapper = gson.fromJson(result, ProcessDefinitionRefWrapper.class);

        for (ProcessDefinitionRef ref : wrapper.getDefinitions()) {
            System.out.println("process name is: " + ref.getName());
        }
    }

    public void getActiveProcessInstance() throws Exception {

        String processId = "{http://www.jboss.org/bpel/examples}HelloGoodbye-1";
        String encodedId = ModelAdaptor.encodeId(processId);
        String instances_url = "http://localhost:8080/gwt-console-server/rs/process/definition" + "/" + encodedId + "/instances";
        System.out.println("-----------------------------");
        System.out.println("Get active process instances from process definition of : " + processId );
        String result = getDataFromService(instances_url, "GET");

        System.out.println("-----------------------------");
        System.out.println("Marshall the Json data into java class.");

        Gson gson = GsonFactory.createInstance();
        ProcessInstanceRefWrapper wrapper = gson.fromJson(result, ProcessInstanceRefWrapper.class);

        for (ProcessInstanceRef ref : wrapper.getInstances()) {
            System.out.println("instance id is: " + ref.getId() + " definition key is: " + ModelAdaptor.decodeId(ref.getDefinitionId()));
        }
    }


    public void getHistoricProcessInstance() throws Exception {
        String processId = "{http://www.jboss.org/bpel/examples}HelloGoodbye-1";
        String encodedId = ModelAdaptor.encodeId(processId);
        String status = "COMPLETED";

        Long starttime = new java.util.Date(103, 1, 1).getTime();
        Long endtime = new java.util.Date().getTime();

        String search_url = history_search_url + encodedId + "/instances?status=" + status
                            + "&starttime="+starttime + "&endtime=" + endtime;

        System.out.println("-----------------------------");
        System.out.println("Get historic process instances from process definition of : " + processId );

        String result = getDataFromService(search_url, "GET");
        System.out.println("-----------------------------");
        System.out.println("Marshall the Json data into java class.");

        Gson gson = GsonFactory.createInstance();
        HistoryProcessInstanceRefWrapper wrapper = gson.fromJson(result, HistoryProcessInstanceRefWrapper.class);

        for (HistoryProcessInstanceRef ref: wrapper.getDefinitions()) {
          System.out.println("historic instance id is: " + ref.getProcessInstanceId() + " definition key is: "
                                            + URLDecoder.decode(ref.getProcessDefinitionId(), "UTF-8"));
        }

    }

    private String getDataFromService(String urlpath, String method) throws Exception{
       HttpClient httpclient = new HttpClient();

       HttpMethod theMethod = null;
       StringBuffer sb = new StringBuffer();

       if ("GET".equalsIgnoreCase(method)) {
           theMethod = new GetMethod(urlpath);
       } else if ("POST".equalsIgnoreCase(method)) {
           theMethod = new PostMethod(urlpath);
       }

       if (username != null && password != null) {

           try {
               httpclient.executeMethod(theMethod);
           } catch (IOException e) {
               e.printStackTrace();
           } finally {
               theMethod.releaseConnection();
           }
         PostMethod authMethod = new PostMethod(authentication_url);
         NameValuePair[] data = {new NameValuePair("j_username", username), new NameValuePair("j_password", password)};
         authMethod.setRequestBody(data);
           try {
               httpclient.executeMethod(authMethod);
           } catch (IOException e) {
               e.printStackTrace();
           } finally {
               authMethod.releaseConnection();
           }
       }

       try {
         httpclient.executeMethod(theMethod);
         sb.append(theMethod.getResponseBodyAsString());
         System.out.println("JSon Result: => " + sb.toString());
       return sb.toString();

       }catch (Exception e) {
          throw e;
       }finally {
         theMethod.releaseConnection();
       }

    }

    public static void main(String[] args) throws Exception {

       ManagementClient client = new ManagementClient(System.getProperty("username"),System.getProperty("password"));
       client.showAllDeployments();
       client.showAllDefinitions();
       client.getActiveProcessInstance();
       client.getHistoricProcessInstance();
    }


}
