/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.jboss.soa.bpel.sample.quickstart.ordering.ejb;

import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.PersistenceContext;
import org.jboss.soa.bpel.sample.quickstart.ordering.model.Item;

import org.jboss.soa.bpel.sample.quickstart.ordering.model.Order;

/**
 *
 * @author mbaluch
 */
@Stateless(name="OrderingEJB")
public class OrderingBean implements OrderingBeanLocal {

    @PersistenceContext
    private EntityManager em;

    public Long createOrder(Long itemId, int quantity) {
        Order order = new Order();
        order.setItemId(itemId);
        order.setQuantity(quantity);
        order.setStatus("NEW");
        
        return createOrder(order);
    }

    public void updateOrder(Order order) {
        System.out.println("[OrderingBean] Updating Order: " + order);
        em.merge(order);
        //em.flush();
    }

    public Long createOrder(Order order) {
        System.out.println("[OrderingBean] Creating new Order: " + order);
        em.persist(order);
        //em.flush();
        return order.getId();
    }

    public int getItemInfo(Long id) {
        return em.find(Item.class, id).getPrice();
    }

    public void setState(Long id, String state) {
        Order order = em.find(Order.class, id);
        order.setStatus(state);
        updateOrder(order);
    }

    public String getState(Long id) {
        Order order = em.find(Order.class, id);
        return order.getStatus();
    }

}
