/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.jboss.soa.bpel.sample.quickstart.ordering.model;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

/**
 *
 * @author mbaluch
 */
@Entity()
@Table(name="bpel_ordering_order")
public class Order implements Serializable {

    private static final Long serialVersionUID = 1L;

    @Id
    @GeneratedValue(strategy = GenerationType.SEQUENCE) // for HSQLDB
    //@GeneratedValue(strategy = GenerationType.AUTO) // for MySQL51
    private Long id;

    private Long itemId;

    private int quantity;

    @Column(name = "stte")
    private String status;


    public Order() {
    }

    
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public int getQuantity() {
        return quantity;
    }

    public void setQuantity(int quantity) {
        this.quantity = quantity;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final Order other = (Order) obj;
        if (this.id != other.id && (this.id == null || !this.id.equals(other.id))) {
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 23 * hash + (this.id != null ? this.id.hashCode() : 0);
        hash = 23 * hash + (this.itemId != null ? this.itemId.hashCode() : 0);
        hash = 23 * hash + this.quantity;
        hash = 23 * hash + (this.status != null ? this.status.hashCode() : 0);
        return hash;
    }

    @Override
    public String toString() {
        return "Order{" + "id=" + id + ", itemId=" + itemId + ", quantity=" + quantity + ", status=" + status + '}';
    }

}
