/*
 * JBoss, Home of Professional Open Source
 * Copyright 2009, Red Hat Middleware LLC, and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
package org.jboss.soa.bpel.examples.jaxws;

import java.io.PrintStream;
import java.util.Map;
import java.util.Set;

import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;

/**
 * This class provides an example jaxws handler that can be deployed with
 * a BPEL process, to provide visibility of messages inbound and outbound
 * from the web service interface.
 * 
 * @author gbrown
 *
 */
public class JAXWSHandler implements SOAPHandler<SOAPMessageContext> {

    private PrintStream out;

    public JAXWSHandler() {
        setLogStream(System.out);
    }

    protected final void setLogStream(PrintStream ps) {
        out = ps;
    }

    public void init(Map c) {
        System.out.println("JAXWSHandler : init() Called....:"+c);
    }

    public Set<QName> getHeaders() {
        return null;
    }

    public boolean handleMessage(SOAPMessageContext smc) {
        System.out.println("JAXWSHandler : handleMessage Called....");
        logToSystemOut(smc);
        return true;
    }

    public boolean handleFault(SOAPMessageContext smc) {
        System.out.println("JAXWSHandler : handleFault Called....");
        logToSystemOut(smc);
        return true;
    }

    public void close(MessageContext messageContext) {
        System.out.println("JAXWSHandler : close() Called....");
    }

    public void destroy() {
        System.out.println("JAXWSHandler : destroy() Called....");
    }

    protected void logToSystemOut(SOAPMessageContext smc) {
        Boolean outboundProperty = (Boolean)
            smc.get(MessageContext.MESSAGE_OUTBOUND_PROPERTY);

        if (outboundProperty.booleanValue()) {
            out.println("\nOutbound message:");
        } else {
            out.println("\nInbound message:");
        }

        SOAPMessage message = smc.getMessage();
        try {
            message.writeTo(out);
            out.println();
        } catch (Exception e) {
            out.println("Exception in handler: " + e);
        }

        out.println("WSDL_SERVICE = "+smc.get(MessageContext.WSDL_SERVICE));
		out.println("WSDL_INTERFACE = "+smc.get(MessageContext.WSDL_INTERFACE));
		out.println("WSDL_PORT = "+smc.get(MessageContext.WSDL_PORT));
		out.println("WSDL_OPERATION = "+smc.get(MessageContext.WSDL_OPERATION));
    }
}
