/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.qa.teargas.message.sender;

import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

/**
 *
 * @author mvecera@redhat.com, pmacik@redhat.com
 */
public class HTTPSender implements MessageSender {

   private URL url;
   private String method = "POST";
   private Map<String, String> headers = new HashMap<String, String>();
   private final Logger log = Logger.getLogger(HTTPSender.class);

   public void setProperty(String prop, String value) {
      if ("method".equals(prop)) {
         method = value;
      }
   }

   public void setHeader(String name, String value) {
      headers.put(name, value);
   }

   public void init(String address) throws Exception {
      url = new URL(address);
   }

   public void close() {
   }

   public Serializable send(Serializable message, Map properties) throws Exception {
      HttpURLConnection rc = (HttpURLConnection) url.openConnection();
      rc.setRequestMethod(method);
      rc.setDoOutput(true);
      rc.setDoInput(true);
      rc.setRequestProperty("Content-Type", "text/xml; charset=utf-8");

      String reqStr = message.toString();
      int len = reqStr.length();
      rc.setRequestProperty("Content-Length", Integer.toString(len));
      //rc.setRequestProperty("SOAPAction", soapActions[actionLookup(action)]);

      if(headers.entrySet().size() > 0){ 
         log.debug("Setting HTTP headers");
         for (Map.Entry<String, String> header : headers.entrySet()) {
	    log.debug(header.getKey() + ": " + header.getValue());
	    rc.setRequestProperty(header.getKey(), header.getValue());
         }
      }
      rc.connect();

      OutputStreamWriter out = new OutputStreamWriter(rc.getOutputStream());
      out.write(reqStr, 0, len);
      out.flush();

      rc.getOutputStream().close();

      char[] cbuf = new char[10 * 1024];
      InputStreamReader read = new InputStreamReader(rc.getInputStream());
      // note that Content-Length is available at this point
      StringBuilder sb = new StringBuilder();
      int ch = read.read(cbuf);
      while (ch != -1) {
         sb.append(cbuf, 0, ch);
         ch = read.read(cbuf);
      }
      read.close();
      rc.getInputStream().close();
      rc.disconnect();

      return sb.toString();
   }

   @Override
   public MessageSender clone() {
      HTTPSender senderClone = new HTTPSender();
      senderClone.url = this.url;
      senderClone.method = this.method;
      for (Map.Entry<String, String> header : headers.entrySet()) {
         senderClone.setHeader(header.getKey(), header.getValue());
      }
      return senderClone;
   }
}
