<?xml version="1.0"?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision : 1484766 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="mod_proxy_fcgi.xml.meta">

<name>mod_proxy_fcgi</name>
<description>Module fournissant le support de FastCGI &agrave;
<module>mod_proxy</module></description>
<status>Extension</status>
<sourcefile>mod_proxy_fcgi.c</sourcefile>
<identifier>proxy_fcgi_module</identifier>
<compatibility>Disponible depuis la version 2.3 d'Apache</compatibility>

<summary>
    <p>Pour fonctionner, ce module <em>n&eacute;cessite</em> le chargement de
    <module>mod_proxy</module>. Il fournit le support du protocole <a
    href="http://www.fastcgi.com/">FastCGI</a>.</p>

    <p>Ainsi, pour pouvoir traiter le protocole <code>FastCGI</code>,
    <module>mod_proxy</module> et <module>mod_proxy_fcgi</module>
    doivent &ecirc;tre charg&eacute;s dans le serveur.</p>

    <p>&Agrave; la diff&eacute;rence de <a
    href="http://httpd.apache.org/mod_fcgid/">mod_fcgid</a> et <a
    href="http://www.fastcgi.com/">mod_fastcgi</a>,
    <module>mod_proxy_fcgi</module> n'est pas en mesure de d&eacute;marrer le
    processus de l'application ; <program>fcgistarter</program> est
    fourni &agrave; cet effet.</p>

    <note type="warning"><title>Avertissement</title>
      <p>N'activez pas la fonctionnalit&eacute; de mandataire avant d'avoir <a
      href="mod_proxy.html#access">s&eacute;curis&eacute; votre serveur</a>. Les
      serveurs mandataires ouverts sont dangereux non seulement pour
      votre r&eacute;seau, mais aussi pour l'Internet au sens large.</p>
    </note>
</summary>

<seealso><program>fcgistarter</program></seealso>
<seealso><module>mod_proxy</module></seealso>

<section id="examples"><title>Exemples</title>
    <p>Pour que ces exemples fonctionnent, vous ne devez pas oublier
    d'activer <module>mod_proxy</module> et
    <module>mod_proxy_fcgi</module>.</p>

    <example><title>Instance d'application unique</title>
    <highlight language="config">
      ProxyPass /mon_appli/ fcgi://localhost:4000/
      </highlight>
    </example>

    <p>Cette application doit &ecirc;tre en mesure de g&eacute;rer plusieurs
    connexions simultan&eacute;es. Par d&eacute;faut, <module>mod_proxy</module>
    permet la r&eacute;utilisation des connexions, si bien que lorsque le
    traitement d'une requ&ecirc;te est termin&eacute;, le processus enfant httpd
    garde la connexion ouverte, et cette derni&egrave;re ne sera pas r&eacute;utilis&eacute;e
    avant que le m&ecirc;me processus httpd ne redirige une autre requ&ecirc;te vers
    l'application. Si l'application FastCGI n'est pas en mesure de g&eacute;rer
    un nombre suffisant de connexions simultan&eacute;es avec httpd, les
    requ&ecirc;tes peuvent rester bloqu&eacute;es jusqu'&agrave; ce que l'application ferme
    une connexion existante. Pour rem&eacute;dier &agrave; ce probl&egrave;me, on peut
    d&eacute;sactiver la r&eacute;utilisation des connexions &agrave; l'aide de la directive
    <directive>ProxyPass</directive>, comme indiqu&eacute; dans l'exemple
    suivant :</p>

    <example><title>Instance d'application unique, pas de r&eacute;utilisation
    des connexions</title>
    <highlight language="config">
      ProxyPass /mon_appli/ fcgi://localhost:4000/ disablereuse=on
      </highlight>
    </example>

    <p>La passerelle &agrave; r&eacute;partition de charge n&eacute;cessite le chargement du
    module <module>mod_proxy_balancer</module> et d'au moins un module
    fournissant un algorithme de r&eacute;partition de charge, comme
    <module>mod_lbmethod_byrequests</module> en plus des modules
    d&eacute;j&agrave; cit&eacute;s. <module>mod_lbmethod_byrequests</module> est le module
    par d&eacute;faut et sera utilis&eacute; dans cet exemple de configuration.</p>

    <example><title>Passerelle &agrave; r&eacute;partition de charge vers plusieurs
    instances de l'application</title>
    <highlight language="config">
ProxyPass /myapp/ balancer://myappcluster/
&lt;Proxy balancer://myappcluster/&gt;
    BalancerMember fcgi://localhost:4000
    BalancerMember fcgi://localhost:4001
&lt;/Proxy&gt;
    </highlight>
    </example>
</section>

<section id="env"><title>Variables d'environnement</title>
    <p>En plus des directives de configuration qui contr&ocirc;lent le
    comportement de <module>mod_proxy</module>, de nombreuses
    <dfn>variables d'environnement</dfn> permettent de piloter le
    fournisseur du protocole FCGI :</p>
    <dl>
        <dt>proxy-fcgi-pathinfo</dt>
        <dd>Par d&eacute;faut, <module>mod_proxy_fcgi</module> ne cr&eacute;era jamais
	ni n'exportera la variable d'environnement <var>PATH_INFO</var>,
	ce qui permet au serveur FCGI d'arri&egrave;re-plan de d&eacute;terminer
	correctement <var>SCRIPT_NAME</var> et <var>Script-URI</var>, et
	de se conformer &agrave; la section 3.3 de la RFC 3875. Si au contraire
	vous souhaitez que <module>mod_proxy_fcgi</module> g&eacute;n&egrave;re une
	"estimation la plus exacte possible" de <var>PATH_INFO</var>,
	d&eacute;finissez la variable d'environnement
	<var>proxy-fcgi-pathinfo</var>. Ceci peut servir de
	contournement pour un bogue pr&eacute;sent dans certaines
	impl&eacute;mentations de FCGI.</dd>
    </dl>
</section>

</modulesynopsis>
