/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.classfmt;

import org.eclipse.jdt.internal.compiler.classfmt.AnnotationInfo;
import org.eclipse.jdt.internal.compiler.classfmt.MethodInfo;
import org.eclipse.jdt.internal.compiler.classfmt.MethodInfoWithAnnotations;
import org.eclipse.jdt.internal.compiler.env.IBinaryAnnotation;

class MethodInfoWithParameterAnnotations
extends MethodInfoWithAnnotations {
    private AnnotationInfo[][] parameterAnnotations;

    MethodInfoWithParameterAnnotations(MethodInfo methodInfo, AnnotationInfo[] annotations, AnnotationInfo[][] parameterAnnotations) {
        super(methodInfo, annotations);
        this.parameterAnnotations = parameterAnnotations;
    }

    @Override
    public IBinaryAnnotation[] getParameterAnnotations(int index) {
        return this.parameterAnnotations == null ? null : this.parameterAnnotations[index];
    }

    @Override
    public int getAnnotatedParametersCount() {
        return this.parameterAnnotations == null ? 0 : this.parameterAnnotations.length;
    }

    @Override
    protected void initialize() {
        int l;
        int n = l = this.parameterAnnotations == null ? 0 : this.parameterAnnotations.length;
        for (int i = 0; i < l; ++i) {
            int k;
            AnnotationInfo[] infos = this.parameterAnnotations[i];
            int n2 = k = infos == null ? 0 : infos.length;
            for (int j = 0; j < k; ++j) {
                infos[j].initialize();
            }
        }
        super.initialize();
    }

    @Override
    protected void reset() {
        int l;
        int n = l = this.parameterAnnotations == null ? 0 : this.parameterAnnotations.length;
        for (int i = 0; i < l; ++i) {
            int k;
            AnnotationInfo[] infos = this.parameterAnnotations[i];
            int n2 = k = infos == null ? 0 : infos.length;
            for (int j = 0; j < k; ++j) {
                infos[j].reset();
            }
        }
        super.reset();
    }

    @Override
    protected void toStringContent(StringBuffer buffer) {
        int l;
        super.toStringContent(buffer);
        int n = l = this.parameterAnnotations == null ? 0 : this.parameterAnnotations.length;
        for (int i = 0; i < l; ++i) {
            int k;
            buffer.append("param" + (i - 1));
            buffer.append('\n');
            AnnotationInfo[] infos = this.parameterAnnotations[i];
            int n2 = k = infos == null ? 0 : infos.length;
            for (int j = 0; j < k; ++j) {
                buffer.append(infos[j]);
                buffer.append('\n');
            }
        }
    }
}

