/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.ConditionalExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.ExpressionContext;
import org.eclipse.jdt.internal.compiler.ast.Invocation;
import org.eclipse.jdt.internal.compiler.ast.LambdaExpression;
import org.eclipse.jdt.internal.compiler.ast.NullAnnotationMatching;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.ast.SwitchStatement;
import org.eclipse.jdt.internal.compiler.ast.UnaryExpression;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public abstract class Statement
extends ASTNode {
    public static final int NOT_COMPLAINED = 0;
    public static final int COMPLAINED_FAKE_REACHABLE = 1;
    public static final int COMPLAINED_UNREACHABLE = 2;

    protected static boolean isKnowDeadCodePattern(Expression expression) {
        if (expression instanceof UnaryExpression) {
            expression = ((UnaryExpression)expression).expression;
        }
        return expression instanceof Reference;
    }

    public abstract FlowInfo analyseCode(BlockScope var1, FlowContext var2, FlowInfo var3);

    protected void analyseArguments(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo, MethodBinding methodBinding, Expression[] arguments) {
        block9: {
            int numParamsToCheck;
            boolean hasJDK15NullAnnotations;
            block10: {
                if (arguments == null) break block9;
                CompilerOptions compilerOptions = currentScope.compilerOptions();
                if (compilerOptions.sourceLevel >= 0x330000L && methodBinding.isPolymorphic()) {
                    return;
                }
                boolean considerTypeAnnotations = compilerOptions.sourceLevel >= 0x340000L && compilerOptions.isAnnotationBasedNullAnalysisEnabled;
                hasJDK15NullAnnotations = methodBinding.parameterNonNullness != null;
                numParamsToCheck = methodBinding.parameters.length;
                int varArgPos = -1;
                TypeBinding varArgsType = null;
                boolean passThrough = false;
                if ((considerTypeAnnotations || hasJDK15NullAnnotations) && methodBinding.isVarargs()) {
                    varArgPos = numParamsToCheck - 1;
                    if (numParamsToCheck == arguments.length) {
                        varArgsType = methodBinding.parameters[varArgPos];
                        TypeBinding lastType = arguments[varArgPos].resolvedType;
                        if (lastType == TypeBinding.NULL || varArgsType.dimensions() == lastType.dimensions() && lastType.isCompatibleWith(varArgsType)) {
                            passThrough = true;
                        }
                    }
                    if (!passThrough) {
                        --numParamsToCheck;
                    }
                }
                if (!considerTypeAnnotations) break block10;
                for (int i = 0; i < numParamsToCheck; ++i) {
                    TypeBinding expectedType = methodBinding.parameters[i];
                    Boolean specialCaseNonNullness = hasJDK15NullAnnotations ? methodBinding.parameterNonNullness[i] : null;
                    this.analyseOneArgument18(currentScope, flowContext, flowInfo, expectedType, arguments[i], specialCaseNonNullness, methodBinding.original().parameters[i]);
                }
                if (passThrough || !(varArgsType instanceof ArrayBinding)) break block9;
                TypeBinding expectedType = ((ArrayBinding)varArgsType).elementsType();
                Boolean specialCaseNonNullness = hasJDK15NullAnnotations ? methodBinding.parameterNonNullness[varArgPos] : null;
                for (int i = numParamsToCheck; i < arguments.length; ++i) {
                    this.analyseOneArgument18(currentScope, flowContext, flowInfo, expectedType, arguments[i], specialCaseNonNullness, methodBinding.original().parameters[varArgPos]);
                }
                break block9;
            }
            if (hasJDK15NullAnnotations) {
                for (int i = 0; i < numParamsToCheck; ++i) {
                    if (methodBinding.parameterNonNullness[i] != Boolean.TRUE) continue;
                    TypeBinding expectedType = methodBinding.parameters[i];
                    Expression argument = arguments[i];
                    int nullStatus = argument.nullStatus(flowInfo, flowContext);
                    if (nullStatus == 4) continue;
                    flowContext.recordNullityMismatch(currentScope, argument, argument.resolvedType, expectedType, nullStatus);
                }
            }
        }
    }

    void analyseOneArgument18(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo, TypeBinding expectedType, Expression argument, Boolean expectedNonNullness, TypeBinding originalExpected) {
        if (argument instanceof ConditionalExpression && argument.isPolyExpression()) {
            ConditionalExpression ce = (ConditionalExpression)argument;
            ce.internalAnalyseOneArgument18(currentScope, flowContext, expectedType, ce.valueIfTrue, ce.ifTrueNullStatus, expectedNonNullness, originalExpected);
            ce.internalAnalyseOneArgument18(currentScope, flowContext, expectedType, ce.valueIfFalse, ce.ifFalseNullStatus, expectedNonNullness, originalExpected);
            return;
        }
        int nullStatus = argument.nullStatus(flowInfo, flowContext);
        this.internalAnalyseOneArgument18(currentScope, flowContext, expectedType, argument, nullStatus, expectedNonNullness, originalExpected);
    }

    void internalAnalyseOneArgument18(BlockScope currentScope, FlowContext flowContext, TypeBinding expectedType, Expression argument, int nullStatus, Boolean expectedNonNullness, TypeBinding originalExpected) {
        int statusFromAnnotatedNull = expectedNonNullness == Boolean.TRUE ? nullStatus : 0;
        NullAnnotationMatching annotationStatus = NullAnnotationMatching.analyse(expectedType, argument.resolvedType, nullStatus);
        if (!annotationStatus.isAnyMismatch() && statusFromAnnotatedNull != 0) {
            expectedType = originalExpected;
        }
        if (annotationStatus.isDefiniteMismatch() || statusFromAnnotatedNull == 2) {
            currentScope.problemReporter().nullityMismatchingTypeAnnotation(argument, argument.resolvedType, expectedType, annotationStatus);
        } else if (annotationStatus.isUnchecked() || (statusFromAnnotatedNull & 0x10) != 0) {
            flowContext.recordNullityMismatch(currentScope, argument, argument.resolvedType, expectedType, nullStatus);
        }
    }

    protected void checkAgainstNullTypeAnnotation(BlockScope scope, TypeBinding requiredType, Expression expression, FlowContext flowContext, FlowInfo flowInfo) {
        if (expression instanceof ConditionalExpression && expression.isPolyExpression()) {
            ConditionalExpression ce = (ConditionalExpression)expression;
            this.internalCheckAgainstNullTypeAnnotation(scope, requiredType, ce.valueIfTrue, ce.ifTrueNullStatus, flowContext);
            this.internalCheckAgainstNullTypeAnnotation(scope, requiredType, ce.valueIfFalse, ce.ifFalseNullStatus, flowContext);
            return;
        }
        int nullStatus = expression.nullStatus(flowInfo, flowContext);
        this.internalCheckAgainstNullTypeAnnotation(scope, requiredType, expression, nullStatus, flowContext);
    }

    private void internalCheckAgainstNullTypeAnnotation(BlockScope scope, TypeBinding requiredType, Expression expression, int nullStatus, FlowContext flowContext) {
        NullAnnotationMatching annotationStatus = NullAnnotationMatching.analyse(requiredType, expression.resolvedType, nullStatus);
        if (annotationStatus.isDefiniteMismatch()) {
            scope.problemReporter().nullityMismatchingTypeAnnotation(expression, expression.resolvedType, requiredType, annotationStatus);
        } else if (annotationStatus.isUnchecked()) {
            flowContext.recordNullityMismatch(scope, expression, expression.resolvedType, requiredType, nullStatus);
        }
    }

    public void branchChainTo(BranchLabel label) {
    }

    public int complainIfUnreachable(FlowInfo flowInfo, BlockScope scope, int previousComplaintLevel, boolean endOfBlock) {
        if ((flowInfo.reachMode() & 3) != 0) {
            if ((flowInfo.reachMode() & 1) != 0) {
                this.bits &= Integer.MAX_VALUE;
            }
            if (flowInfo == FlowInfo.DEAD_END) {
                if (previousComplaintLevel < 2) {
                    scope.problemReporter().unreachableCode(this);
                    if (endOfBlock) {
                        scope.checkUnclosedCloseables(flowInfo, null, null, null);
                    }
                }
                return 2;
            }
            if (previousComplaintLevel < 1) {
                scope.problemReporter().fakeReachable(this);
                if (endOfBlock) {
                    scope.checkUnclosedCloseables(flowInfo, null, null, null);
                }
            }
            return 1;
        }
        return previousComplaintLevel;
    }

    public void generateArguments(MethodBinding binding, Expression[] arguments, BlockScope currentScope, CodeStream codeStream) {
        block10: {
            block9: {
                int argLength;
                if (!binding.isVarargs()) break block9;
                TypeBinding[] params = binding.parameters;
                int paramLength = params.length;
                int varArgIndex = paramLength - 1;
                for (int i = 0; i < varArgIndex; ++i) {
                    arguments[i].generateCode(currentScope, codeStream, true);
                }
                ArrayBinding varArgsType = (ArrayBinding)params[varArgIndex];
                ArrayBinding codeGenVarArgsType = (ArrayBinding)binding.parameters[varArgIndex].erasure();
                int elementsTypeID = varArgsType.elementsType().id;
                int n = argLength = arguments == null ? 0 : arguments.length;
                if (argLength > paramLength) {
                    codeStream.generateInlinedValue(argLength - varArgIndex);
                    codeStream.newArray(codeGenVarArgsType);
                    for (int i = varArgIndex; i < argLength; ++i) {
                        codeStream.dup();
                        codeStream.generateInlinedValue(i - varArgIndex);
                        arguments[i].generateCode(currentScope, codeStream, true);
                        codeStream.arrayAtPut(elementsTypeID, false);
                    }
                } else if (argLength == paramLength) {
                    TypeBinding lastType = arguments[varArgIndex].resolvedType;
                    if (lastType == TypeBinding.NULL || varArgsType.dimensions() == lastType.dimensions() && lastType.isCompatibleWith(varArgsType)) {
                        arguments[varArgIndex].generateCode(currentScope, codeStream, true);
                    } else {
                        codeStream.generateInlinedValue(1);
                        codeStream.newArray(codeGenVarArgsType);
                        codeStream.dup();
                        codeStream.generateInlinedValue(0);
                        arguments[varArgIndex].generateCode(currentScope, codeStream, true);
                        codeStream.arrayAtPut(elementsTypeID, false);
                    }
                } else {
                    codeStream.generateInlinedValue(0);
                    codeStream.newArray(codeGenVarArgsType);
                }
                break block10;
            }
            if (arguments == null) break block10;
            int max = arguments.length;
            for (int i = 0; i < max; ++i) {
                arguments[i].generateCode(currentScope, codeStream, true);
            }
        }
    }

    public abstract void generateCode(BlockScope var1, CodeStream var2);

    public boolean isBoxingCompatible(TypeBinding expressionType, TypeBinding targetType, Expression expression, Scope scope) {
        if (scope.isBoxingCompatibleWith(expressionType, targetType)) {
            return true;
        }
        return expressionType.isBaseType() && !targetType.isBaseType() && !targetType.isTypeVariable() && scope.compilerOptions().sourceLevel >= 0x310000L && (targetType.id == 26 || targetType.id == 27 || targetType.id == 28) && expression.isConstantValueOfTypeAssignableToType(expressionType, scope.environment().computeBoxingType(targetType));
    }

    public boolean isEmptyBlock() {
        return false;
    }

    public boolean isValidJavaStatement() {
        return true;
    }

    @Override
    public StringBuffer print(int indent, StringBuffer output) {
        return this.printStatement(indent, output);
    }

    public abstract StringBuffer printStatement(int var1, StringBuffer var2);

    public abstract void resolve(BlockScope var1);

    public Constant resolveCase(BlockScope scope, TypeBinding testType, SwitchStatement switchStatement) {
        this.resolve(scope);
        return Constant.NotAConstant;
    }

    public TypeBinding invocationTargetType() {
        return null;
    }

    public TypeBinding expectedType() {
        return this.invocationTargetType();
    }

    public ExpressionContext getExpressionContext() {
        return ExpressionContext.VANILLA_CONTEXT;
    }

    protected MethodBinding findConstructorBinding(BlockScope scope, Invocation site, ReferenceBinding receiverType, TypeBinding[] argumentTypes) {
        MethodBinding ctorBinding = scope.getConstructor(receiverType, argumentTypes, site);
        Statement.resolvePolyExpressionArguments(site, ctorBinding, argumentTypes, scope);
        return ctorBinding;
    }

    protected void recordExceptionsForEnclosingLambda(BlockScope scope, TypeBinding ... thrownExceptions) {
        MethodScope methodScope = scope.methodScope();
        if (methodScope != null && methodScope.referenceContext instanceof LambdaExpression) {
            LambdaExpression lambda = (LambdaExpression)methodScope.referenceContext;
            for (int i = 0; i < thrownExceptions.length; ++i) {
                lambda.throwsException(thrownExceptions[i]);
            }
        }
    }
}

