<?xml version="1.0"?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision : 1480903 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="mod_log_debug.xml.meta">

<name>mod_log_debug</name>
<description>Journalisation suppl&eacute;mentaire &agrave; des fins de d&eacute;bogage</description>
<status>Experimental</status>
<sourcefile>mod_log_debug.c</sourcefile>
<identifier>log_debug_module</identifier>
<compatibility>Disponible depuis la version 2.3.14 d'Apache</compatibility>

<section id="examples"><title>Exemples</title>

    <ol>
      <li>
        Enregistre un message apr&egrave;s le traitement d'une requ&ecirc;te pour
	/foo/* :

        <highlight language="config">
&lt;Location /foo/&gt;
&nbsp;&nbsp;LogMessage "/foo/ has been requested"
&lt;/Location&gt;
        </highlight>
      </li>

      <li>
        Enregistre un message si une requ&ecirc;te pour /foo/* est trait&eacute;e
	dans une sous-requ&ecirc;te :
        <highlight language="config">
&lt;Location /foo/&gt;
&nbsp;&nbsp;LogMessage "subrequest to /foo/" hook=type_checker expr=%{IS_SUBREQ}
&lt;/Location&gt;
        </highlight>

        Le branchement (hook) par d&eacute;faut log_transaction n'est pas
	ex&eacute;cut&eacute; pour les sous-requ&ecirc;tes ; nous devons donc en utiliser un
	autre.
      </li>


      <li>
        Enregistre un message si un client IPv6 est &agrave; l'origine d'un
	d&eacute;passement de d&eacute;lai pour une requ&ecirc;te :
        <highlight language="config">
            LogMessage "IPv6 timeout from %{REMOTE_ADDR}" "expr=-T %{IPV6} &amp;&amp; %{REQUEST_STATUS} = 408"
        </highlight>
        Notez l'emplacement des guillemets pour l'argument
	<code>expr=</code>.
      </li>

      <li>
        Enregistre la valeur de la variable d'environnement de requ&ecirc;te
	"X-Foo" &agrave; chaque &eacute;tape du traitement :
        <highlight language="config">
&lt;Location /&gt;
&nbsp;&nbsp;LogMessage "%{reqenv:X-Foo}" hook=all
&lt;/Location&gt;
        </highlight>
        En association avec les rep&egrave;res de temps en microsecondes du journal des erreurs,
	<code>hook=all</code> permet aussi de d&eacute;terminer la dur&eacute;e d'ex&eacute;cution des
	diff&eacute;rentes phases du traitement de la requ&ecirc;te.
      </li>

    </ol>
</section>

<directivesynopsis>
<name>LogMessage</name>
<description>Enregistre des messages personnalis&eacute;s dans le journal des
erreurs</description>
<syntax>LogMessage <var>message</var>
[hook=<var>hook</var>] [expr=<var>expression</var>]
</syntax>
<default>Non d&eacute;fini</default>
<contextlist><context>directory</context>
</contextlist>

<usage>
    <p>Cette directive permet d'enregistrer un message personnalis&eacute; dans
    le journal des erreurs. Ce message peut utiliser des variables et
    des fonctions dans la <a href="../expr.html">syntaxe ap_expr</a>.
    D'&eacute;ventuelles r&eacute;f&eacute;rences &agrave; des en-t&ecirc;tes HTTP dans l'expression
    rationnelle n'entra&icirc;neront pas l'ajout des noms d'en-t&ecirc;te
    correspondants &agrave; l'en-t&ecirc;te Vary.
    Les messages sont enregistr&eacute;s au loglevel info.</p>

    <p>Le branchement (hook) pr&eacute;cise la phase du traitement de la
    requ&ecirc;te avant laquelle le message sera enregistr&eacute;. Les branchements
    suivants sont support&eacute;s :</p>

    <table border="1" style="zebra">
    <columnspec><column width="1"/></columnspec>
    <tr><th>Nom</th></tr>
    <tr><td><code>translate_name</code></td></tr>
    <tr><td><code>type_checker</code></td></tr>
    <tr><td><code>quick_handler</code></td></tr>
    <tr><td><code>map_to_storage</code></td></tr>
    <tr><td><code>check_access</code></td></tr>
    <tr><td><code>check_access_ex</code></td></tr>
    <tr><td><code>insert_filter</code></td></tr>
    <tr><td><code>check_authn</code></td></tr>
    <tr><td><code>check_authz</code></td></tr>
    <tr><td><code>fixups</code></td></tr>
    <tr><td><code>handler</code></td></tr>
    <tr><td><code>log_transaction</code></td></tr>
    </table>

    <p>Le branchement par d&eacute;faut est <code>log_transaction</code>. La
    valeur sp&eacute;ciale <code>all</code> est &eacute;galement support&eacute;e ; dans ce cas,
    le message sera enregistr&eacute; &agrave; chaque phase. Tous les branchements ne
    sont pas ex&eacute;cut&eacute;s pour chaque requ&ecirc;te.</p>

    <p>L'expression optionnelle permet de restreindre l'enregistrement
    du message en fonction d'une certaine condition. La syntaxe de
    l'expression est d&eacute;crite dans la <a
    href="../expr.html">documentation ap_expr</a>. D'&eacute;ventuelles
    r&eacute;f&eacute;rences &agrave; des en-t&ecirc;tes HTTP dans l'expression
    rationnelle n'entra&icirc;neront pas l'ajout des noms d'en-t&ecirc;te
    correspondants &agrave; l'en-t&ecirc;te Vary.</p>

</usage>

</directivesynopsis>

</modulesynopsis>
