 
#!/bin/sh
mkdir -p latest/man{1,2,3,4,5,6,7,8}

find . -maxdepth 1 -mindepth 1 ! -name latest -type d -print | while read podadresar
do
# zatim nejsou duplicity, tak vsechno narveme do jednoho adresare rozdelenyho podle sekci
  cd $podadresar
  find . -maxdepth 1 -mindepth 1 -type f | sort | while read soubor
  do
    zakljmeno=$(echo ${soubor#./} | sed s/^[0123456789]\\\{8\\\}\\.//g | sed s/\\.[0-9]\\\{4\\\}-[0-9][0-9]-[0-9][0-9]\\.[a-f0-9]\\\{32\\\}$//g)
    cislosekce=${zakljmeno: -1}
    [[ -n "${cislosekce//[12345678]}" ]] && continue
    
    #dle prostredi zmeni kodovani
    if echo $LANG $LC_ALL | grep -qi 'UTF\-8'
    then
      cp -p $soubor ../latest/man$cislosekce/$zakljmeno
    else
      iconv -f UTF-8 -t ISO-8859-2 $soubor -o ../latest/man$cislosekce/$zakljmeno
      chmod 644 ../latest/man$cislosekce/$zakljmeno
      touch -c -r $soubor ../latest/man$cislosekce/$zakljmeno
    fi

    if [ -f ../seznam ] && ! grep -q "^$zakljmeno          " ../seznam
    then
      echo -e $zakljmeno\\t\\t${podadresar##*/} >> ../seznam
    elif [ -f ../seznam ] && ! grep -q "^$zakljmeno                ${podadresar##*/}" ../seznam
    then
      echo -e $zakljmeno\\t\\t${podadresar##*/} >> ../duplicity
    fi  
  done
  cd ..
done