require Exporter;
package Math::Complex;
use strict;
use vars qw($VERSION @ISA @EXPORT %EXPORT_TAGS);
my($i,$ip2,%logn);
$VERSION = sprintf("%s", q$Id: Complex.pm,v 1.26 1998/11/01 00:00:00 dsl Exp $ =~ /(\d+\.\d+)/);
@ISA=qw(Exporter);
my@trig=qw(
  pi
  tan
  csc cosec sec cot cotan
  asin acos atan
  acsc acosec asec acot acotan
  sinh cosh tanh
  csch cosech sech coth cotanh
  asinh acosh atanh
  acsch acosech asech acoth acotanh
);
@EXPORT=(qw(
i Re Im rho theta arg
sqrt log ln
log10 logn cbrt root
cplx cplxe
),@trig);
%EXPORT_TAGS=('trig'=>[@trig],);
use overload '+'=>\&plus,'-'=>\&minus,'*'=>\&multiply,'/'=>\&divide,'**'=>\&power,'<=>'=>\&spaceship,'neg'=>\&negate,'~'=>\&conjugate,'abs'=>\&abs,'sqrt'=>\&sqrt,'exp'=>\&exp,'log'=>\&log,'sin'=>\&sin,'cos'=>\&cos,'tan'=>\&tan,'atan2'=>\&atan2,qw("" stringify);
my$package='Math::Complex';
my$display='cartesian';
my$eps=1e-14;
sub _cannot_make{die"@{[(caller(1))[3]]}: Cannot take $_[0] of $_[1].\n";}sub make{my$self=bless{},shift;
my($re,$im)=@_;
my$rre=ref$re;
if($rre){if($rre eq ref$self){$re=Re($re);}else{_cannot_make("real part",$rre);}}my$rim=ref$im;
if($rim){if($rim eq ref$self){$im=Im($im);}else{_cannot_make("imaginary part",$rim);}}$self->{'cartesian'}=[$re,$im];
$self->{c_dirty}=0;
$self->{p_dirty}=1;
$self->display_format('cartesian');
return$self;}sub emake{my$self=bless{},shift;
my($rho,$theta)=@_;
my$rrh=ref$rho;
if($rrh){if($rrh eq ref$self){$rho=rho($rho);}else{_cannot_make("rho",$rrh);}}my$rth=ref$theta;
if($rth){if($rth eq ref$self){$theta=theta($theta);}else{_cannot_make("theta",$rth);}}if($rho<0){$rho=-$rho;
$theta=($theta<=0)?$theta+pi():$theta-pi();}$self->{'polar'}=[$rho,$theta];
$self->{p_dirty}=0;
$self->{c_dirty}=1;
$self->display_format('polar');
return$self;}sub new{&make}sub cplx{my($re,$im)=@_;
return$package->make($re,defined$im?$im:0);}sub cplxe{my($rho,$theta)=@_;
return$package->emake($rho,defined$theta?$theta:0);}use constant pi=>4*CORE::atan2(1,1);
use constant pit2=>2*pi;
use constant pip2=>pi/2;
use constant deg1=>pi/180;
use constant uplog10=>1/CORE::log(10);
sub i (){return$i if($i);
$i=bless{};
$i->{'cartesian'}=[0,1];
$i->{'polar'}=[1,pip2];
$i->{c_dirty}=0;
$i->{p_dirty}=0;
return$i;}sub cartesian{$_[0]->{c_dirty}?$_[0]->update_cartesian:$_[0]->{'cartesian'}}sub polar{$_[0]->{p_dirty}?$_[0]->update_polar:$_[0]->{'polar'}}sub set_cartesian{$_[0]->{p_dirty}++;$_[0]->{'cartesian'}=$_[1]}sub set_polar{$_[0]->{c_dirty}++;$_[0]->{'polar'}=$_[1]}sub update_cartesian{my$self=shift;
my($r,$t)=@{$self->{'polar'}};
$self->{c_dirty}=0;
return$self->{'cartesian'}=[$r*CORE::cos($t),$r*CORE::sin($t)];}sub update_polar{my$self=shift;
my($x,$y)=@{$self->{'cartesian'}};
$self->{p_dirty}=0;
return$self->{'polar'}=[0,0]if$x==0&&$y==0;
return$self->{'polar'}=[CORE::sqrt($x*$x+$y*$y),CORE::atan2($y,$x)];}sub plus{my($z1,$z2,$regular)=@_;
my($re1,$im1)=@{$z1->cartesian};
$z2=cplx($z2)unless ref$z2;
my($re2,$im2)=ref$z2?@{$z2->cartesian}:($z2,0);
unless(defined$regular){$z1->set_cartesian([$re1+$re2,$im1+$im2]);
return$z1;}return(ref$z1)->make($re1+$re2,$im1+$im2);}sub minus{my($z1,$z2,$inverted)=@_;
my($re1,$im1)=@{$z1->cartesian};
$z2=cplx($z2)unless ref$z2;
my($re2,$im2)=@{$z2->cartesian};
unless(defined$inverted){$z1->set_cartesian([$re1-$re2,$im1-$im2]);
return$z1;}return$inverted?(ref$z1)->make($re2-$re1,$im2-$im1):(ref$z1)->make($re1-$re2,$im1-$im2);}sub multiply{my($z1,$z2,$regular)=@_;
if($z1->{p_dirty}==0 and ref$z2 and$z2->{p_dirty}==0){my($r1,$t1)=@{$z1->polar};
my($r2,$t2)=@{$z2->polar};
my$t=$t1+$t2;
if($t>pi()){$t-=pit2}elsif($t<=-pi()){$t+=pit2}unless(defined$regular){$z1->set_polar([$r1*$r2,$t]);
return$z1;}return(ref$z1)->emake($r1*$r2,$t);}else{my($x1,$y1)=@{$z1->cartesian};
if(ref$z2){my($x2,$y2)=@{$z2->cartesian};
return(ref$z1)->make($x1*$x2-$y1*$y2,$x1*$y2+$y1*$x2);}else{return(ref$z1)->make($x1*$z2,$y1*$z2);}}}sub _divbyzero{my$mess="$_[0]: Division by zero.\n";
if(defined$_[1]){$mess.="(Because in the definition of $_[0], the divisor ";
$mess.="$_[1] " unless($_[1]eq '0');
$mess.="is 0)\n";}my@up=caller(1);
$mess.="Died at $up[1] line $up[2].\n";
die$mess;}sub divide{my($z1,$z2,$inverted)=@_;
if($z1->{p_dirty}==0 and ref$z2 and$z2->{p_dirty}==0){my($r1,$t1)=@{$z1->polar};
my($r2,$t2)=@{$z2->polar};
my$t;
if($inverted){_divbyzero"$z2/0" if($r1==0);
$t=$t2-$t1;
if($t>pi()){$t-=pit2}elsif($t<=-pi()){$t+=pit2}return(ref$z1)->emake($r2/$r1,$t);}else{_divbyzero"$z1/0" if($r2==0);
$t=$t1-$t2;
if($t>pi()){$t-=pit2}elsif($t<=-pi()){$t+=pit2}return(ref$z1)->emake($r1/$r2,$t);}}else{my($d,$x2,$y2);
if($inverted){($x2,$y2)=@{$z1->cartesian};
$d=$x2*$x2+$y2*$y2;
_divbyzero"$z2/0" if$d==0;
return(ref$z1)->make(($x2*$z2)/$d,-($y2*$z2)/$d);}else{my($x1,$y1)=@{$z1->cartesian};
if(ref$z2){($x2,$y2)=@{$z2->cartesian};
$d=$x2*$x2+$y2*$y2;
_divbyzero"$z1/0" if$d==0;
my$u=($x1*$x2+$y1*$y2)/$d;
my$v=($y1*$x2-$x1*$y2)/$d;
return(ref$z1)->make($u,$v);}else{_divbyzero"$z1/0" if$z2==0;
return(ref$z1)->make($x1/$z2,$y1/$z2);}}}}sub power{my($z1,$z2,$inverted)=@_;
if($inverted){return 1 if$z1==0||$z2==1;
return 0 if$z2==0&&Re($z1)>0;}else{return 1 if$z2==0||$z1==1;
return 0 if$z1==0&&Re($z2)>0;}my$w=$inverted?CORE::exp($z1*CORE::log($z2)):CORE::exp($z2*CORE::log($z1));
return$z1->{c_dirty}==0&&(not ref$z2 or$z2->{c_dirty}==0)?cplx(@{$w->cartesian}):$w;}sub spaceship{my($z1,$z2,$inverted)=@_;
my($re1,$im1)=ref$z1?@{$z1->cartesian}:($z1,0);
my($re2,$im2)=ref$z2?@{$z2->cartesian}:($z2,0);
my$sgn=$inverted?-1:1;
return$sgn*($re1<=>$re2)if$re1!=$re2;
return$sgn*($im1<=>$im2);}sub negate{my($z)=@_;
if($z->{c_dirty}){my($r,$t)=@{$z->polar};
$t=($t<=0)?$t+pi:$t-pi;
return(ref$z)->emake($r,$t);}my($re,$im)=@{$z->cartesian};
return(ref$z)->make(-$re,-$im);}sub conjugate{my($z)=@_;
if($z->{c_dirty}){my($r,$t)=@{$z->polar};
return(ref$z)->emake($r,-$t);}my($re,$im)=@{$z->cartesian};
return(ref$z)->make($re,-$im);}sub abs{my($z,$rho)=@_;
return$z unless ref$z;
if(defined$rho){$z->{'polar'}=[$rho,${$z->polar}[1]];
$z->{p_dirty}=0;
$z->{c_dirty}=1;
return$rho;}else{return${$z->polar}[0];}}sub _theta{my$theta=$_[0];
if($$theta>pi()){$$theta-=pit2}elsif($$theta<=-pi()){$$theta+=pit2}}sub arg{my($z,$theta)=@_;
return$z unless ref$z;
if(defined$theta){_theta(\$theta);
$z->{'polar'}=[${$z->polar}[0],$theta];
$z->{p_dirty}=0;
$z->{c_dirty}=1;}else{$theta=${$z->polar}[1];
_theta(\$theta);}return$theta;}sub sqrt{my($z)=@_;
my($re,$im)=ref$z?@{$z->cartesian}:($z,0);
return$re<0?cplx(0,CORE::sqrt(-$re)):CORE::sqrt($re)if$im==0;
my($r,$t)=@{$z->polar};
return(ref$z)->emake(CORE::sqrt($r),$t/2);}sub cbrt{my($z)=@_;
return$z<0?-CORE::exp(CORE::log(-$z)/3):($z>0?CORE::exp(CORE::log($z)/3):0)unless ref$z;
my($r,$t)=@{$z->polar};
return(ref$z)->emake(CORE::exp(CORE::log($r)/3),$t/3);}sub _rootbad{my$mess="Root $_[0] not defined, root must be positive integer.\n";
my@up=caller(1);
$mess.="Died at $up[1] line $up[2].\n";
die$mess;}sub root{my($z,$n)=@_;
_rootbad($n)if($n<1 or int($n)!=$n);
my($r,$t)=ref$z?@{$z->polar}:(CORE::abs($z),$z>=0?0:pi);
my@root;
my$k;
my$theta_inc=pit2/$n;
my$rho=$r**(1/$n);
my$theta;
my$cartesian=ref$z&&$z->{c_dirty}==0;
for($k=0,$theta=$t/$n;$k<$n;$k++,$theta+=$theta_inc){my$w=cplxe($rho,$theta);
push@root,$cartesian?cplx(@{$w->cartesian}):$w;}return@root;}sub Re{my($z,$Re)=@_;
return$z unless ref$z;
if(defined$Re){$z->{'cartesian'}=[$Re,${$z->cartesian}[1]];
$z->{c_dirty}=0;
$z->{p_dirty}=1;}else{return${$z->cartesian}[0];}}sub Im{my($z,$Im)=@_;
return$z unless ref$z;
if(defined$Im){$z->{'cartesian'}=[${$z->cartesian}[0],$Im];
$z->{c_dirty}=0;
$z->{p_dirty}=1;}else{return${$z->cartesian}[1];}}sub rho{Math::Complex::abs(@_);}sub theta{Math::Complex::arg(@_);}sub exp{my($z)=@_;
my($x,$y)=@{$z->cartesian};
return(ref$z)->emake(CORE::exp($x),$y);}sub _logofzero{my$mess="$_[0]: Logarithm of zero.\n";
if(defined$_[1]){$mess.="(Because in the definition of $_[0], the argument ";
$mess.="$_[1] " unless($_[1]eq '0');
$mess.="is 0)\n";}my@up=caller(1);
$mess.="Died at $up[1] line $up[2].\n";
die$mess;}sub log{my($z)=@_;
unless(ref$z){_logofzero("log")if$z==0;
return$z>0?CORE::log($z):cplx(CORE::log(-$z),pi);}my($r,$t)=@{$z->polar};
_logofzero("log")if$r==0;
if($t>pi()){$t-=pit2}elsif($t<=-pi()){$t+=pit2}return(ref$z)->make(CORE::log($r),$t);}sub ln{Math::Complex::log(@_)}sub log10{return Math::Complex::log($_[0])*uplog10;}sub logn{my($z,$n)=@_;
$z=cplx($z,0)unless ref$z;
my$logn=$logn{$n};
$logn=$logn{$n}=CORE::log($n)unless defined$logn;
return CORE::log($z)/$logn;}sub cos{my($z)=@_;
my($x,$y)=@{$z->cartesian};
my$ey=CORE::exp($y);
my$ey_1=1/$ey;
return(ref$z)->make(CORE::cos($x)*($ey+$ey_1)/2,CORE::sin($x)*($ey_1-$ey)/2);}sub sin{my($z)=@_;
my($x,$y)=@{$z->cartesian};
my$ey=CORE::exp($y);
my$ey_1=1/$ey;
return(ref$z)->make(CORE::sin($x)*($ey+$ey_1)/2,CORE::cos($x)*($ey-$ey_1)/2);}sub tan{my($z)=@_;
my$cz=CORE::cos($z);
_divbyzero"tan($z)","cos($z)" if(CORE::abs($cz)<$eps);
return CORE::sin($z)/$cz;}sub sec{my($z)=@_;
my$cz=CORE::cos($z);
_divbyzero"sec($z)","cos($z)" if($cz==0);
return 1/$cz;}sub csc{my($z)=@_;
my$sz=CORE::sin($z);
_divbyzero"csc($z)","sin($z)" if($sz==0);
return 1/$sz;}sub cosec{Math::Complex::csc(@_)}sub cot{my($z)=@_;
my$sz=CORE::sin($z);
_divbyzero"cot($z)","sin($z)" if($sz==0);
return CORE::cos($z)/$sz;}sub cotan{Math::Complex::cot(@_)}sub acos{my$z=$_[0];
return CORE::atan2(CORE::sqrt(1-$z*$z),$z)if(!ref$z)&&CORE::abs($z)<=1;
my($x,$y)=ref$z?@{$z->cartesian}:($z,0);
my$t1=CORE::sqrt(($x+1)*($x+1)+$y*$y);
my$t2=CORE::sqrt(($x-1)*($x-1)+$y*$y);
my$alpha=($t1+$t2)/2;
my$beta=($t1-$t2)/2;
$alpha=1 if$alpha<1;
if($beta>1){$beta=1}elsif($beta<-1){$beta=-1}my$u=CORE::atan2(CORE::sqrt(1-$beta*$beta),$beta);
my$v=CORE::log($alpha+CORE::sqrt($alpha*$alpha-1));
$v=-$v if$y>0||($y==0&&$x<-1);
return$package->make($u,$v);}sub asin{my$z=$_[0];
return CORE::atan2($z,CORE::sqrt(1-$z*$z))if(!ref$z)&&CORE::abs($z)<=1;
my($x,$y)=ref$z?@{$z->cartesian}:($z,0);
my$t1=CORE::sqrt(($x+1)*($x+1)+$y*$y);
my$t2=CORE::sqrt(($x-1)*($x-1)+$y*$y);
my$alpha=($t1+$t2)/2;
my$beta=($t1-$t2)/2;
$alpha=1 if$alpha<1;
if($beta>1){$beta=1}elsif($beta<-1){$beta=-1}my$u=CORE::atan2($beta,CORE::sqrt(1-$beta*$beta));
my$v=-CORE::log($alpha+CORE::sqrt($alpha*$alpha-1));
$v=-$v if$y>0||($y==0&&$x<-1);
return$package->make($u,$v);}sub atan{my($z)=@_;
return CORE::atan2($z,1)unless ref$z;
_divbyzero"atan(i)"  if($z==i);
_divbyzero"atan(-i)" if(-$z==i);
my$log=CORE::log((i+$z)/(i-$z));
$ip2=0.5*i unless defined$ip2;
return$ip2*$log;}sub asec{my($z)=@_;
_divbyzero"asec($z)",$z if($z==0);
return acos(1/$z);}sub acsc{my($z)=@_;
_divbyzero"acsc($z)",$z if($z==0);
return asin(1/$z);}sub acosec{Math::Complex::acsc(@_)}sub acot{my($z)=@_;
_divbyzero"acot(0)"  if(CORE::abs($z)<$eps);
return($z>=0)?CORE::atan2(1,$z):CORE::atan2(-1,-$z)unless ref$z;
_divbyzero"acot(i)"  if(CORE::abs($z- i)<$eps);
_logofzero"acot(-i)" if(CORE::abs($z+i)<$eps);
return atan(1/$z);}sub acotan{Math::Complex::acot(@_)}sub cosh{my($z)=@_;
my$ex;
unless(ref$z){$ex=CORE::exp($z);
return($ex+1/$ex)/2;}my($x,$y)=@{$z->cartesian};
$ex=CORE::exp($x);
my$ex_1=1/$ex;
return(ref$z)->make(CORE::cos($y)*($ex+$ex_1)/2,CORE::sin($y)*($ex-$ex_1)/2);}sub sinh{my($z)=@_;
my$ex;
unless(ref$z){$ex=CORE::exp($z);
return($ex-1/$ex)/2;}my($x,$y)=@{$z->cartesian};
$ex=CORE::exp($x);
my$ex_1=1/$ex;
return(ref$z)->make(CORE::cos($y)*($ex-$ex_1)/2,CORE::sin($y)*($ex+$ex_1)/2);}sub tanh{my($z)=@_;
my$cz=cosh($z);
_divbyzero"tanh($z)","cosh($z)" if($cz==0);
return sinh($z)/$cz;}sub sech{my($z)=@_;
my$cz=cosh($z);
_divbyzero"sech($z)","cosh($z)" if($cz==0);
return 1/$cz;}sub csch{my($z)=@_;
my$sz=sinh($z);
_divbyzero"csch($z)","sinh($z)" if($sz==0);
return 1/$sz;}sub cosech{Math::Complex::csch(@_)}sub coth{my($z)=@_;
my$sz=sinh($z);
_divbyzero"coth($z)","sinh($z)" if($sz==0);
return cosh($z)/$sz;}sub cotanh{Math::Complex::coth(@_)}sub acosh{my($z)=@_;
unless(ref$z){return CORE::log($z+CORE::sqrt($z*$z-1))if$z>=1;
$z=cplx($z,0);}my($re,$im)=@{$z->cartesian};
if($im==0){return cplx(CORE::log($re+CORE::sqrt($re*$re-1)),0)if$re>=1;
return cplx(0,CORE::atan2(CORE::sqrt(1-$re*$re),$re))if CORE::abs($re)<=1;}return CORE::log($z+CORE::sqrt($z*$z-1));}sub asinh{my($z)=@_;
return CORE::log($z+CORE::sqrt($z*$z+1));}sub atanh{my($z)=@_;
unless(ref$z){return CORE::log((1+$z)/(1-$z))/2 if CORE::abs($z)<1;
$z=cplx($z,0);}_divbyzero 'atanh(1)',"1 - $z" if($z==1);
_logofzero 'atanh(-1)'           if($z==-1);
return 0.5*CORE::log((1+$z)/(1-$z));}sub asech{my($z)=@_;
_divbyzero 'asech(0)',$z if($z==0);
return acosh(1/$z);}sub acsch{my($z)=@_;
_divbyzero 'acsch(0)',$z if($z==0);
return asinh(1/$z);}sub acosech{Math::Complex::acsch(@_)}sub acoth{my($z)=@_;
_divbyzero 'acoth(0)'            if(CORE::abs($z)<$eps);
unless(ref$z){return CORE::log(($z+1)/($z-1))/2 if CORE::abs($z)>1;
$z=cplx($z,0);}_divbyzero 'acoth(1)',"$z - 1" if(CORE::abs($z-1)<$eps);
_logofzero 'acoth(-1)',"1 / $z" if(CORE::abs($z+1)<$eps);
return CORE::log((1+$z)/($z-1))/2;}sub acotanh{Math::Complex::acoth(@_)}sub atan2{my($z1,$z2,$inverted)=@_;
my($re1,$im1,$re2,$im2);
if($inverted){($re1,$im1)=ref$z2?@{$z2->cartesian}:($z2,0);
($re2,$im2)=@{$z1->cartesian};}else{($re1,$im1)=@{$z1->cartesian};
($re2,$im2)=ref$z2?@{$z2->cartesian}:($z2,0);}if($im2==0){return cplx(CORE::atan2($re1,$re2),0)if$im1==0;
return cplx(($im1<=>0)*pip2,0)if$re2==0;}my$w=atan($z1/$z2);
my($u,$v)=ref$w?@{$w->cartesian}:($w,0);
$u+=pi   if$re2<0;
$u-=pit2 if$u>pi;
return cplx($u,$v);}sub display_format{my$self=shift;
my$format=undef;
if(ref$self){$format=shift;}else{$format=$self;
undef$self;}if(defined$self){return defined$self->{display}?$self->{display}:$display unless defined$format;
return$self->{display}=$format;}return$display unless defined$format;
return$display=$format;}sub stringify{my($z)=shift;
my$format;
$format=$display;
$format=$z->{display}if defined$z->{display};
return$z->stringify_polar if$format=~/^p/i;
return$z->stringify_cartesian;}sub stringify_cartesian{my$z=shift;
my($x,$y)=@{$z->cartesian};
my($re,$im);
$x=int($x+($x<0?-1:1)*$eps)if int(CORE::abs($x))!=int(CORE::abs($x)+$eps);
$y=int($y+($y<0?-1:1)*$eps)if int(CORE::abs($y))!=int(CORE::abs($y)+$eps);
$re="$x" if CORE::abs($x)>=$eps;
if($y==1){$im='i'}elsif($y==-1){$im='-i'}elsif(CORE::abs($y)>=$eps){$im=$y."i"}my$str='';
$str=$re if defined$re;
$str.="+$im" if defined$im;
$str=~s/\+-/-/;
$str=~s/^\+//;
$str=~s/([-+])1i/$1i/;
$str='0' unless$str;
return$str;}sub _gcd{my($a,$b)=@_;
use integer;
if($b and$a>$b){return gcd($a%$b,$b)}elsif($a and$b>$a){return gcd($b%$a,$a)}else{return$a?$a:$b}}my%gcd;
sub gcd{my($a,$b)=@_;
my$id="$a $b";
unless(exists$gcd{$id}){$gcd{$id}=_gcd($a,$b);
$gcd{"$b $a"}=$gcd{$id};}return$gcd{$id};}sub stringify_polar{my$z=shift;
my($r,$t)=@{$z->polar};
my$theta;
return '[0,0]' if$r<=$eps;
my$nt=$t/pit2;
$nt=($nt-int($nt))*pit2;
$nt+=pit2 if$nt<0;
if(CORE::abs($nt)<=$eps){$theta=0}elsif(CORE::abs(pi-$nt)<=$eps){$theta='pi'}if(defined$theta){$r=int($r+($r<0?-1:1)*$eps)if int(CORE::abs($r))!=int(CORE::abs($r)+$eps);
$theta=int($theta+($theta<0?-1:1)*$eps)if($theta ne 'pi' and int(CORE::abs($theta))!=int(CORE::abs($theta)+$eps));
return"\[$r,$theta\]";}$nt-=pit2 if$nt>pi;
if(CORE::abs($nt)>=deg1){my($n,$k,$kpi);
for($k=1,$kpi=pi;$k<10;$k++,$kpi+=pi){$n=int($kpi/$nt+($nt>0?1:-1)*0.5);
if(CORE::abs($kpi/$n-$nt)<=$eps){$n=CORE::abs($n);
my$gcd=gcd($k,$n);
if($gcd>1){$k/=$gcd;
$n/=$gcd;}next if$n>360;
$theta=($nt<0?'-':'').($k==1?'pi':"${k}pi");
$theta.='/'.$n if$n>1;
last;}}}$theta=$nt unless defined$theta;
$r=int($r+($r<0?-1:1)*$eps)if int(CORE::abs($r))!=int(CORE::abs($r)+$eps);
$theta=int($theta+($theta<0?-1:1)*$eps)if($theta!~m(^-?\d*pi/\d+$) and int(CORE::abs($theta))!=int(CORE::abs($theta)+$eps));
return"\[$r,$theta\]";}1;
__END__


1;

# eof
