#!/usr/bin/env perl

use strict;

use Test::More tests => 3925;

use FindBin;
use lib "$FindBin::Bin/lib";
use My_Growth_Test;

require_ok('Medical::Growth::NHANES_2000::Height_for_Age::Child::Male');

my $h = Medical::Growth::NHANES_2000::Height_for_Age::Child::Male->new;
My_Growth_Test::run_data_tests($h);

__DATA__
# age %ile value
 24.0	 3	 79.911
 24.0	 5	 80.730
 24.0	10	 81.992
 24.0	25	 84.103
 24.0	50	 86.452
 24.0	75	 88.805
 24.0	90	 90.926
 24.0	95	 92.197
 24.0	97	 93.023
 24.5	 3	 80.260
 24.5	 5	 81.089
 24.5	10	 82.364
 24.5	25	 84.495
 24.5	50	 86.862
 24.5	75	 89.228
 24.5	90	 91.358
 24.5	95	 92.632
 24.5	97	 93.459
 25.5	 3	 81.005
 25.5	 5	 81.834
 25.5	10	 83.114
 25.5	25	 85.259
 25.5	50	 87.652
 25.5	75	 90.057
 25.5	90	 92.230
 25.5	95	 93.534
 25.5	97	 94.383
 26.5	 3	 81.734
 26.5	 5	 82.564
 26.5	10	 83.847
 26.5	25	 86.005
 26.5	50	 88.423
 26.5	75	 90.863
 26.5	90	 93.076
 26.5	95	 94.409
 26.5	97	 95.278
 27.5	 3	 82.448
 27.5	 5	 83.279
 27.5	10	 84.565
 27.5	25	 86.735
 27.5	50	 89.175
 27.5	75	 91.647
 27.5	90	 93.898
 27.5	95	 95.258
 27.5	97	 96.145
 28.5	 3	 83.149
 28.5	 5	 83.980
 28.5	10	 85.270
 28.5	25	 87.450
 28.5	50	 89.910
 28.5	75	 92.412
 28.5	90	 94.698
 28.5	95	 96.081
 28.5	97	 96.987
 29.5	 3	 83.838
 29.5	 5	 84.669
 29.5	10	 85.961
 29.5	25	 88.150
 29.5	50	 90.629
 29.5	75	 93.157
 29.5	90	 95.475
 29.5	95	 96.882
 29.5	97	 97.803
 30.5	 3	 84.516
 30.5	 5	 85.347
 30.5	10	 86.640
 30.5	25	 88.837
 30.5	50	 91.332
 30.5	75	 93.885
 30.5	90	 96.232
 30.5	95	 97.660
 30.5	97	 98.597
 31.5	 3	 85.182
 31.5	 5	 86.014
 31.5	10	 87.308
 31.5	25	 89.512
 31.5	50	 92.021
 31.5	75	 94.596
 31.5	90	 96.970
 31.5	95	 98.418
 31.5	97	 99.368
 32.5	 3	 85.839
 32.5	 5	 86.670
 32.5	10	 87.965
 32.5	25	 90.175
 32.5	50	 92.696
 32.5	75	 95.291
 32.5	90	 97.690
 32.5	95	 99.155
 32.5	97	100.119
 33.5	 3	 86.487
 33.5	 5	 87.317
 33.5	10	 88.612
 33.5	25	 90.826
 33.5	50	 93.358
 33.5	75	 95.971
 33.5	90	 98.392
 33.5	95	 99.874
 33.5	97	100.850
 34.5	 3	 87.126
 34.5	 5	 87.955
 34.5	10	 89.250
 34.5	25	 91.466
 34.5	50	 94.008
 34.5	75	 96.636
 34.5	90	 99.078
 34.5	95	100.576
 34.5	97	101.563
 35.5	 3	 87.756
 35.5	 5	 88.584
 35.5	10	 89.878
 35.5	25	 92.097
 35.5	50	 94.646
 35.5	75	 97.289
 35.5	90	 99.750
 35.5	95	101.262
 35.5	97	102.259
 36.5	 3	 88.379
 36.5	 5	 89.205
 36.5	10	 90.498
 36.5	25	 92.718
 36.5	50	 95.274
 36.5	75	 97.929
 36.5	90	100.407
 36.5	95	101.932
 36.5	97	102.940
 37.5	 3	 88.933
 37.5	 5	 89.773
 37.5	10	 91.086
 37.5	25	 93.334
 37.5	50	 95.915
 37.5	75	 98.585
 37.5	90	101.069
 37.5	95	102.593
 37.5	97	103.598
 38.5	 3	 89.479
 38.5	 5	 90.333
 38.5	10	 91.666
 38.5	25	 93.943
 38.5	50	 96.547
 38.5	75	 99.234
 38.5	90	101.723
 38.5	95	103.247
 38.5	97	104.250
 39.5	 3	 90.018
 39.5	 5	 90.885
 39.5	10	 92.238
 39.5	25	 94.543
 39.5	50	 97.172
 39.5	75	 99.874
 39.5	90	102.371
 39.5	95	103.895
 39.5	97	104.897
 40.5	 3	 90.549
 40.5	 5	 91.430
 40.5	10	 92.802
 40.5	25	 95.136
 40.5	50	 97.789
 40.5	75	100.508
 40.5	90	103.012
 40.5	95	104.537
 40.5	97	105.538
 41.5	 3	 91.073
 41.5	 5	 91.968
 41.5	10	 93.360
 41.5	25	 95.721
 41.5	50	 98.399
 41.5	75	101.135
 41.5	90	103.647
 41.5	95	105.174
 41.5	97	106.175
 42.5	 3	 91.592
 42.5	 5	 92.500
 42.5	10	 93.911
 42.5	25	 96.300
 42.5	50	 99.003
 42.5	75	101.756
 42.5	90	104.277
 42.5	95	105.806
 42.5	97	106.807
 43.5	 3	 92.104
 43.5	 5	 93.026
 43.5	10	 94.456
 43.5	25	 96.873
 43.5	50	 99.600
 43.5	75	102.371
 43.5	90	104.902
 43.5	95	106.434
 43.5	97	107.436
 44.5	 3	 92.611
 44.5	 5	 93.546
 44.5	10	 94.995
 44.5	25	 97.440
 44.5	50	100.192
 44.5	75	102.981
 44.5	90	105.522
 44.5	95	107.058
 44.5	97	108.061
 45.5	 3	 93.113
 45.5	 5	 94.061
 45.5	10	 95.529
 45.5	25	 98.002
 45.5	50	100.778
 45.5	75	103.586
 45.5	90	106.139
 45.5	95	107.678
 45.5	97	108.683
 46.5	 3	 93.610
 46.5	 5	 94.572
 46.5	10	 96.058
 46.5	25	 98.558
 46.5	50	101.360
 46.5	75	104.186
 46.5	90	106.751
 46.5	95	108.296
 46.5	97	109.302
 47.5	 3	 94.104
 47.5	 5	 95.078
 47.5	10	 96.583
 47.5	25	 99.111
 47.5	50	101.937
 47.5	75	104.783
 47.5	90	107.360
 47.5	95	108.910
 47.5	97	109.919
 48.5	 3	 94.594
 48.5	 5	 95.581
 48.5	10	 97.104
 48.5	25	 99.659
 48.5	50	102.510
 48.5	75	105.376
 48.5	90	107.966
 48.5	95	109.522
 48.5	97	110.534
 49.5	 3	 95.080
 49.5	 5	 96.080
 49.5	10	 97.621
 49.5	25	100.203
 49.5	50	103.080
 49.5	75	105.965
 49.5	90	108.570
 49.5	95	110.132
 49.5	97	111.147
 50.5	 3	 95.564
 50.5	 5	 96.576
 50.5	10	 98.136
 50.5	25	100.744
 50.5	50	103.646
 50.5	75	106.552
 50.5	90	109.171
 50.5	95	110.739
 50.5	97	111.759
 51.5	 3	 96.046
 51.5	 5	 97.070
 51.5	10	 98.647
 51.5	25	101.282
 51.5	50	104.209
 51.5	75	107.135
 51.5	90	109.769
 51.5	95	111.345
 51.5	97	112.369
 52.5	 3	 96.526
 52.5	 5	 97.562
 52.5	10	 99.156
 52.5	25	101.817
 52.5	50	104.769
 52.5	75	107.716
 52.5	90	110.366
 52.5	95	111.950
 52.5	97	112.978
 53.5	 3	 97.004
 53.5	 5	 98.051
 53.5	10	 99.663
 53.5	25	102.349
 53.5	50	105.326
 53.5	75	108.295
 53.5	90	110.961
 53.5	95	112.553
 53.5	97	113.586
 54.5	 3	 97.481
 54.5	 5	 98.540
 54.5	10	100.167
 54.5	25	102.879
 54.5	50	105.881
 54.5	75	108.872
 54.5	90	111.554
 54.5	95	113.156
 54.5	97	114.194
 55.5	 3	 97.956
 55.5	 5	 99.027
 55.5	10	100.670
 55.5	25	103.407
 55.5	50	106.434
 55.5	75	109.447
 55.5	90	112.146
 55.5	95	113.757
 55.5	97	114.801
 56.5	 3	 98.432
 56.5	 5	 99.513
 56.5	10	101.172
 56.5	25	103.934
 56.5	50	106.985
 56.5	75	110.020
 56.5	90	112.737
 56.5	95	114.357
 56.5	97	115.407
 57.5	 3	 98.907
 57.5	 5	 99.998
 57.5	10	101.673
 57.5	25	104.459
 57.5	50	107.535
 57.5	75	110.592
 57.5	90	113.327
 57.5	95	114.957
 57.5	97	116.013
 58.5	 3	 99.382
 58.5	 5	100.483
 58.5	10	102.173
 58.5	25	104.982
 58.5	50	108.083
 58.5	75	111.162
 58.5	90	113.916
 58.5	95	115.557
 58.5	97	116.619
 59.5	 3	 99.857
 59.5	 5	100.968
 59.5	10	102.672
 59.5	25	105.505
 59.5	50	108.630
 59.5	75	111.732
 59.5	90	114.505
 59.5	95	116.156
 59.5	97	117.225
 60.5	 3	100.332
 60.5	 5	101.452
 60.5	10	103.171
 60.5	25	106.026
 60.5	50	109.175
 60.5	75	112.300
 60.5	90	115.092
 60.5	95	116.755
 60.5	97	117.831
 61.5	 3	100.808
 61.5	 5	101.937
 61.5	10	103.670
 61.5	25	106.547
 61.5	50	109.720
 61.5	75	112.867
 61.5	90	115.679
 61.5	95	117.354
 61.5	97	118.437
 62.5	 3	101.284
 62.5	 5	102.422
 62.5	10	104.168
 62.5	25	107.067
 62.5	50	110.263
 62.5	75	113.433
 62.5	90	116.266
 62.5	95	117.952
 62.5	97	119.044
 63.5	 3	101.762
 63.5	 5	102.908
 63.5	10	104.667
 63.5	25	107.587
 63.5	50	110.806
 63.5	75	113.999
 63.5	90	116.852
 63.5	95	118.550
 63.5	97	119.650
 64.5	 3	102.240
 64.5	 5	103.394
 64.5	10	105.165
 64.5	25	108.106
 64.5	50	111.348
 64.5	75	114.564
 64.5	90	117.438
 64.5	95	119.149
 64.5	97	120.256
 65.5	 3	102.720
 65.5	 5	103.881
 65.5	10	105.664
 65.5	25	108.624
 65.5	50	111.889
 65.5	75	115.128
 65.5	90	118.023
 65.5	95	119.747
 65.5	97	120.863
 66.5	 3	103.200
 66.5	 5	104.369
 66.5	10	106.163
 66.5	25	109.143
 66.5	50	112.430
 66.5	75	115.692
 66.5	90	118.608
 66.5	95	120.345
 66.5	97	121.469
 67.5	 3	103.682
 67.5	 5	104.857
 67.5	10	106.662
 67.5	25	109.661
 67.5	50	112.970
 67.5	75	116.255
 67.5	90	119.193
 67.5	95	120.943
 67.5	97	122.076
 68.5	 3	104.164
 68.5	 5	105.347
 68.5	10	107.161
 68.5	25	110.178
 68.5	50	113.509
 68.5	75	116.818
 68.5	90	119.777
 68.5	95	121.541
 68.5	97	122.683
 69.5	 3	104.648
 69.5	 5	105.836
 69.5	10	107.661
 69.5	25	110.696
 69.5	50	114.048
 69.5	75	117.379
 69.5	90	120.361
 69.5	95	122.138
 69.5	97	123.290
 70.5	 3	105.133
 70.5	 5	106.327
 70.5	10	108.161
 70.5	25	111.213
 70.5	50	114.586
 70.5	75	117.941
 70.5	90	120.945
 70.5	95	122.736
 70.5	97	123.896
 71.5	 3	105.618
 71.5	 5	106.818
 71.5	10	108.661
 71.5	25	111.730
 71.5	50	115.124
 71.5	75	118.501
 71.5	90	121.528
 71.5	95	123.333
 71.5	97	124.503
 72.5	 3	106.105
 72.5	 5	107.310
 72.5	10	109.162
 72.5	25	112.247
 72.5	50	115.661
 72.5	75	119.061
 72.5	90	122.110
 72.5	95	123.930
 72.5	97	125.109
 73.5	 3	106.592
 73.5	 5	107.802
 73.5	10	109.662
 73.5	25	112.763
 73.5	50	116.197
 73.5	75	119.620
 73.5	90	122.692
 73.5	95	124.526
 73.5	97	125.716
 74.5	 3	107.080
 74.5	 5	108.295
 74.5	10	110.163
 74.5	25	113.279
 74.5	50	116.733
 74.5	75	120.179
 74.5	90	123.273
 74.5	95	125.122
 74.5	97	126.321
 75.5	 3	107.568
 75.5	 5	108.787
 75.5	10	110.663
 75.5	25	113.794
 75.5	50	117.268
 75.5	75	120.736
 75.5	90	123.853
 75.5	95	125.717
 75.5	97	126.926
 76.5	 3	108.057
 76.5	 5	109.280
 76.5	10	111.163
 76.5	25	114.309
 76.5	50	117.802
 76.5	75	121.293
 76.5	90	124.433
 76.5	95	126.311
 76.5	97	127.531
 77.5	 3	108.545
 77.5	 5	109.773
 77.5	10	111.663
 77.5	25	114.823
 77.5	50	118.335
 77.5	75	121.848
 77.5	90	125.011
 77.5	95	126.905
 77.5	97	128.134
 78.5	 3	109.033
 78.5	 5	110.265
 78.5	10	112.162
 78.5	25	115.336
 78.5	50	118.867
 78.5	75	122.402
 78.5	90	125.588
 78.5	95	127.497
 78.5	97	128.737
 79.5	 3	109.521
 79.5	 5	110.757
 79.5	10	112.661
 79.5	25	115.848
 79.5	50	119.398
 79.5	75	122.955
 79.5	90	126.165
 79.5	95	128.088
 79.5	97	129.339
 80.5	 3	110.009
 80.5	 5	111.248
 80.5	10	113.158
 80.5	25	116.359
 80.5	50	119.927
 80.5	75	123.507
 80.5	90	126.739
 80.5	95	128.678
 80.5	97	129.939
 81.5	 3	110.495
 81.5	 5	111.738
 81.5	10	113.655
 81.5	25	116.869
 81.5	50	120.455
 81.5	75	124.058
 81.5	90	127.313
 81.5	95	129.267
 81.5	97	130.538
 82.5	 3	110.980
 82.5	 5	112.226
 82.5	10	114.150
 82.5	25	117.377
 82.5	50	120.982
 82.5	75	124.606
 82.5	90	127.885
 82.5	95	129.854
 82.5	97	131.136
 83.5	 3	111.464
 83.5	 5	112.714
 83.5	10	114.644
 83.5	25	117.884
 83.5	50	121.507
 83.5	75	125.153
 83.5	90	128.455
 83.5	95	130.439
 83.5	97	131.731
 84.5	 3	111.946
 84.5	 5	113.199
 84.5	10	115.136
 84.5	25	118.389
 84.5	50	122.031
 84.5	75	125.699
 84.5	90	129.023
 84.5	95	131.023
 84.5	97	132.325
 85.5	 3	112.426
 85.5	 5	113.683
 85.5	10	115.626
 85.5	25	118.893
 85.5	50	122.552
 85.5	75	126.242
 85.5	90	129.589
 85.5	95	131.604
 85.5	97	132.917
 86.5	 3	112.904
 86.5	 5	114.164
 86.5	10	116.114
 86.5	25	119.394
 86.5	50	123.071
 86.5	75	126.783
 86.5	90	130.153
 86.5	95	132.183
 86.5	97	133.507
 87.5	 3	113.379
 87.5	 5	114.643
 87.5	10	116.599
 87.5	25	119.893
 87.5	50	123.589
 87.5	75	127.323
 87.5	90	130.715
 87.5	95	132.760
 87.5	97	134.094
 88.5	 3	113.851
 88.5	 5	115.119
 88.5	10	117.082
 88.5	25	120.389
 88.5	50	124.104
 88.5	75	127.859
 88.5	90	131.275
 88.5	95	133.335
 88.5	97	134.679
 89.5	 3	114.321
 89.5	 5	115.593
 89.5	10	117.562
 89.5	25	120.883
 89.5	50	124.616
 89.5	75	128.394
 89.5	90	131.832
 89.5	95	133.907
 89.5	97	135.261
 90.5	 3	114.787
 90.5	 5	116.063
 90.5	10	118.040
 90.5	25	121.375
 90.5	50	125.126
 90.5	75	128.926
 90.5	90	132.386
 90.5	95	134.476
 90.5	97	135.841
 91.5	 3	115.249
 91.5	 5	116.530
 91.5	10	118.514
 91.5	25	121.863
 91.5	50	125.633
 91.5	75	129.455
 91.5	90	132.938
 91.5	95	135.043
 91.5	97	136.417
 92.5	 3	115.708
 92.5	 5	116.993
 92.5	10	118.985
 92.5	25	122.348
 92.5	50	126.137
 92.5	75	129.981
 92.5	90	133.487
 92.5	95	135.606
 92.5	97	136.991
 93.5	 3	116.162
 93.5	 5	117.452
 93.5	10	119.452
 93.5	25	122.830
 93.5	50	126.639
 93.5	75	130.504
 93.5	90	134.033
 93.5	95	136.166
 93.5	97	137.561
 94.5	 3	116.613
 94.5	 5	117.907
 94.5	10	119.915
 94.5	25	123.309
 94.5	50	127.137
 94.5	75	131.025
 94.5	90	134.575
 94.5	95	136.723
 94.5	97	138.127
 95.5	 3	117.059
 95.5	 5	118.359
 95.5	10	120.375
 95.5	25	123.785
 95.5	50	127.632
 95.5	75	131.542
 95.5	90	135.114
 95.5	95	137.277
 95.5	97	138.691
 96.5	 3	117.500
 96.5	 5	118.805
 96.5	10	120.830
 96.5	25	124.256
 96.5	50	128.124
 96.5	75	132.056
 96.5	90	135.650
 96.5	95	137.827
 96.5	97	139.250
 97.5	 3	117.937
 97.5	 5	119.247
 97.5	10	121.282
 97.5	25	124.724
 97.5	50	128.612
 97.5	75	132.566
 97.5	90	136.183
 97.5	95	138.373
 97.5	97	139.806
 98.5	 3	118.368
 98.5	 5	119.685
 98.5	10	121.729
 98.5	25	125.188
 98.5	50	129.097
 98.5	75	133.074
 98.5	90	136.712
 98.5	95	138.916
 98.5	97	140.358
 99.5	 3	118.795
 99.5	 5	120.118
 99.5	10	122.172
 99.5	25	125.648
 99.5	50	129.578
 99.5	75	133.577
 99.5	90	137.237
 99.5	95	139.455
 99.5	97	140.906
100.5	 3	119.217
100.5	 5	120.546
100.5	10	122.610
100.5	25	126.105
100.5	50	130.055
100.5	75	134.077
100.5	90	137.759
100.5	95	139.990
100.5	97	141.450
101.5	 3	119.633
101.5	 5	120.969
101.5	10	123.044
101.5	25	126.557
101.5	50	130.529
101.5	75	134.573
101.5	90	138.277
101.5	95	140.521
101.5	97	141.990
102.5	 3	120.044
102.5	 5	121.387
102.5	10	123.473
102.5	25	127.004
102.5	50	130.998
102.5	75	135.066
102.5	90	138.791
102.5	95	141.048
102.5	97	142.526
103.5	 3	120.450
103.5	 5	121.800
103.5	10	123.897
103.5	25	127.448
103.5	50	131.464
103.5	75	135.555
103.5	90	139.301
103.5	95	141.572
103.5	97	143.058
104.5	 3	120.851
104.5	 5	122.209
104.5	10	124.317
104.5	25	127.888
104.5	50	131.926
104.5	75	136.040
104.5	90	139.807
104.5	95	142.091
104.5	97	143.586
105.5	 3	121.247
105.5	 5	122.612
105.5	10	124.732
105.5	25	128.323
105.5	50	132.384
105.5	75	136.521
105.5	90	140.309
105.5	95	142.606
105.5	97	144.110
106.5	 3	121.637
106.5	 5	123.010
106.5	10	125.142
106.5	25	128.754
106.5	50	132.838
106.5	75	136.998
106.5	90	140.808
106.5	95	143.117
106.5	97	144.629
107.5	 3	122.023
107.5	 5	123.404
107.5	10	125.549
107.5	25	129.181
107.5	50	133.288
107.5	75	137.472
107.5	90	141.302
107.5	95	143.624
107.5	97	145.145
108.5	 3	122.403
108.5	 5	123.793
108.5	10	125.950
108.5	25	129.603
108.5	50	133.734
108.5	75	137.941
108.5	90	141.793
108.5	95	144.128
108.5	97	145.656
109.5	 3	122.779
109.5	 5	124.177
109.5	10	126.347
109.5	25	130.022
109.5	50	134.177
109.5	75	138.407
109.5	90	142.280
109.5	95	144.627
109.5	97	146.163
110.5	 3	123.151
110.5	 5	124.557
110.5	10	126.740
110.5	25	130.437
110.5	50	134.616
110.5	75	138.870
110.5	90	142.763
110.5	95	145.123
110.5	97	146.667
111.5	 3	123.518
111.5	 5	124.932
111.5	10	127.129
111.5	25	130.848
111.5	50	135.050
111.5	75	139.328
111.5	90	143.243
111.5	95	145.615
111.5	97	147.167
112.5	 3	123.880
112.5	 5	125.304
112.5	10	127.514
112.5	25	131.255
112.5	50	135.482
112.5	75	139.783
112.5	90	143.719
112.5	95	146.103
112.5	97	147.663
113.5	 3	124.239
113.5	 5	125.672
113.5	10	127.895
113.5	25	131.658
113.5	50	135.910
113.5	75	140.235
113.5	90	144.192
113.5	95	146.588
113.5	97	148.156
114.5	 3	124.594
114.5	 5	126.036
114.5	10	128.273
114.5	25	132.059
114.5	50	136.334
114.5	75	140.683
114.5	90	144.661
114.5	95	147.070
114.5	97	148.646
115.5	 3	124.946
115.5	 5	126.397
115.5	10	128.647
115.5	25	132.455
115.5	50	136.756
115.5	75	141.129
115.5	90	145.127
115.5	95	147.549
115.5	97	149.132
116.5	 3	125.295
116.5	 5	126.754
116.5	10	129.019
116.5	25	132.849
116.5	50	137.174
116.5	75	141.571
116.5	90	145.591
116.5	95	148.025
116.5	97	149.616
117.5	 3	125.641
117.5	 5	127.110
117.5	10	129.388
117.5	25	133.241
117.5	50	137.590
117.5	75	142.011
117.5	90	146.052
117.5	95	148.498
117.5	97	150.098
118.5	 3	125.985
118.5	 5	127.462
118.5	10	129.754
118.5	25	133.629
118.5	50	138.003
118.5	75	142.448
118.5	90	146.510
118.5	95	148.969
118.5	97	150.577
119.5	 3	126.327
119.5	 5	127.813
119.5	10	130.118
119.5	25	134.016
119.5	50	138.414
119.5	75	142.884
119.5	90	146.967
119.5	95	149.438
119.5	97	151.054
120.5	 3	126.668
120.5	 5	128.162
120.5	10	130.481
120.5	25	134.401
120.5	50	138.823
120.5	75	143.317
120.5	90	147.421
120.5	95	149.905
120.5	97	151.529
121.5	 3	127.007
121.5	 5	128.511
121.5	10	130.842
121.5	25	134.784
121.5	50	139.231
121.5	75	143.748
121.5	90	147.875
121.5	95	150.371
121.5	97	152.004
122.5	 3	127.346
122.5	 5	128.858
122.5	10	131.203
122.5	25	135.166
122.5	50	139.637
122.5	75	144.179
122.5	90	148.327
122.5	95	150.836
122.5	97	152.477
123.5	 3	127.685
123.5	 5	129.205
123.5	10	131.563
123.5	25	135.548
123.5	50	140.043
123.5	75	144.608
123.5	90	148.778
123.5	95	151.301
123.5	97	152.950
124.5	 3	128.024
124.5	 5	129.552
124.5	10	131.922
124.5	25	135.929
124.5	50	140.448
124.5	75	145.038
124.5	90	149.229
124.5	95	151.765
124.5	97	153.424
125.5	 3	128.364
125.5	 5	129.900
125.5	10	132.283
125.5	25	136.310
125.5	50	140.853
125.5	75	145.467
125.5	90	149.681
125.5	95	152.230
125.5	97	153.897
126.5	 3	128.706
126.5	 5	130.250
126.5	10	132.644
126.5	25	136.692
126.5	50	141.258
126.5	75	145.897
126.5	90	150.133
126.5	95	152.696
126.5	97	154.372
127.5	 3	129.049
127.5	 5	130.600
127.5	10	133.007
127.5	25	137.075
127.5	50	141.665
127.5	75	146.327
127.5	90	150.586
127.5	95	153.163
127.5	97	154.848
128.5	 3	129.395
128.5	 5	130.954
128.5	10	133.371
128.5	25	137.460
128.5	50	142.072
128.5	75	146.759
128.5	90	151.041
128.5	95	153.632
128.5	97	155.326
129.5	 3	129.744
129.5	 5	131.309
129.5	10	133.739
129.5	25	137.847
129.5	50	142.482
129.5	75	147.194
129.5	90	151.498
129.5	95	154.104
129.5	97	155.807
130.5	 3	130.096
130.5	 5	131.669
130.5	10	134.109
130.5	25	138.236
130.5	50	142.895
130.5	75	147.630
130.5	90	151.958
130.5	95	154.578
130.5	97	156.291
131.5	 3	130.452
131.5	 5	132.032
131.5	10	134.483
131.5	25	138.629
131.5	50	143.311
131.5	75	148.071
131.5	90	152.422
131.5	95	155.056
131.5	97	156.779
132.5	 3	130.813
132.5	 5	132.399
132.5	10	134.861
132.5	25	139.026
132.5	50	143.730
132.5	75	148.515
132.5	90	152.889
132.5	95	155.539
132.5	97	157.272
133.5	 3	131.178
133.5	 5	132.771
133.5	10	135.244
133.5	25	139.428
133.5	50	144.155
133.5	75	148.963
133.5	90	153.362
133.5	95	156.026
133.5	97	157.769
134.5	 3	131.550
134.5	 5	133.149
134.5	10	135.632
134.5	25	139.835
134.5	50	144.584
134.5	75	149.417
134.5	90	153.839
134.5	95	156.519
134.5	97	158.272
135.5	 3	131.927
135.5	 5	133.533
135.5	10	136.026
135.5	25	140.247
135.5	50	145.019
135.5	75	149.877
135.5	90	154.323
135.5	95	157.017
135.5	97	158.781
136.5	 3	132.311
136.5	 5	133.923
136.5	10	136.427
136.5	25	140.666
136.5	50	145.461
136.5	75	150.343
136.5	90	154.813
136.5	95	157.523
136.5	97	159.296
137.5	 3	132.702
137.5	 5	134.320
137.5	10	136.834
137.5	25	141.093
137.5	50	145.910
137.5	75	150.817
137.5	90	155.311
137.5	95	158.036
137.5	97	159.819
138.5	 3	133.100
138.5	 5	134.725
138.5	10	137.250
138.5	25	141.527
138.5	50	146.367
138.5	75	151.298
138.5	90	155.816
138.5	95	158.556
138.5	97	160.350
139.5	 3	133.506
139.5	 5	135.138
139.5	10	137.673
139.5	25	141.969
139.5	50	146.832
139.5	75	151.788
139.5	90	156.330
139.5	95	159.085
139.5	97	160.889
140.5	 3	133.920
140.5	 5	135.559
140.5	10	138.105
140.5	25	142.421
140.5	50	147.307
140.5	75	152.288
140.5	90	156.853
140.5	95	159.623
140.5	97	161.437
141.5	 3	134.342
141.5	 5	135.988
141.5	10	138.546
141.5	25	142.882
141.5	50	147.791
141.5	75	152.797
141.5	90	157.386
141.5	95	160.170
141.5	97	161.993
142.5	 3	134.773
142.5	 5	136.427
142.5	10	138.997
142.5	25	143.353
142.5	50	148.286
142.5	75	153.316
142.5	90	157.928
142.5	95	160.726
142.5	97	162.559
143.5	 3	135.213
143.5	 5	136.875
143.5	10	139.457
143.5	25	143.835
143.5	50	148.792
143.5	75	153.847
143.5	90	158.481
143.5	95	161.292
143.5	97	163.134
144.5	 3	135.662
144.5	 5	137.333
144.5	10	139.928
144.5	25	144.328
144.5	50	149.309
144.5	75	154.388
144.5	90	159.044
144.5	95	161.869
144.5	97	163.719
145.5	 3	136.120
145.5	 5	137.800
145.5	10	140.409
145.5	25	144.832
145.5	50	149.838
145.5	75	154.941
145.5	90	159.618
145.5	95	162.455
145.5	97	164.313
146.5	 3	136.588
146.5	 5	138.277
146.5	10	140.901
146.5	25	145.347
146.5	50	150.378
146.5	75	155.506
146.5	90	160.203
146.5	95	163.051
146.5	97	164.916
147.5	 3	137.064
147.5	 5	138.764
147.5	10	141.403
147.5	25	145.875
147.5	50	150.931
147.5	75	156.082
147.5	90	160.798
147.5	95	163.657
147.5	97	165.529
148.5	 3	137.550
148.5	 5	139.261
148.5	10	141.917
148.5	25	146.414
148.5	50	151.496
148.5	75	156.670
148.5	90	161.404
148.5	95	164.273
148.5	97	166.150
149.5	 3	138.044
149.5	 5	139.767
149.5	10	142.441
149.5	25	146.965
149.5	50	152.073
149.5	75	157.269
149.5	90	162.020
149.5	95	164.897
149.5	97	166.779
150.5	 3	138.548
150.5	 5	140.283
150.5	10	142.975
150.5	25	147.527
150.5	50	152.662
150.5	75	157.880
150.5	90	162.646
150.5	95	165.530
150.5	97	167.416
151.5	 3	139.060
151.5	 5	140.809
151.5	10	143.520
151.5	25	148.100
151.5	50	153.263
151.5	75	158.501
151.5	90	163.281
151.5	95	166.171
151.5	97	168.060
152.5	 3	139.580
152.5	 5	141.343
152.5	10	144.075
152.5	25	148.685
152.5	50	153.874
152.5	75	159.132
152.5	90	163.924
152.5	95	166.819
152.5	97	168.709
153.5	 3	140.108
153.5	 5	141.886
153.5	10	144.639
153.5	25	149.279
153.5	50	154.495
153.5	75	159.773
153.5	90	164.575
153.5	95	167.472
153.5	97	169.363
154.5	 3	140.643
154.5	 5	142.437
154.5	10	145.212
154.5	25	149.884
154.5	50	155.126
154.5	75	160.421
154.5	90	165.231
154.5	95	168.131
154.5	97	170.021
155.5	 3	141.186
155.5	 5	142.995
155.5	10	145.793
155.5	25	150.496
155.5	50	155.764
155.5	75	161.076
155.5	90	165.893
155.5	95	168.792
155.5	97	170.682
156.5	 3	141.735
156.5	 5	143.561
156.5	10	146.381
156.5	25	151.117
156.5	50	156.410
156.5	75	161.736
156.5	90	166.558
156.5	95	169.456
156.5	97	171.343
157.5	 3	142.289
157.5	 5	144.132
157.5	10	146.976
157.5	25	151.743
157.5	50	157.061
157.5	75	162.401
157.5	90	167.225
157.5	95	170.120
157.5	97	172.004
158.5	 3	142.848
158.5	 5	144.709
158.5	10	147.577
158.5	25	152.375
158.5	50	157.717
158.5	75	163.068
158.5	90	167.893
158.5	95	170.784
158.5	97	172.663
159.5	 3	143.412
159.5	 5	145.290
159.5	10	148.182
159.5	25	153.011
159.5	50	158.375
159.5	75	163.736
159.5	90	168.559
159.5	95	171.445
159.5	97	173.319
160.5	 3	143.979
160.5	 5	145.875
160.5	10	148.790
160.5	25	153.650
160.5	50	159.034
160.5	75	164.404
160.5	90	169.223
160.5	95	172.102
160.5	97	173.969
161.5	 3	144.548
161.5	 5	146.462
161.5	10	149.400
161.5	25	154.289
161.5	50	159.693
161.5	75	165.068
161.5	90	169.882
161.5	95	172.753
161.5	97	174.613
162.5	 3	145.120
162.5	 5	147.050
162.5	10	150.011
162.5	25	154.928
162.5	50	160.349
162.5	75	165.728
162.5	90	170.535
162.5	95	173.397
162.5	97	175.249
163.5	 3	145.692
163.5	 5	147.638
163.5	10	150.621
163.5	25	155.565
163.5	50	161.001
163.5	75	166.382
163.5	90	171.180
163.5	95	174.031
163.5	97	175.875
164.5	 3	146.263
164.5	 5	148.226
164.5	10	151.229
164.5	25	156.198
164.5	50	161.648
164.5	75	167.028
164.5	90	171.815
164.5	95	174.655
164.5	97	176.491
165.5	 3	146.834
165.5	 5	148.812
165.5	10	151.835
165.5	25	156.825
165.5	50	162.287
165.5	75	167.665
165.5	90	172.439
165.5	95	175.268
165.5	97	177.094
166.5	 3	147.402
166.5	 5	149.395
166.5	10	152.435
166.5	25	157.446
166.5	50	162.916
166.5	75	168.290
166.5	90	173.051
166.5	95	175.867
166.5	97	177.683
167.5	 3	147.967
167.5	 5	149.973
167.5	10	153.030
167.5	25	158.059
167.5	50	163.535
167.5	75	168.903
167.5	90	173.649
167.5	95	176.451
167.5	97	178.258
168.5	 3	148.528
168.5	 5	150.546
168.5	10	153.618
168.5	25	158.661
168.5	50	164.142
168.5	75	169.502
168.5	90	174.231
168.5	95	177.021
168.5	97	178.816
169.5	 3	149.084
169.5	 5	151.113
169.5	10	154.198
169.5	25	159.253
169.5	50	164.735
169.5	75	170.086
169.5	90	174.798
169.5	95	177.573
169.5	97	179.359
170.5	 3	149.634
170.5	 5	151.672
170.5	10	154.767
170.5	25	159.833
170.5	50	165.314
170.5	75	170.653
170.5	90	175.347
170.5	95	178.109
170.5	97	179.884
171.5	 3	150.176
171.5	 5	152.222
171.5	10	155.327
171.5	25	160.399
171.5	50	165.877
171.5	75	171.204
171.5	90	175.879
171.5	95	178.626
171.5	97	180.391
172.5	 3	150.711
172.5	 5	152.763
172.5	10	155.875
172.5	25	160.951
172.5	50	166.424
172.5	75	171.736
172.5	90	176.392
172.5	95	179.126
172.5	97	180.880
173.5	 3	151.236
173.5	 5	153.293
173.5	10	156.410
173.5	25	161.487
173.5	50	166.953
173.5	75	172.250
173.5	90	176.887
173.5	95	179.606
173.5	97	181.351
174.5	 3	151.752
174.5	 5	153.813
174.5	10	156.932
174.5	25	162.008
174.5	50	167.464
174.5	75	172.745
174.5	90	177.362
174.5	95	180.068
174.5	97	181.803
175.5	 3	152.257
175.5	 5	154.320
175.5	10	157.440
175.5	25	162.512
175.5	50	167.957
175.5	75	173.221
175.5	90	177.818
175.5	95	180.510
175.5	97	182.236
176.5	 3	152.752
176.5	 5	154.815
176.5	10	157.933
176.5	25	162.999
176.5	50	168.431
176.5	75	173.678
176.5	90	178.255
176.5	95	180.934
176.5	97	182.650
177.5	 3	153.234
177.5	 5	155.296
177.5	10	158.412
177.5	25	163.468
177.5	50	168.887
177.5	75	174.115
177.5	90	178.673
177.5	95	181.339
177.5	97	183.046
178.5	 3	153.704
178.5	 5	155.764
178.5	10	158.875
178.5	25	163.920
178.5	50	169.323
178.5	75	174.532
178.5	90	179.071
178.5	95	181.725
178.5	97	183.424
179.5	 3	154.162
179.5	 5	156.217
179.5	10	159.322
179.5	25	164.355
179.5	50	169.741
179.5	75	174.931
179.5	90	179.451
179.5	95	182.093
179.5	97	183.784
180.5	 3	154.606
180.5	 5	156.657
180.5	10	159.753
180.5	25	164.771
180.5	50	170.139
180.5	75	175.311
180.5	90	179.812
180.5	95	182.443
180.5	97	184.127
181.5	 3	155.036
181.5	 5	157.081
181.5	10	160.168
181.5	25	165.170
181.5	50	170.519
181.5	75	175.672
181.5	90	180.156
181.5	95	182.776
181.5	97	184.453
182.5	 3	155.453
182.5	 5	157.491
182.5	10	160.567
182.5	25	165.551
182.5	50	170.881
182.5	75	176.015
182.5	90	180.482
182.5	95	183.092
182.5	97	184.762
183.5	 3	155.855
183.5	 5	157.885
183.5	10	160.950
183.5	25	165.915
183.5	50	171.226
183.5	75	176.340
183.5	90	180.791
183.5	95	183.392
183.5	97	185.056
184.5	 3	156.244
184.5	 5	158.265
184.5	10	161.317
184.5	25	166.262
184.5	50	171.553
184.5	75	176.648
184.5	90	181.084
184.5	95	183.676
184.5	97	185.335
185.5	 3	156.618
185.5	 5	158.630
185.5	10	161.668
185.5	25	166.593
185.5	50	171.863
185.5	75	176.940
185.5	90	181.361
185.5	95	183.945
185.5	97	185.599
186.5	 3	156.978
186.5	 5	158.980
186.5	10	162.003
186.5	25	166.907
186.5	50	172.156
186.5	75	177.216
186.5	90	181.624
186.5	95	184.200
186.5	97	185.849
187.5	 3	157.323
187.5	 5	159.315
187.5	10	162.324
187.5	25	167.206
187.5	50	172.434
187.5	75	177.477
187.5	90	181.871
187.5	95	184.441
187.5	97	186.086
188.5	 3	157.655
188.5	 5	159.636
188.5	10	162.629
188.5	25	167.489
188.5	50	172.697
188.5	75	177.723
188.5	90	182.106
188.5	95	184.669
188.5	97	186.311
189.5	 3	157.973
189.5	 5	159.942
189.5	10	162.920
189.5	25	167.758
189.5	50	172.946
189.5	75	177.956
189.5	90	182.327
189.5	95	184.884
189.5	97	186.523
190.5	 3	158.277
190.5	 5	160.235
190.5	10	163.197
190.5	25	168.012
190.5	50	173.180
190.5	75	178.175
190.5	90	182.535
190.5	95	185.088
190.5	97	186.724
191.5	 3	158.568
191.5	 5	160.514
191.5	10	163.460
191.5	25	168.253
191.5	50	173.401
191.5	75	178.382
191.5	90	182.732
191.5	95	185.280
191.5	97	186.914
192.5	 3	158.845
192.5	 5	160.780
192.5	10	163.710
192.5	25	168.481
192.5	50	173.610
192.5	75	178.576
192.5	90	182.918
192.5	95	185.462
192.5	97	187.094
193.5	 3	159.109
193.5	 5	161.033
193.5	10	163.948
193.5	25	168.696
193.5	50	173.807
193.5	75	178.759
193.5	90	183.093
193.5	95	185.634
193.5	97	187.264
194.5	 3	159.361
194.5	 5	161.274
194.5	10	164.173
194.5	25	168.899
194.5	50	173.992
194.5	75	178.932
194.5	90	183.258
194.5	95	185.796
194.5	97	187.425
195.5	 3	159.601
195.5	 5	161.502
195.5	10	164.386
195.5	25	169.091
195.5	50	174.166
195.5	75	179.095
195.5	90	183.414
195.5	95	185.950
195.5	97	187.578
196.5	 3	159.829
196.5	 5	161.719
196.5	10	164.587
196.5	25	169.272
196.5	50	174.331
196.5	75	179.248
196.5	90	183.561
196.5	95	186.095
196.5	97	187.722
197.5	 3	160.045
197.5	 5	161.925
197.5	10	164.778
197.5	25	169.443
197.5	50	174.485
197.5	75	179.392
197.5	90	183.699
197.5	95	186.232
197.5	97	187.859
198.5	 3	160.251
198.5	 5	162.120
198.5	10	164.959
198.5	25	169.604
198.5	50	174.631
198.5	75	179.527
198.5	90	183.830
198.5	95	186.361
198.5	97	187.988
199.5	 3	160.446
199.5	 5	162.304
199.5	10	165.129
199.5	25	169.756
199.5	50	174.768
199.5	75	179.655
199.5	90	183.953
199.5	95	186.484
199.5	97	188.111
200.5	 3	160.630
200.5	 5	162.479
200.5	10	165.290
200.5	25	169.899
200.5	50	174.897
200.5	75	179.775
200.5	90	184.070
200.5	95	186.600
200.5	97	188.227
201.5	 3	160.805
201.5	 5	162.644
201.5	10	165.442
201.5	25	170.034
201.5	50	175.018
201.5	75	179.888
201.5	90	184.180
201.5	95	186.709
201.5	97	188.337
202.5	 3	160.970
202.5	 5	162.800
202.5	10	165.586
202.5	25	170.161
202.5	50	175.132
202.5	75	179.995
202.5	90	184.283
202.5	95	186.813
202.5	97	188.441
203.5	 3	161.126
203.5	 5	162.947
203.5	10	165.721
203.5	25	170.280
203.5	50	175.240
203.5	75	180.095
203.5	90	184.381
203.5	95	186.911
203.5	97	188.540
204.5	 3	161.273
204.5	 5	163.086
204.5	10	165.849
204.5	25	170.393
204.5	50	175.341
204.5	75	180.190
204.5	90	184.474
204.5	95	187.004
204.5	97	188.634
205.5	 3	161.412
205.5	 5	163.217
205.5	10	165.969
205.5	25	170.499
205.5	50	175.436
205.5	75	180.279
205.5	90	184.562
205.5	95	187.092
205.5	97	188.723
206.5	 3	161.544
206.5	 5	163.341
206.5	10	166.083
206.5	25	170.599
206.5	50	175.526
206.5	75	180.363
206.5	90	184.645
206.5	95	187.176
206.5	97	188.807
207.5	 3	161.668
207.5	 5	163.457
207.5	10	166.190
207.5	25	170.693
207.5	50	175.610
207.5	75	180.443
207.5	90	184.723
207.5	95	187.255
207.5	97	188.888
208.5	 3	161.784
208.5	 5	163.567
208.5	10	166.290
208.5	25	170.782
208.5	50	175.690
208.5	75	180.518
208.5	90	184.797
208.5	95	187.330
208.5	97	188.964
209.5	 3	161.894
209.5	 5	163.671
209.5	10	166.385
209.5	25	170.865
209.5	50	175.765
209.5	75	180.589
209.5	90	184.868
209.5	95	187.402
209.5	97	189.037
210.5	 3	161.998
210.5	 5	163.768
210.5	10	166.474
210.5	25	170.944
210.5	50	175.836
210.5	75	180.656
210.5	90	184.934
210.5	95	187.469
210.5	97	189.106
211.5	 3	162.095
211.5	 5	163.860
211.5	10	166.558
211.5	25	171.018
211.5	50	175.903
211.5	75	180.719
211.5	90	184.998
211.5	95	187.534
211.5	97	189.171
212.5	 3	162.187
212.5	 5	163.946
212.5	10	166.637
212.5	25	171.087
212.5	50	175.966
212.5	75	180.779
212.5	90	185.058
212.5	95	187.595
212.5	97	189.234
213.5	 3	162.273
213.5	 5	164.027
213.5	10	166.712
213.5	25	171.153
213.5	50	176.025
213.5	75	180.836
213.5	90	185.115
213.5	95	187.653
213.5	97	189.294
214.5	 3	162.354
214.5	 5	164.103
214.5	10	166.782
214.5	25	171.215
214.5	50	176.082
214.5	75	180.889
214.5	90	185.169
214.5	95	187.709
214.5	97	189.350
215.5	 3	162.430
215.5	 5	164.175
215.5	10	166.847
215.5	25	171.273
215.5	50	176.135
215.5	75	180.940
215.5	90	185.220
215.5	95	187.762
215.5	97	189.404
216.5	 3	162.501
216.5	 5	164.242
216.5	10	166.909
216.5	25	171.328
216.5	50	176.185
216.5	75	180.989
216.5	90	185.269
216.5	95	187.812
216.5	97	189.456
217.5	 3	162.568
217.5	 5	164.306
217.5	10	166.968
217.5	25	171.380
217.5	50	176.233
217.5	75	181.035
217.5	90	185.316
217.5	95	187.860
217.5	97	189.505
218.5	 3	162.631
218.5	 5	164.365
218.5	10	167.022
218.5	25	171.429
218.5	50	176.278
218.5	75	181.078
218.5	90	185.360
218.5	95	187.906
218.5	97	189.552
219.5	 3	162.690
219.5	 5	164.421
219.5	10	167.074
219.5	25	171.475
219.5	50	176.320
219.5	75	181.120
219.5	90	185.403
219.5	95	187.949
219.5	97	189.597
220.5	 3	162.745
220.5	 5	164.473
220.5	10	167.122
220.5	25	171.519
220.5	50	176.361
220.5	75	181.159
220.5	90	185.443
220.5	95	187.991
220.5	97	189.640
221.5	 3	162.797
221.5	 5	164.522
221.5	10	167.168
221.5	25	171.560
221.5	50	176.399
221.5	75	181.197
221.5	90	185.481
221.5	95	188.031
221.5	97	189.681
222.5	 3	162.846
222.5	 5	164.569
222.5	10	167.211
222.5	25	171.599
222.5	50	176.435
222.5	75	181.233
222.5	90	185.518
222.5	95	188.069
222.5	97	189.720
223.5	 3	162.891
223.5	 5	164.612
223.5	10	167.251
223.5	25	171.635
223.5	50	176.470
223.5	75	181.267
223.5	90	185.553
223.5	95	188.105
223.5	97	189.758
224.5	 3	162.934
224.5	 5	164.653
224.5	10	167.289
224.5	25	171.670
224.5	50	176.502
224.5	75	181.299
224.5	90	185.587
224.5	95	188.140
224.5	97	189.793
225.5	 3	162.974
225.5	 5	164.691
225.5	10	167.325
225.5	25	171.703
225.5	50	176.533
225.5	75	181.330
225.5	90	185.619
225.5	95	188.174
225.5	97	189.828
226.5	 3	163.011
226.5	 5	164.726
226.5	10	167.359
226.5	25	171.734
226.5	50	176.563
226.5	75	181.360
226.5	90	185.650
226.5	95	188.205
226.5	97	189.861
227.5	 3	163.047
227.5	 5	164.760
227.5	10	167.390
227.5	25	171.763
227.5	50	176.591
227.5	75	181.388
227.5	90	185.679
227.5	95	188.236
227.5	97	189.892
228.5	 3	163.079
228.5	 5	164.791
228.5	10	167.420
228.5	25	171.791
228.5	50	176.618
228.5	75	181.415
228.5	90	185.707
228.5	95	188.265
228.5	97	189.922
229.5	 3	163.110
229.5	 5	164.821
229.5	10	167.448
229.5	25	171.817
229.5	50	176.643
229.5	75	181.440
229.5	90	185.734
229.5	95	188.293
229.5	97	189.951
230.5	 3	163.139
230.5	 5	164.849
230.5	10	167.474
230.5	25	171.842
230.5	50	176.668
230.5	75	181.465
230.5	90	185.760
230.5	95	188.320
230.5	97	189.979
231.5	 3	163.166
231.5	 5	164.875
231.5	10	167.499
231.5	25	171.866
231.5	50	176.691
231.5	75	181.489
231.5	90	185.785
231.5	95	188.346
231.5	97	190.006
232.5	 3	163.191
232.5	 5	164.899
232.5	10	167.522
232.5	25	171.888
232.5	50	176.713
232.5	75	181.511
232.5	90	185.809
232.5	95	188.371
232.5	97	190.031
233.5	 3	163.214
233.5	 5	164.922
233.5	10	167.544
233.5	25	171.909
233.5	50	176.734
233.5	75	181.533
233.5	90	185.832
233.5	95	188.395
233.5	97	190.056
234.5	 3	163.236
234.5	 5	164.943
234.5	10	167.565
234.5	25	171.929
234.5	50	176.754
234.5	75	181.554
234.5	90	185.854
234.5	95	188.418
234.5	97	190.080
235.5	 3	163.257
235.5	 5	164.963
235.5	10	167.585
235.5	25	171.948
235.5	50	176.773
235.5	75	181.574
235.5	90	185.875
235.5	95	188.440
235.5	97	190.102
236.5	 3	163.276
236.5	 5	164.982
236.5	10	167.603
236.5	25	171.966
236.5	50	176.791
236.5	75	181.593
236.5	90	185.895
236.5	95	188.461
236.5	97	190.124
237.5	 3	163.294
237.5	 5	165.000
237.5	10	167.620
237.5	25	171.983
237.5	50	176.809
237.5	75	181.611
237.5	90	185.914
237.5	95	188.481
237.5	97	190.145
238.5	 3	163.310
238.5	 5	165.016
238.5	10	167.637
238.5	25	172.000
238.5	50	176.825
238.5	75	181.629
238.5	90	185.933
238.5	95	188.501
238.5	97	190.165
239.5	 3	163.326
239.5	 5	165.031
239.5	10	167.652
239.5	25	172.015
239.5	50	176.841
239.5	75	181.646
239.5	90	185.951
239.5	95	188.520
239.5	97	190.185
240.0	 3	163.333
240.0	 5	165.039
240.0	10	167.659
240.0	25	172.023
240.0	50	176.849
240.0	75	181.654
240.0	90	185.960
240.0	95	188.529
240.0	97	190.194
