# Generated by default/object.tt
package Paws::SMS::ValidationOutput;
  use Moose;
  has AppValidationOutput => (is => 'ro', isa => 'Paws::SMS::AppValidationOutput', request_name => 'appValidationOutput', traits => ['NameInRequest']);
  has LatestValidationTime => (is => 'ro', isa => 'Str', request_name => 'latestValidationTime', traits => ['NameInRequest']);
  has Name => (is => 'ro', isa => 'Str', request_name => 'name', traits => ['NameInRequest']);
  has ServerValidationOutput => (is => 'ro', isa => 'Paws::SMS::ServerValidationOutput', request_name => 'serverValidationOutput', traits => ['NameInRequest']);
  has Status => (is => 'ro', isa => 'Str', request_name => 'status', traits => ['NameInRequest']);
  has StatusMessage => (is => 'ro', isa => 'Str', request_name => 'statusMessage', traits => ['NameInRequest']);
  has ValidationId => (is => 'ro', isa => 'Str', request_name => 'validationId', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::SMS::ValidationOutput

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SMS::ValidationOutput object:

  $service_obj->Method(Att1 => { AppValidationOutput => $value, ..., ValidationId => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SMS::ValidationOutput object:

  $result = $service_obj->Method(...);
  $result->Att1->AppValidationOutput

=head1 DESCRIPTION

Contains validation output.

=head1 ATTRIBUTES


=head2 AppValidationOutput => L<Paws::SMS::AppValidationOutput>

The output from validating an application.


=head2 LatestValidationTime => Str

The latest time that the validation was performed.


=head2 Name => Str

The name of the validation.


=head2 ServerValidationOutput => L<Paws::SMS::ServerValidationOutput>

The output from validation an instance.


=head2 Status => Str

The status of the validation.


=head2 StatusMessage => Str

The status message.


=head2 ValidationId => Str

The ID of the validation.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SMS>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

