/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.io;

import java.io.EOFException;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.ReadableByteChannel;
import org.apache.sis.internal.storage.io.ChannelDataInput;
import org.apache.sis.internal.storage.io.DataTransfer;
import org.apache.sis.util.Classes;
import org.apache.sis.util.resources.Errors;

final class MemoryDataTransfer
implements DataTransfer,
ReadableByteChannel {
    private final ChannelDataInput.ArrayReader reader;

    MemoryDataTransfer(String string, Buffer buffer) throws IOException {
        ChannelDataInput channelDataInput = new ChannelDataInput(string, this, buffer instanceof ByteBuffer ? (ByteBuffer)buffer : null, true);
        if (buffer instanceof ByteBuffer) {
            ChannelDataInput channelDataInput2 = channelDataInput;
            channelDataInput2.getClass();
            this.reader = channelDataInput2.new ChannelDataInput.BytesReader(null);
        } else if (buffer instanceof ShortBuffer) {
            ChannelDataInput channelDataInput3 = channelDataInput;
            channelDataInput3.getClass();
            this.reader = channelDataInput3.new ChannelDataInput.ShortsReader((ShortBuffer)buffer);
        } else if (buffer instanceof IntBuffer) {
            ChannelDataInput channelDataInput4 = channelDataInput;
            channelDataInput4.getClass();
            this.reader = channelDataInput4.new ChannelDataInput.IntsReader((IntBuffer)buffer);
        } else if (buffer instanceof LongBuffer) {
            ChannelDataInput channelDataInput5 = channelDataInput;
            channelDataInput5.getClass();
            this.reader = channelDataInput5.new ChannelDataInput.LongsReader((LongBuffer)buffer);
        } else if (buffer instanceof FloatBuffer) {
            ChannelDataInput channelDataInput6 = channelDataInput;
            channelDataInput6.getClass();
            this.reader = channelDataInput6.new ChannelDataInput.FloatsReader((FloatBuffer)buffer);
        } else if (buffer instanceof DoubleBuffer) {
            ChannelDataInput channelDataInput7 = channelDataInput;
            channelDataInput7.getClass();
            this.reader = channelDataInput7.new ChannelDataInput.DoublesReader((DoubleBuffer)buffer);
        } else if (buffer instanceof CharBuffer) {
            ChannelDataInput channelDataInput8 = channelDataInput;
            channelDataInput8.getClass();
            this.reader = channelDataInput8.new ChannelDataInput.CharsReader((CharBuffer)buffer);
        } else {
            throw new IllegalArgumentException(Errors.format((short)149, Classes.getClass(buffer)));
        }
    }

    DataTransfer reader() {
        return this.view() instanceof ByteBuffer ? this.reader : this;
    }

    @Override
    public void seek(long l) throws IOException {
        int n = this.dataSizeShift();
        if (l < 0L || (l & (long)((1 << n) - 1)) != 0L) {
            throw new IOException(Errors.format((short)45, "position", l));
        }
        Buffer buffer = this.view();
        if ((l >>>= n) > (long)buffer.limit()) {
            throw new EOFException(Errors.format((short)137, this.filename()));
        }
        buffer.position((int)l);
    }

    @Override
    public String filename() {
        return this.reader.filename();
    }

    @Override
    public int dataSizeShift() {
        return this.reader.dataSizeShift();
    }

    @Override
    public Object dataArray() {
        return this.reader.dataArray();
    }

    @Override
    public Buffer view() {
        return this.reader.view();
    }

    @Override
    public Buffer createView() {
        return this.reader.createView();
    }

    @Override
    public void createDataArray(int n) {
        this.reader.createDataArray(n);
    }

    @Override
    public void setDest(Object object) {
        this.reader.setDest(object);
    }

    @Override
    public void readFully(Buffer buffer, int n, int n2) {
        this.reader.transfer(n, n2);
    }

    @Override
    public int read(ByteBuffer byteBuffer) {
        return -1;
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public void close() throws IOException {
    }
}

