# Generated by default/object.tt
package Paws::SecurityHub::AwsDynamoDbTableLocalSecondaryIndex;
  use Moose;
  has IndexArn => (is => 'ro', isa => 'Str');
  has IndexName => (is => 'ro', isa => 'Str');
  has KeySchema => (is => 'ro', isa => 'ArrayRef[Paws::SecurityHub::AwsDynamoDbTableKeySchema]');
  has Projection => (is => 'ro', isa => 'Paws::SecurityHub::AwsDynamoDbTableProjection');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::AwsDynamoDbTableLocalSecondaryIndex

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::AwsDynamoDbTableLocalSecondaryIndex object:

  $service_obj->Method(Att1 => { IndexArn => $value, ..., Projection => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::AwsDynamoDbTableLocalSecondaryIndex object:

  $result = $service_obj->Method(...);
  $result->Att1->IndexArn

=head1 DESCRIPTION

Information about a local secondary index for a DynamoDB table.

=head1 ATTRIBUTES


=head2 IndexArn => Str

The ARN of the index.


=head2 IndexName => Str

The name of the index.


=head2 KeySchema => ArrayRef[L<Paws::SecurityHub::AwsDynamoDbTableKeySchema>]

The complete key schema for the index.


=head2 Projection => L<Paws::SecurityHub::AwsDynamoDbTableProjection>

Attributes that are copied from the table into the index. These are in
addition to the primary key attributes and index key attributes, which
are automatically projected.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

