# Generated by default/object.tt
package Paws::EMRContainers::JobRun;
  use Moose;
  has Arn => (is => 'ro', isa => 'Str', request_name => 'arn', traits => ['NameInRequest']);
  has ClientToken => (is => 'ro', isa => 'Str', request_name => 'clientToken', traits => ['NameInRequest']);
  has ConfigurationOverrides => (is => 'ro', isa => 'Paws::EMRContainers::ConfigurationOverrides', request_name => 'configurationOverrides', traits => ['NameInRequest']);
  has CreatedAt => (is => 'ro', isa => 'Str', request_name => 'createdAt', traits => ['NameInRequest']);
  has CreatedBy => (is => 'ro', isa => 'Str', request_name => 'createdBy', traits => ['NameInRequest']);
  has ExecutionRoleArn => (is => 'ro', isa => 'Str', request_name => 'executionRoleArn', traits => ['NameInRequest']);
  has FailureReason => (is => 'ro', isa => 'Str', request_name => 'failureReason', traits => ['NameInRequest']);
  has FinishedAt => (is => 'ro', isa => 'Str', request_name => 'finishedAt', traits => ['NameInRequest']);
  has Id => (is => 'ro', isa => 'Str', request_name => 'id', traits => ['NameInRequest']);
  has JobDriver => (is => 'ro', isa => 'Paws::EMRContainers::JobDriver', request_name => 'jobDriver', traits => ['NameInRequest']);
  has Name => (is => 'ro', isa => 'Str', request_name => 'name', traits => ['NameInRequest']);
  has ReleaseLabel => (is => 'ro', isa => 'Str', request_name => 'releaseLabel', traits => ['NameInRequest']);
  has State => (is => 'ro', isa => 'Str', request_name => 'state', traits => ['NameInRequest']);
  has StateDetails => (is => 'ro', isa => 'Str', request_name => 'stateDetails', traits => ['NameInRequest']);
  has Tags => (is => 'ro', isa => 'Paws::EMRContainers::TagMap', request_name => 'tags', traits => ['NameInRequest']);
  has VirtualClusterId => (is => 'ro', isa => 'Str', request_name => 'virtualClusterId', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::EMRContainers::JobRun

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::EMRContainers::JobRun object:

  $service_obj->Method(Att1 => { Arn => $value, ..., VirtualClusterId => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::EMRContainers::JobRun object:

  $result = $service_obj->Method(...);
  $result->Att1->Arn

=head1 DESCRIPTION

This entity describes a job run. A job run is a unit of work, such as a
Spark jar, PySpark script, or SparkSQL query, that you submit to Amazon
EMR on EKS.

=head1 ATTRIBUTES


=head2 Arn => Str

The ARN of job run.


=head2 ClientToken => Str

The client token used to start a job run.


=head2 ConfigurationOverrides => L<Paws::EMRContainers::ConfigurationOverrides>

The configuration settings that are used to override default
configuration.


=head2 CreatedAt => Str

The date and time when the job run was created.


=head2 CreatedBy => Str

The user who created the job run.


=head2 ExecutionRoleArn => Str

The execution role ARN of the job run.


=head2 FailureReason => Str

The reasons why the job run has failed.


=head2 FinishedAt => Str

The date and time when the job run has finished.


=head2 Id => Str

The ID of the job run.


=head2 JobDriver => L<Paws::EMRContainers::JobDriver>

Parameters of job driver for the job run.


=head2 Name => Str

The name of the job run.


=head2 ReleaseLabel => Str

The release version of Amazon EMR.


=head2 State => Str

The state of the job run.


=head2 StateDetails => Str

Additional details of the job run state.


=head2 Tags => L<Paws::EMRContainers::TagMap>

The assigned tags of the job run.


=head2 VirtualClusterId => Str

The ID of the job run's virtual cluster.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::EMRContainers>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

