/******************************************************************************
 * NOTE: This file has been modified for use with MSDOS and the WATCOM C/386
 * compiler.  Darryl Okahata, March 1993.
 *****************************************************************************/

/* $RCSfile: msdos.c,v $$Revision: 4.0.1.1 $$Date: 91/06/07 11:22:37 $
 *
 *    (C) Copyright 1989, 1990 Diomidis Spinellis.
 *
 *    You may distribute under the terms of either the GNU General Public
 *    License or the Artistic License, as specified in the README file.
 *
 * $Log:	msdos.c,v $
 * Revision 4.0.1.1  91/06/07  11:22:37  lwall
 * patch4: new copyright notice
 * 
 * Revision 4.0  91/03/20  01:34:46  lwall
 * 4.0 baseline.
 * 
 * Revision 3.0.1.1  90/03/27  16:10:41  lwall
 * patch16: MSDOS support
 * 
 * Revision 1.1  90/03/18  20:32:01  dds
 * Initial revision
 *
 */

/*
 * Various Unix compatibility functions for MS-DOS.
 */

#include "EXTERN.h"
#include "perl.h"

#include <dos.h>
#include <process.h>

#include "dpmi.h"		/* sets DOS_EXTENDER, if appropriate */


/*
 * Interface to the MS-DOS ioctl system call.
 * The function is encoded as follows:
 * The lowest nibble of the function code goes to AL
 * The two middle nibbles go to CL
 * The high nibble goes to CH
 *
 * The return code is -1 in the case of an error and if successful
 * for functions AL = 00, 09, 0a the value of the register DX
 * for functions AL = 02 - 08, 0e the value of the register AX
 * for functions AL = 01, 0b - 0f the number 0
 *
 * Notice that this restricts the ioctl subcodes stored in AL to 00-0f
 * In the Ralf Borwn interrupt list 90.1 there are no subcodes above AL=0f
 * so we are ok.
 * Furthermore CH is also restriced in the same area.  Where CH is used as a
 * code it always is between 00-0f.  In the case where it forms a count
 * together with CL we arbitrarily set the highest count limit to 4095.  It
 * sounds reasonable for an ioctl.
 * The other alternative would have been to use the pointer argument to
 * point the the values of CX.  The problem with this approach is that
 * of accessing wild regions when DX is used as a number and not as a
 * pointer.
 */
int
ioctl(int handle, unsigned int function, char *data)
{
	union REGS      srv;
	struct SREGS    segregs;

#ifdef DOS_EXTENDER
	fatal("Unsupported function ioctl()");
	/*
	 * fatal() should never return, but just in case ...
	 */
	return (-1);	/* not supported */
#else /* not DOS_EXTENDER */
	srv.h.ah = 0x44;
	srv.h.al = (unsigned char)(function & 0x0F);
	srv.x.bx = handle;
	srv.x.cx = function >> 4;
	segread(&segregs);
#if ( defined(M_I86LM) || defined(M_I86CM) || defined(M_I86HM) )
	segregs.ds = FP_SEG(data);
	srv.x.dx = FP_OFF(data);
#else
	srv.x.dx = (unsigned int) data;
#endif
	intdosx(&srv, &srv, &segregs);
	if (srv.x.cflag & 1) {
		switch(srv.x.ax ){
		case 1:
			errno = EINVAL;
			break;
		case 2:
		case 3:
			errno = ENOENT;
			break;
		case 4:
			errno = EMFILE;
			break;
		case 5:
			errno = EPERM;
			break;
		case 6:
			errno = EBADF;
			break;
		case 8:
			errno = ENOMEM;
			break;
		case 0xc:
		case 0xd:
		case 0xf:
			errno = EINVAL;
			break;
		case 0x11:
			errno = EXDEV;
			break;
		case 0x12:
			errno = ENFILE;
			break;
		default:
			errno = EZERO;
			break;
		}
		return -1;
	} else {
		switch (function & 0xf) {
		case 0: case 9: case 0xa:
			return srv.x.dx;
		case 2: case 3: case 4: case 5:
		case 6: case 7: case 8: case 0xe:
			return srv.x.ax;
		case 1: case 0xb: case 0xc: case 0xd:
		case 0xf:
		default:
			return 0;
		}
	}
#endif
}

/*
 * Watcom C has this function.
 * We use Watcom's function instead of this one just in case we run this
 * code on a true multitasking OS.  Maybe, just maybe, sleep() will be
 * intelligent enough to not run in a tight loop.
 */
#ifndef __WATCOMC__
/*
 * Sleep function.
 */
void
sleep(unsigned len)
{
	time_t end;

	end = time((time_t *)0) + len;
	while (time((time_t *)0) < end)
		;
}
#endif


/*
 * Just pretend that everyone is a superuser
 */
#define ROOT_UID	0
#define ROOT_GID	0
int
getuid(void)
{
	return ROOT_UID;
}

int
geteuid(void)
{
	return ROOT_UID;
}

int
getgid(void)
{
	return ROOT_GID;
}

int
getegid(void)
{
	return ROOT_GID;
}

int
setuid(int uid)
{ return (uid==ROOT_UID?0:-1); }

int
setgid(int gid)
{ return (gid==ROOT_GID?0:-1); }

/*
 * The following code is based on the do_exec and do_aexec functions
 * in file doio.c
 */
int
do_aspawn(really,arglast)
STR *really;
int *arglast;
{
    register STR **st = stack->ary_array;
    register int sp = arglast[1];
    register int items = arglast[2] - sp;
    register char **a;
    char **argv;
    char *tmps;
    int status;

    if (items) {
	New(1101,argv, items+1, char*);
	a = argv;
	for (st += ++sp; items > 0; items--,st++) {
	    if (*st)
		*a++ = str_get(*st);
	    else
		*a++ = "";
	}
	*a = Nullch;
	if (really && *(tmps = str_get(really)))
	    status = spawnvp(P_WAIT,tmps,argv);
	else
	    status = spawnvp(P_WAIT,argv[0],argv);
	Safefree(argv);
    }
    return status;
}


int
do_spawn(cmd)
char *cmd;
{
    register char **a;
    register char *s;
    char **argv;
    char flags[10];
    int status;
    char *shell, *cmd2;

    /* save an extra exec if possible */
    if ((shell = getenv("COMSPEC")) == 0)
	shell = "\\command.com";

    /* see if there are shell metacharacters in it */
    if (strchr(cmd, '>') || strchr(cmd, '<') || strchr(cmd, '|'))
	  doshell:
	    return spawnl(P_WAIT,shell,shell,"/c",cmd,(char*)0);

    New(1102,argv, strlen(cmd) / 2 + 2, char*);

    New(1103,cmd2, strlen(cmd) + 1, char);
    strcpy(cmd2, cmd);
    a = argv;
    for (s = cmd2; *s;) {
	while (*s && isspace(*s)) s++;
	if (*s)
	    *(a++) = s;
	while (*s && !isspace(*s)) s++;
	if (*s)
	    *s++ = '\0';
    }
    *a = Nullch;
    if (argv[0])
	if ((status = spawnvp(P_WAIT,argv[0],argv)) == -1) {
	    Safefree(argv);
	    Safefree(cmd2);
	    goto doshell;
	}
    Safefree(cmd2);
    Safefree(argv);
    return status;
}


#ifdef DOS_EXTENDER

#include <stdarg.h>

execl(const char *__path, const char *__arg0, ...)
{
    fatal("Unsupported function execl(2)");
    /*
     * fatal() should never return, but just in case ...
     */
    abort();
}


execv(const char *__path, char *const __argv[])
{
    fatal("Unsupported function execv(2)");
    /*
     * fatal() should never return, but just in case ...
     */
    abort();
}


execvp(const char *__file, char *const __argv[])
{
    fatal("Unsupported function execvp(2)");
    /*
     * fatal() should never return, but just in case ...
     */
    abort();
}



#define CTRL_BREAK_CALL		0x33

static unsigned char	original_break_status;

void kill_c_break()
{
    union REGS	in_regs, out_regs;

    /*
     * Get status of the Ctrl-break flag
     */
    in_regs.h.ah = CTRL_BREAK_CALL;
    in_regs.h.al = 0;
    intdos(&in_regs, &out_regs);
    original_break_status = out_regs.h.dl;
    /*
     * Turn off Ctrl-break
     */
    in_regs.h.ah = CTRL_BREAK_CALL;
    in_regs.h.al = 1;
    in_regs.h.dl = 0;
    intdos(&in_regs, &out_regs);
}

void reset_c_break()
{
    union REGS	in_regs, out_regs;

    /*
     * Reset Ctrl-break to original state
     */
    in_regs.h.ah = CTRL_BREAK_CALL;
    in_regs.h.al = 1;
    in_regs.h.dl = original_break_status;
    intdos(&in_regs, &out_regs);
}


static char		*dos_mem_start;

void initialize_dos_mem_info()
{
    dos_mem_start = malloc(1);
}

void dump_dos_mem_info()
{
    char		*dos_mem_end;
    unsigned long	bytes_used;
    DPMI_MEMINFO	meminfo;
    int			kb_per_page;

    kb_per_page = 4;
    dos_mem_end = sbrk(16*1024);	/* Get estimated end of memory
					 * address.  Note that the block
					 * size passed to sbrk() here
					 * *MUST* be the same block size
					 * passed to sbrk() from malloc().
					 */
    bytes_used = (unsigned long) dos_mem_end - (unsigned long) dos_mem_start;
    dpmi_get_meminfo(&meminfo);
    fprintf(stderr, "\n***** Memory usage statistics:\n\n");
    fprintf(stderr, "Largest available block            = %lu KB\n",
	    (unsigned long) meminfo.largest_avail_block / 1024);
    fprintf(stderr, "Maximum unlocked page allocation   = %d pages (%d KB)\n",
	    meminfo.max_unlocked_page,
	    meminfo.max_unlocked_page * kb_per_page);
    fprintf(stderr, "Maximum locked page allocation     = %d pages (%d KB)\n",
	    meminfo.largest_lockable_page,
	    meminfo.largest_lockable_page * kb_per_page);
    fprintf(stderr, "Linear address space size          = %d pages (%d KB)\n",
	    meminfo.linear_addr_space,
	    meminfo.linear_addr_space * kb_per_page);
    fprintf(stderr, "Total unlocked pages               = %d pages (%d KB)\n",
	    meminfo.num_free_pages,
	    meminfo.num_free_pages * kb_per_page);
    fprintf(stderr, "Number of free pages               = %d pages (%d KB)\n",
	    meminfo.num_physical_free_pages,
	    meminfo.num_physical_free_pages * kb_per_page);
    fprintf(stderr, "Total number of physical pages     = %d pages (%d KB)\n",
	    meminfo.total_physical_pages,
	    meminfo.total_physical_pages * kb_per_page);
    fprintf(stderr, "Free linear address space          = %d pages (%d KB)\n",
	    meminfo.free_linear_addr_space,
	    meminfo.free_linear_addr_space * kb_per_page);
    fprintf(stderr, "Size of paging file/partition      = %d pages (%d KB)\n",
	    meminfo.pagefile_size,
	    meminfo.pagefile_size * kb_per_page);
    if (dos_mem_end > dos_mem_start) {
	fprintf(stderr, "\nEstimated incremental memory usage = %lu KB\n",
		bytes_used / 1024);
	fprintf(stderr,
		"        (This number may include the memory allocated for stack space.)\n");
    } else {
	fprintf(stderr, "\nEstimated incremental memory usage statistics do not make sense!\n");
    }
#if defined(MYMALLOC) && defined(MSTATS)
    /*
     * If we can, also display perl's malloc() info.
     */
    mstats("(bigperl)");
#endif	/* defined(MYMALLOC) && defined(MSTATS) */
}

#endif
