/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.test;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class TableBuilder {
    private final Connection m_conn;

    public static void main(String[] stringArray) {
        try {
            TableBuilder tableBuilder = new TableBuilder();
            tableBuilder.createTable();
            tableBuilder.createJavaFunction();
            tableBuilder.doSelects();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public TableBuilder() throws Exception {
        Class.forName("org.postgresql.Driver");
        this.m_conn = DriverManager.getConnection("jdbc:postgresql://localhost/thhal", "thhal", null);
    }

    public void createTable() throws Exception {
        Statement statement = this.m_conn.createStatement();
        try {
            statement.executeUpdate("drop table xtable");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        statement.executeUpdate("create table xtable (cl int4, tstove varchar)");
        PreparedStatement preparedStatement = this.m_conn.prepareStatement("INSERT INTO xtable(cl, tstove) VALUES (?, ?)");
        for (int i = 0; i < 100000; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.setString(2, "xyz_" + i % 100);
            preparedStatement.executeUpdate();
        }
        preparedStatement.close();
        this.m_conn.commit();
    }

    public void createJavaFunction() throws Exception {
        Statement statement = this.m_conn.createStatement();
        statement.executeUpdate("CREATE OR REPLACE FUNCTION getstovename(character varying, character varying) RETURNS text AS $$java.lang.System.getProperty$$ LANGUAGE java");
    }

    public void doSelects() throws Exception {
        Statement statement = this.m_conn.createStatement();
        int n = 0;
        ResultSet resultSet = statement.executeQuery("SELECT getstovename('my.non.property', xtable.tstove) FROM xtable");
        while (resultSet.next()) {
            String string = resultSet.getString(1);
            if (!string.startsWith("xyz_")) {
                throw new Exception("Tstove was " + string);
            }
            ++n;
        }
        resultSet.close();
        System.out.println("Succesfully read " + n + " rows");
    }
}

