#!/usr/sbin/dtrace -s

/*
 * USAGE      : ./checkpoint_stats.d
 *
 * DESCRIPTION:
 *   This script reports checkpoint statistics. The default checkpoint_timeout
 *   is 5 minutes, so adjust it as needed. 
 *
 * AUTHOR     : Robert Lor <robert.lor@sun.com>
 *
 * $Header$
 */

#pragma D option quiet

/*
 * Flag bits for checkpoint. See src/include/access/xlog.h
 * #define CHECKPOINT_IS_SHUTDOWN	0x0001
 * #define CHECKPOINT_IMMEDIATE		0x0002
 * #define CHECKPOINT_FORCE		0x0004
 * #define CHECKPOINT_WAIT		0x0008
 * #define CHECKPOINT_CAUSE_XLOG	0x0010
 * #define CHECKPOINT_CAUSE_TIME	0x0020
 *
 */

dtrace:::BEGIN
{
	/*
	 * May need to include other OR-ed flag values. If no text is shown
	 * between the double quotes in the checkpoint-start output, it means
	 * the index is missing.  Print out arg0 in the checkpoint-start clause
	 * to determine new index to add.
	 */
	checkpointtype[1] = "Shutdown";
	checkpointtype[2] = "Immediate";
	checkpointtype[3] = "Immediate Shutdown";
	checkpointtype[4] = "Forced";
	checkpointtype[5] = "Forced Shutdown";
	checkpointtype[8] = "Wait";
	checkpointtype[16] = "XLog";
	checkpointtype[32] = "Time";
}

postgresql*:::checkpoint-start
{
	printf("%Y : [PID=%d] \"%s\" checkpoint request started\n", walltimestamp, pid, checkpointtype[arg0 & 0xffff]);
	self->ts = timestamp;
	self->pid = pid;
}

postgresql*:::checkpoint-done
/self->ts && self->pid/
{
	this->elapsed = timestamp - self->ts;

	printf ("%Y : Checkpoint complete \n", walltimestamp); 
	printf ("Wrote %d of %d buffers (%.1d%%) \n", arg0, arg1, arg0 * 100 / arg1);
	printf ("%d xlog file(s) added, %d removed, %d recycled \n", arg2, arg3, arg4);
	printf ("Checkpoint time =  %3d.%03d sec (%d ns) \n\n", this->elapsed / 1000000000, (this->elapsed / 1000000) % 1000, this->elapsed);

	self->ts = 0;
	self->pid = 0;
}
