#!/usr/sbin/dtrace -s

/*
 * USAGE      : ./smgr_io.d
 *
 * DESCRIPTION: This script reports the storage manager's read/write statistics.
 *
 * AUTHOR     : Robert Lor <robert.lor@sun.com>
 *
 * $Header$
 */

#pragma D option quiet

postgresql*:::smgr-md-read-start
{
	self->ts = timestamp;
}

postgresql*:::smgr-md-read-done
/self->ts/
{
	@readcount[arg2, arg3, arg4] = count();
        self->ts = 0;
}

postgresql*:::smgr-md-write-start
{
	self->ts = timestamp;
}

postgresql*:::smgr-md-write-done
/self->ts/
{
	@writecount[arg2, arg3, arg4] = count();
        self->ts = 0;
}

profile:::tick-1s
{
	trunc(@readcount, 5);
	printf("\n================ Read stats ================\n");
	printf("%10s %10s %10s %10s\n","Tablespace", "Database", "Table", "Count");
        printa("%10d %10d %10d %@10d\n",@readcount);

	trunc(@writecount, 5);
	printf("\n===============  Write stats ===============\n");
	printf("%10s %10s %10s %10s\n","Tablespace", "Database", "Table", "Count");
        printa("%10d %10d %10d %@10d\n",@writecount);
}
