.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "CREATE TEXT SEARCH PARSER" "" "2012-09-19" "SQL - Language Statements" "SQL Commands"
.SH NAME
CREATE TEXT SEARCH PARSER \- define a new text search parser

.SH SYNOPSIS
.sp
.nf
CREATE TEXT SEARCH PARSER \fIname\fR (
    START = \fIstart_function\fR ,
    GETTOKEN = \fIgettoken_function\fR ,
    END = \fIend_function\fR ,
    LEXTYPES = \fIlextypes_function\fR
    [, HEADLINE = \fIheadline_function\fR ]
)
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBCREATE TEXT SEARCH PARSER\fR creates a new text search
parser. A text search parser defines a method for splitting a text
string into tokens and assigning types (categories) to the tokens.
A parser is not particularly useful by itself, but must be bound into a
text search configuration along with some text search dictionaries
to be used for searching.
.PP
If a schema name is given then the text search parser is created in the
specified schema. Otherwise it is created in the current schema.
.PP
You must be a superuser to use \fBCREATE TEXT SEARCH PARSER\fR.
(This restriction is made because an erroneous text search parser
definition could confuse or even crash the server.)
.PP
Refer to in the documentation for further information.
.SH "PARAMETERS"
.TP
\fB\fIname\fB\fR
The name of the text search parser to be created. The name can be
schema-qualified.
.TP
\fB\fIstart_function\fB\fR
The name of the start function for the parser.
.TP
\fB\fIgettoken_function\fB\fR
The name of the get-next-token function for the parser.
.TP
\fB\fIend_function\fB\fR
The name of the end function for the parser.
.TP
\fB\fIlextypes_function\fB\fR
The name of the lextypes function for the parser (a function that
returns information about the set of token types it produces).
.TP
\fB\fIheadline_function\fB\fR
The name of the headline function for the parser (a function that
summarizes a set of tokens).
.PP
The function names can be schema-qualified if necessary. Argument types
are not given, since the argument list for each type of function is
predetermined. All except the headline function are required.
.PP
.PP
The arguments can appear in any order, not only the one shown above.
.PP
.SH "COMPATIBILITY"
.PP
There is no
\fBCREATE TEXT SEARCH PARSER\fR statement in the SQL
standard.
.SH "SEE ALSO"
ALTER TEXT SEARCH PARSER [\fBalter_text_search_parser\fR(l)], DROP TEXT SEARCH PARSER [\fBdrop_text_search_parser\fR(l)]
