---
myst:
  html_meta:
    keywords: LaTeX, composition, flottants, légendes, numérotation
---

# Comment numéroter les figures en fonction des sections ?

Par défaut, les numéros des figures (et des tableaux) sont remis à zéro
aux changements de chapitre dans la classe <ctanpkg:book>.


## Numérotation changeant à chaque section

Afin d'étendre ce comportement aux sections, par exemple dans la classe 
<ctanpkg:article>, il faut insérer quelques lignes dans le préambule 
du document :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \usepackage{mwe}            % Pour inclure des images factices
  \pagestyle{empty}           % N'affiche pas de numéro de page

  % Code modifiant le comportement par défaut de LaTeX
  \makeatletter
    \@addtoreset{figure}{section}
  \makeatother
  \renewcommand{\thefigure}{\ifnum\value{section}>0
    \thesection.\fi\arabic{figure}}
  % Fin du code

\begin{document}
\section{La notion de glyphe}
En typographie, le terme glyphe désigne la représentation graphique 
d'un caractère typographique, aussi nommé caractère d'imprimerie.
Il peut s’agir d’un caractère alphabétique ou numérique, d’un signe 
de ponctuation, d'un accent ou d'une ligature.
\begin{figure}[ht]
  \centering
  \includegraphics[width=.3\linewidth]{example-image-a}
  \caption{Un glyphe de la lettre A}
\end{figure}
\section{La notion d'homoglyphe}
Un homoglyphe est un glyphe identique ou similaire à d'autres glyphes. 
\begin{figure}[ht]
  \centering
  \framebox{\Huge 1, l, I}
  \caption{Un exemple d'homoglyphes}
\end{figure}
\end{document}
```


## Numérotation continue entre les chapitres

Inversement, pour que les figures soient numérotées continûment et non remises
à zéro à chaque chapitre, il faut placer un correctif dans le préambule
du document :

```
\documentclass[french,oneside]{book}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \usepackage{mwe}            % Pour inclure des images factices
  \pagestyle{empty}           % N'affiche pas de numéro de page

  % Code modifiant le comportement par défaut de LaTeX
  \makeatletter 
  \@removefromreset{figure}{chapter}
  \makeatother
  \renewcommand{\thefigure}{\arabic{figure}}
  % Fin du code

\begin{document}
\chapter{La notion de glyphe}
En typographie, le terme glyphe désigne la représentation graphique 
d'un caractère typographique, aussi nommé caractère d'imprimerie.
Il peut s’agir d’un caractère alphabétique ou numérique, d’un signe 
de ponctuation, d'un accent ou d'une ligature.
\begin{figure}[ht]
  \centering
  \includegraphics[width=.3\linewidth]{example-image-a}
  \caption{Un glyphe de la lettre A}
\end{figure}

\chapter{La notion d'homoglyphe}
Un homoglyphe est un glyphe identique ou similaire à d'autres glyphes. 
\begin{figure}[ht]
  \centering
  \framebox{\Huge 1, l, I}
  \caption{Un exemple d'homoglyphes}
\end{figure}
\end{document}
```

Historiquement, ce fonctionnement s'obtenait en chargeant l'extension
<ctanpkg:remreset> (qui mettait à disposition la commande `\@removefromreset`)
et en appliquant ensuite le même code correctif. Le chargment de 
l'extension <ctanpkg:remreset> est désormais inutile car ses fonctionnalités
sont intégrées directement dans LaTeX. 