---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, mots, barrer un mot, rayer du texte, 
              supprimer du texte, overstrike, rature
---

# Comment barrer ou biffer du texte ?

Barrer du texte (*to overstrike*, en anglais) peut servir, par exemple, 
à indiquer du texte supprimé au cours de la révision d'un document.

Cette question traite uniquement du texte classique. Pour les mathématiques,
vous pouvez vous tourner vers la question 
"[](/4_domaines_specialises/mathematiques/barrer_des_termes)".


## Avec l'extension <ctanpkg:ulem>

L'extension <ctanpkg:ulem> permet de barrer du texte avec la commande
`\sout`. Plus largement, elle fournit des commandes permettant d'obtenir
différents types de soulignement, comme le montre la question
"[](/3_composition/texte/lignes/texte_souligne_qui_depasse_dans_la_marge)".

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{ulem}

\begin{document}
Votre comportement \sout{parfaitement inconvenant} a surpris !
\end{document}
```


## Avec l'extension <ctanpkg:soul>

L'extension <ctanpkg:soul> permet de barrer du texte avec la commande `\st`. 
Comme l'extension <ctanpkg:ulem>, elle propose des commandes de soulignement 
mais elle s'en distingue en proposant aussi des commandes pour gérer 
l'espacement entre les lettres (sur ce dernier point, voir la question 
"[](/3_composition/texte/mots/modifier_l_espacement_entre_les_caracteres)").

Si l'extension <ctanpkg:xcolor> est chargée, la commande `\setstcolor` permet 
de changer la couleur du trait. 
La [documentation](texdoc:soul) de l'extension fournit de nombreux exemples 
très clairs sur ce point.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{soul}
  \usepackage{xcolor}  

\begin{document}
Votre comportement \st{parfaitement inconvenant} a surpris !

\setstcolor{red}
Votre comportement \st{parfaitement inconvenant} a surpris !
\end{document}
```


## Avec l'extension <ctanpkg:Lua-UL>

L'extension <ctanpkg:Lua-UL>, de Marcel Krüger, met à profit 
les nouvelles possibilités du moteur [LuaTeX](/1_generalites/glossaire/luatex)
pour souligner, biffer, mettre en évidence, etc. Sa commande de biffage 
est `\strikeThrough`.

La [documentation](texdoc:Lua-UL) de l'extension montre que les commandes 
qu'elle met à disposition peuvent servir à construire d'autres commandes.
L'exemple ci-dessous illustre la commande classique et une commande adaptée 
(issue de la documentation).

```
%!TEX engine=lualatex
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{lua-ul}

  % Définition d'une nouvelle commande
  \newunderlinetype\beginBarrer{\leaders\hbox{%
    \normalfont\bfseries/%
    }}
  \NewDocumentCommand\Barrer{+m}{{\beginBarrer#1}}

\begin{document}
Votre comportement \strikeThrough{parfaitement} \Barrer{inconvenant} 
a surpris !
\end{document}
```


## Avec l'extension <ctanpkg:cancel>

L'extension <ctanpkg:cancel> permet de biffer des mots en oblique 
(avec `\cancel`), en sens inverse (avec `\bcancel` comme **b***ack*) 
ou en croix (avec `\xcancel`) :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{cancel}

\begin{document}
Votre comportement  \cancel{parfaitement inconvenant} a surpris !

Votre comportement \bcancel{parfaitement inconvenant} a surpris !

Votre comportement \xcancel{parfaitement inconvenant} a surpris !
\end{document}
```


## Avec l'extension <ctanpkg:pdfcomment>

L'extension <ctanpkg:pdfcomment> permet de barrer un texte et d'associer 
un commentaire avec la commande 

```{noedit}
\pdfmarkupcomment[⟨options⟩]{⟨texte⟩}{⟨commentaire⟩}
``` 

Comme cette commande permet de gérer aussi le soulignement et le surlignage, 
elle doit être paramétrée pour le biffage :
- avec l'option `markup=StrikeOut` ;
- et avec l'option `color=⟨couleur⟩` pour définir la `⟨couleur⟩` 
  de biffage souhaitée (non affiché sinon). Cette option demande le chargement
  de l'extension <ctanpkg:xcolor>. 

Le `⟨commentaire⟩` est incorporé à l'aide d'une "annotation" Adobe. 
Dès lors, ces annotations sont susceptibles de ne pas être prises en charge 
par certaines visionneuses PDF. Dans le cas où vos lecteurs utilisent 
Acrobat Reader, vous devriez être tranquille. 

Voici un exemple d'utilisation. Dans celui-ci, le commentaire "notez bien" 
apparaît si vous passez votre curseur de souris sur le terme barré 
"parfaitement inconvenant".

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{amssymb}
  \usepackage{pdfcomment}
  \usepackage{xcolor}

\begin{document}
Votre comportement \pdfmarkupcomment[markup=StrikeOut, color=red]{%
  parfaitement inconvenant}{Notez bien} 
a surpris !
\end{document}
```


:::{sources}
- [Overstriking characters](faquk:FAQ-overstrike)
:::