if not modules then modules = { } end modules ['lang-txt'] = {
    version   = 1.001,
    comment   = "companion to lang-lab.mkiv",
    author    = "Hans Hagen, PRAGMA-ADE, Hasselt NL",
    copyright = "PRAGMA ADE / ConTeXt Development Team",
    license   = "see context related readme files",
    dataonly  = true,
}

-- The content of this file is derived from the mkii lang-* files and
-- early 2011 the mkii labels are generated from this file. The
-- translations have been collected over years by users, using named
-- glyphs. This file uses utf exclusively.
--
-- Many of the initial translations were done by Tobias Burnus but
-- completed by numerous users. The following list is incomplete so feel
-- free to send me corrections.
--
-- In 2020+ Tomas Hala and his students added some more languages and did 
-- some extensive checking of the entries in this file. 
--
-- af    Afrikaans      ...
-- ar    Arabic         Idris Samawi Hamid, Khaled Hosny
-- be    Belarussian    Darya Hryshkavets (2019)
-- bg    Bulgarian      Vladislav Hinkin, Aleš Ďurčanský (2019)
-- ca    Catalan        ...
-- cn    Chinese        Wang Lei, ...
-- cs    Czech          Tom Hudec, Petr Sojka, Richard Gabriel
-- da    Danish         Arne Jorgensen
-- de    German         Tobias Burnus, ...
-- en    English        Hans Hagen, ...
-- eo    Esperanto      Alain Delmotte (2021)
-- es    Spanish        Andrés Montoya, ...
-- et    Estonian       Clyde Johnston (2018)
-- fi    Finish         ...
-- fr    French         Daniel Flipo, Arthur Reutenauer
-- gr    Greek          Apostolos Syropoulos, Thomas Schmitz
-- hr    Croatian       Željko Vrba, Richard Gabriel, Vedran Miletić
-- hu    Hungarian      Adam Reviczky
-- it    Italian        Giuseppe Bilotta, Luigi Scarso
-- ja    Japanese       Richard Gabriel
-- kr    Korean         Jeong Dalyoung
-- la    Latin          ...
-- lt    Lithuanian     Marius Aleknevičius
-- mk    Macedonian     Jakub Loula, Tomáš Hála (2019), Stojan Trajanovski (2019)
-- nb    Norwegian      Hans Fredrik Nordhaug, ...
-- nn    Norwegian      Hans Fredrik Nordhaug, ...
-- nl    Dutch          Hans Hagen
-- pe    Persian        Mohammad Hossein Bateni (2016)
-- pl    Polish         Grzegorz Sapijaszko (2011)
-- pt    Portuguese     Pedro F. M. Mendonça
-- ro    Romanian       Dan Seracu, ...
-- ru    Russian        Olga Briginets, Alexander Bokovoy, Victor Figurnov, ...
-- sk    Slovak         Tomáš Hála (2012)
-- sl    Slovenian      Mojca Miklavec
-- sr    Serbian        Ivan Pešić (2020)
-- sr-latn Serbian      Ivan Pešić (2020)
-- sv    Swedish        ...
-- tk    Turkish        Tobias Burnus
-- tr    Turkmen        Nazar Annagurban
-- ua    Ukrainian      Olga Briginets, Alexander Bokovoy, Victor Figurnov, ...
-- vi    Vietnamese     Han The Thanh


-- For the moment we keep this table in memory. In the future we can then
-- enable labels.

-- thinspace == sixperemspace = 0x2006
-- print("!"..utf.char(0x2006).."!")

languages       = languages or { }
local languages = languages

languages.data  = languages.data or utilities.storage.allocate { }
local data      = languages.data

local hairspace = utf.char(0x200A)

data.labels={
 ["btx"]={
  ["In"]={
   ["labels"]={
    ["be"]="У",
    ["bg"]="в",
    ["en"]="In",
    ["eo"]="En",
    ["es"]="En",
    ["fa"]="در",
    ["fr"]="Dans",
    ["mk"]="во",
    ["sr"]="У",
    ["sr-latn"]="U",
   },
  },
  ["Number"]={
   ["labels"]={
    ["be"]="Нумар",
    ["bg"]="номер",
    ["de"]="Numer",
    ["en"]="Number",
    ["eo"]="Nombro",
    ["fa"]="شماره",
    ["fr"]="Numéro",
    ["mk"]="Број",
    ["nl"]="Nummer",
    ["sr"]="Број",
    ["sr-latn"]="Broj",
   },
  },
  ["Volume"]={
   ["labels"]={
    ["be"]="Гук",
    ["bg"]="обем",
    ["de"]="Band",
    ["en"]="Volume",
    ["eo"]="Volumo",
    ["et"]="Köide",
    ["fa"]="جلد",
    ["mk"]="Том",
    ["nl"]="Deel",
    ["sr"]="Том",
    ["sr-latn"]="Tom",
   },
  },
  ["and"]={
   ["labels"]={
    ["be"]="i",
    ["bg"]="a",
    ["de"]="und",
    ["en"]="and",
    ["eo"]="kaj",
    ["es"]="y",
    ["et"]="ja",
    ["fa"]="و",
    ["fr"]="et",
    ["it"]="e",
    ["mk"]="и",
    ["nl"]="en",
    ["sr"]="и",
    ["sr-latn"]="i",
   },
  },
  ["edition"]={
   ["labels"]={
    ["be"]="Выданне",
    ["bg"]="издание",
    ["de"]="Auflage",
    ["en"]="edition",
    ["eo"]="eldono",
    ["es"]="edición",
    ["et"]="väljaanne",
    ["fa"]="ویرایش",
    ["fr"]="édition",
    ["it"]="edizione",
    ["mk"]="издание",
    ["nl"]="editie",
    ["sr"]="издање",
    ["sr-latn"]="izdanje",
   },
  },
  ["editor"]={
   ["labels"]={
    ["be"]="Рэдактар",
    ["bg"]="редактор",
    ["de"]="Herausgeber",
    ["en"]="editor",
    ["eo"]="eldonisto",
    ["et"]="toimetaja",
    ["fa"]="ویراستار",
    ["fr"]="éditeur",
    ["it"]="a cura di",
    ["mk"]="уредник",
    ["sr"]="уредник",
    ["sr-latn"]="urednik",
   },
  },
  ["editors"]={
   ["labels"]={
    ["be"]="Рэдактары",
    ["bg"]="редактори",
    ["de"]="Herausgeber",
    ["en"]="editors",
    ["eo"]="eldonistoj",
    ["es"]="editores",
    ["et"]="toimetajad",
    ["fr"]="éditeurs",
    ["it"]="a cura di",
    ["mk"]="уредници",
    ["sr"]="уредници",
    ["sr-latn"]="urednici",
   },
  },
  ["in"]={
   ["labels"]={
    ["be"]="у",
    ["bg"]="в",
    ["en"]="in",
    ["eo"]="en",
    ["es"]="en",
    ["fa"]="در",
    ["fr"]="dans",
    ["mk"]="во",
    ["sr"]="у",
    ["sr-latn"]="u",
   },
  },
  ["mastersthesis"]={
   ["labels"]={
    ["be"]="Дыпломная работа",
    ["bg"]="дипломна работа",
    ["de"]="Masterarbeit",
    ["en"]="Master's thesis",
    ["eo"]="Magistreca disertaĵo",
    ["es"]="Tesis de maestría",
    ["et"]="magistritöö",
    ["fa"]="پایان‌نامه کارشناسی ارشد",
    ["fr"]="Thèse de master (DEA, DESS, master)",
    ["it"]="Tesi di laurea",
    ["mk"]="Магистерска дисертација",
    ["nl"]="Masterproef",
    ["sr"]="Мастер дисертација",
    ["sr-latn"]="Master disertacija",
   },
  },
  ["number"]={
   ["labels"]={
    ["be"]="нумар",
    ["bg"]="номер",
    ["de"]="Numer",
    ["en"]="number",
    ["eo"]="numero",
    ["fa"]="شماره",
    ["fr"]="numéro",
    ["mk"]="број",
    ["nl"]="nummer",
    ["sr"]="број",
    ["sr-latn"]="broj",
   },
  },
  ["of"]={
   ["labels"]={
    ["be"]="з",
    ["bg"]="на",
    ["de"]="von",
    ["en"]="of",
    ["eo"]="de",
    ["fr"]="de",
    ["mk"]="од",
    ["nl"]="van",
    ["sr"]="од",
    ["sr-latn"]="od",
   },
  },
  ["others"]={
   ["labels"]={
    ["en"]="et al.",
    ["eo"]="aliaj",
    ["et"]="jt",
    ["mk"]="и др.",
    ["sr"]="и др.",
    ["sr-latn"]="i dr.",
   },
  },
  ["p"]={
   ["labels"]={
    ["be"]="стар.",
    ["de"]="S.",
    ["en"]="p.",
    ["eo"]="p.",
    ["et"]="lk",
    ["fa"]="ص",
    ["mk"]="стр.",
    ["sr"]="стр.",
    ["sr-latn"]="str.",
   },
  },
  ["pages"]={
   ["labels"]={
    ["be"]="старонка",
    ["bg"]="страни",
    ["de"]="Seiten",
    ["en"]="pages",
    ["eo"]="paĝoj",
    ["et"]="leheküljed",
    ["fa"]="صفحات",
    ["mk"]="страници",
    ["nl"]="paginas",
    ["sr"]="страницa",
    ["sr-latn"]="stranica",
   },
  },
  ["patent"]={
   ["labels"]={
    ["be"]="патэнт",
    ["bg"]="патент",
    ["de"]="Patent",
    ["en"]="Patent",
    ["eo"]="Patento",
    ["es"]="Patente",
    ["et"]="Patent",
    ["fr"]="Brevet",
    ["it"]="Brevetto",
    ["mk"]="Патент",
    ["nl"]="Octrooi",
    ["sr"]="Патент",
    ["sr-latn"]="Patent",
   },
  },
  ["phdthesis"]={
   ["labels"]={
    ["be"]="Доктарская дысертацыя",
    ["bg"]="дисертачна работа",
    ["de"]="Dissertation",
    ["en"]="PhD thesis",
    ["eo"]="Doktoriĝa disertaĵo",
    ["es"]="Tesis doctoral",
    ["et"]="doktoritöö",
    ["fa"]="رساله دکتری",
    ["fr"]="Thèse de doctorat",
    ["it"]="Tesi di dottorato",
    ["mk"]="Докторска дисертација",
    ["nl"]="Proefschrift",
    ["sr"]="Докторска дисертација",
    ["sr-latn"]="Doktorska disertacija",
   },
  },
  ["pp"]={
   ["labels"]={
    ["de"]="S.",
    ["en"]="pp.",
    ["eo"]="pp.",
    ["et"]="lk-d",
    ["fa"]="صص",
    ["mk"]="стр.",
    ["sr"]="стр.",
    ["sr-latn"]="str.",
   },
  },
  ["technicalreport"]={
   ["labels"]={
    ["be"]="Тэхнічны даклад",
    ["bg"]="технически доклад",
    ["de"]="Technischer Bericht",
    ["en"]="Technical report",
    ["eo"]="Teknika raporto",
    ["es"]="Informe técnico",
    ["et"]="tehniline raport",
    ["fa"]="گزارش فنی",
    ["fr"]="Rapport technique",
    ["it"]="Relazione tecnica",
    ["mk"]="Технички извештај",
    ["nl"]="Technisch rapport",
    ["sr"]="Технички извештај",
    ["sr-latn"]="Tehnički izveštaj",
   },
  },
  ["volume"]={
   ["labels"]={
    ["be"]="гучнасць",
    ["bg"]="обем",
    ["de"]="Band",
    ["en"]="volume",
    ["eo"]="volumo",
    ["et"]="köide",
    ["fa"]="جلد",
    ["mk"]="том",
    ["nl"]="deel",
    ["sr"]="том",
    ["sr-latn"]="tom",
   },
  },
  ["with"]={
   ["labels"]={
    ["be"]="з",
    ["bg"]="със",
    ["de"]="mit",
    ["en"]="with",
    ["eo"]="kun",
    ["es"]="con",
    ["et"]="koos",
    ["fr"]="avec",
    ["it"]="con",
    ["mk"]="со",
    ["nl"]="met",
    ["sr"]="са",
    ["sr-latn"]="sa",
   },
  },
 },
 ["functions"]={
  ["Pr"]={
   ["labels"]={
    ["cs"]="P",
    ["en"]="Pr",
    ["eo"]="P",
    ["mk"]="P",
    ["sk"]="P",
    ["sr"]="P",
    ["sr-latn"]="P",
   },
  },
  ["arccos"]={
   ["labels"]={
    ["cs"]="arccos",
    ["en"]="arccos",
    ["eo"]="arccos",
    ["es"]="arc\\sixperemspace cos",
    ["hr"]="arc\\sixperemspace cos",
    ["mk"]="arccos",
    ["pl"]="arc\\sixperemspace cos",
    ["sk"]="arccos",
    ["sr"]="arccos",
    ["sr-latn"]="arccos",
   },
  },
  ["arccosh"]={
   ["labels"]={
    ["cs"]="arccosh",
    ["en"]="arccosh",
    ["eo"]="arccosh",
    ["es"]="arc\\sixperemspace cosh",
    ["hr"]="arc\\sixperemspace cosh",
    ["mk"]="arccosh",
    ["pl"]="arc\\sixperemspace cosh",
    ["sk"]="arccosh",
    ["sr"]="arccosh",
    ["sr-latn"]="arccosh",
   },
  },
  ["arcctg"]={
   ["labels"]={
    ["cs"]="arccotg",
    ["en"]="arccot",
    ["eo"]="arcctan",
    ["es"]="arc\\sixperemspace cot",
    ["hr"]="arc\\sixperemspace ctg",
    ["mk"]="arccotg",
    ["pl"]="arc\\sixperemspace ctg",
    ["sk"]="arccotg",
    ["sr"]="arcctg",
    ["sr-latn"]="arcctg",
   },
  },
  ["arcsin"]={
   ["labels"]={
    ["cs"]="arcsin",
    ["en"]="arcsin",
    ["eo"]="arcsin",
    ["es"]="arc\\sixperemspace sen",
    ["hr"]="arc\\sixperemspace sin",
    ["mk"]="arcsin",
    ["pl"]="arc\\sixperemspace sin",
    ["sk"]="arcsin",
    ["sr"]="arcsin",
    ["sr-latn"]="arcsin",
   },
  },
  ["arcsinh"]={
   ["labels"]={
    ["cs"]="arcsinh",
    ["en"]="arcsinh",
    ["eo"]="arcsinh",
    ["es"]="arc\\sixperemspace senh",
    ["hr"]="arc\\sixperemspace sinh",
    ["mk"]="arcsinh",
    ["pl"]="arc\\sixperemspace sinh",
    ["sk"]="arcsinh",
    ["sr"]="arcsinh",
    ["sr-latn"]="arcsinh",
   },
  },
  ["arctan"]={
   ["labels"]={
    ["cs"]="arctg",
    ["en"]="arctan",
    ["eo"]="arctang",
    ["es"]="arc\\sixperemspace tan",
    ["hr"]="arc\\sixperemspace tg",
    ["mk"]="arctg",
    ["pl"]="arc\\sixperemspace tg",
    ["sk"]="arctg",
    ["sr"]="arctg",
    ["sr-latn"]="arctg",
   },
  },
  ["arctanh"]={
   ["labels"]={
    ["cs"]="arctgh",
    ["en"]="arctanh",
    ["eo"]="arctanh",
    ["es"]="arc\\sixperemspace tanh",
    ["hr"]="arc\\sixperemspace tgh",
    ["mk"]="arctgh",
    ["pl"]="arc\\sixperemspace tgh",
    ["sk"]="arctgh",
    ["sr"]="arctgh",
    ["sr-latn"]="arctgh",
   },
  },
  ["arg"]={
   ["labels"]={
    ["cs"]="arg",
    ["en"]="arg",
    ["eo"]="arg",
    ["es"]="arg",
    ["mk"]="arg",
    ["sk"]="arg",
    ["sr"]="arg",
    ["sr-latn"]="arg",
   },
  },
  ["cos"]={
   ["labels"]={
    ["cs"]="cos",
    ["en"]="cos",
    ["eo"]="cos",
    ["es"]="cos",
    ["mk"]="cos",
    ["sk"]="cos",
    ["sr"]="cos",
    ["sr-latn"]="cos",
   },
  },
  ["cosh"]={
   ["labels"]={
    ["cs"]="cosh",
    ["en"]="cosh",
    ["eo"]="cosh",
    ["es"]="cosh",
    ["mk"]="cosh",
    ["sk"]="cosh",
    ["sr"]="cosh",
    ["sr-latn"]="cosh",
   },
  },
  ["cot"]={
   ["labels"]={
    ["cs"]="cotg",
    ["en"]="cot",
    ["eo"]="cotan",
    ["es"]="cot",
    ["hr"]="ctg",
    ["mk"]="ctg",
    ["pl"]="ctg",
    ["sk"]="cotg",
    ["sr"]="ctg",
    ["sr-latn"]="ctg",
   },
  },
  ["coth"]={
   ["labels"]={
    ["cs"]="cotgh",
    ["en"]="coth",
    ["eo"]="cotanh",
    ["es"]="coth",
    ["mk"]="ctgh",
    ["sk"]="cotgh",
    ["sr"]="ctgh",
    ["sr-latn"]="ctgh",
   },
  },
  ["csc"]={
   ["labels"]={
    ["cs"]="cosec",
    ["en"]="csc",
    ["eo"]="cosec",
    ["es"]="csc",
    ["mk"]="cosec",
    ["sk"]="cosec",
    ["sr"]="cosec",
    ["sr-latn"]="cosec",
   },
  },
  ["ctg"]={
   ["labels"]={
    ["cs"]="cotg",
    ["en"]="cot",
    ["eo"]="cotan",
    ["es"]="cot",
    ["hr"]="ctg",
    ["mk"]="ctg",
    ["pl"]="ctg",
    ["sk"]="cotg",
    ["sr"]="ctg",
    ["sr-latn"]="ctg",
   },
  },
  ["deg"]={
   ["labels"]={
    ["cs"]="deg",
    ["en"]="deg",
    ["eo"]="gr",
    ["es"]="gr",
    ["mk"]="deg",
    ["sk"]="deg",
    ["sr"]="deg",
    ["sr-latn"]="deg",
   },
  },
  ["det"]={
   ["labels"]={
    ["cs"]="det",
    ["en"]="det",
    ["eo"]="det",
    ["es"]="det",
    ["sk"]="det",
    ["sr"]="det",
    ["sr-latn"]="det",
   },
  },
  ["diff"]={
   ["labels"]={
    ["en"]="d",
    ["eo"]="dif",
   },
  },
  ["dim"]={
   ["labels"]={
    ["cs"]="dim",
    ["en"]="dim",
    ["eo"]="dim",
    ["es"]="dim",
    ["mk"]="dim",
    ["sk"]="dim",
    ["sr"]="dim",
    ["sr-latn"]="dim",
   },
  },
  ["exp"]={
   ["labels"]={
    ["cs"]="exp",
    ["en"]="exp",
    ["eo"]="eksp",
    ["es"]="exp",
    ["sk"]="exp",
    ["sr"]="exp",
    ["sr-latn"]="exp",
   },
  },
  ["gcd"]={
   ["labels"]={
    ["cs"]="NSD",
    ["en"]="gcd",
    ["eo"]="",
    ["es"]="mcd",
    ["hr"]="nzd",
    ["mk"]="НЗД",
    ["nl"]="ggd",
    ["sk"]="NSD",
    ["sr"]="НЗД",
    ["sr-latn"]="NZD",
   },
  },
  ["hom"]={
   ["labels"]={
    ["cs"]="Hom",
    ["en"]="hom",
    ["eo"]="hom",
    ["es"]="hom",
    ["sk"]="Hom",
   },
  },
  ["inf"]={
   ["labels"]={
    ["cs"]="inf",
    ["en"]="inf",
    ["eo"]="inf",
    ["es"]="inf",
    ["mk"]="inf",
    ["sk"]="inf",
    ["sr"]="inf",
    ["sr-latn"]="inf",
   },
  },
  ["injlim"]={
   ["labels"]={
    ["cs"]="inj\\sixperemspace lim",
    ["en"]="inj\\sixperemspace lim",
    ["eo"]="",
    ["es"]="lím\\sixperemspace iny",
    ["sk"]="inj\\sixperemspace lim",
    ["sr"]="inj\\sixperemspace lim",
    ["sr-latn"]="inj\\sixperemspace lim",
   },
  },
  ["ker"]={
   ["labels"]={
    ["cs"]="ker",
    ["en"]="ker",
    ["eo"]="",
    ["es"]="Ker",
    ["sk"]="ker",
    ["sr"]="ker",
    ["sr-latn"]="ker",
   },
  },
  ["lcm"]={
   ["labels"]={
    ["cs"]="NSN",
    ["en"]="lcm",
    ["eo"]="",
    ["es"]="MCM",
    ["hr"]="nzv",
    ["mk"]="НЗС",
    ["nl"]="kgv",
    ["sk"]="NSN",
    ["sr"]="НЗС",
    ["sr-latn"]="NZS",
   },
  },
  ["lg"]={
   ["labels"]={
    ["cs"]="log",
    ["en"]="lg",
    ["eo"]="log",
    ["es"]="log",
    ["mk"]="lg",
    ["sk"]="log",
    ["sr"]="lg",
    ["sr-latn"]="lg",
   },
  },
  ["lim"]={
   ["labels"]={
    ["cs"]="lim",
    ["en"]="lim",
    ["eo"]="lim",
    ["es"]="lím",
    ["mk"]="lim",
    ["sk"]="lim",
    ["sr"]="lim",
    ["sr-latn"]="lim",
   },
  },
  ["liminf"]={
   ["labels"]={
    ["cs"]="lim\\sixperemspace inf",
    ["en"]="lim\\sixperemspace inf",
    ["eo"]="subinf",
    ["es"]="lím\\sixperemspace inf",
    ["mk"]="lim\\sixperemspace inf",
    ["sk"]="lim\\sixperemspace inf",
    ["sr"]="lim\\sixperemspace inf",
    ["sr-latn"]="lim\\sixperemspace inf",
   },
  },
  ["limsup"]={
   ["labels"]={
    ["cs"]="lim\\sixperemspace sup",
    ["en"]="lim\\sixperemspace sup",
    ["eo"]="suplim",
    ["es"]="lím\\sixperemspace sup",
    ["mk"]="lim\\sixperemspace sup",
    ["sk"]="lim\\sixperemspace sup",
    ["sr"]="lim\\sixperemspace sup",
    ["sr-latn"]="lim\\sixperemspace sup",
   },
  },
  ["ln"]={
   ["labels"]={
    ["cs"]="ln",
    ["en"]="ln",
    ["eo"]="ln",
    ["es"]="ln",
    ["mk"]="ln",
    ["sk"]="ln",
    ["sr"]="ln",
    ["sr-latn"]="ln",
   },
  },
  ["log"]={
   ["labels"]={
    ["cs"]="log",
    ["en"]="log",
    ["eo"]="log",
    ["es"]="log",
    ["mk"]="log",
    ["sk"]="log",
    ["sr"]="log",
    ["sr-latn"]="log",
   },
  },
  ["max"]={
   ["labels"]={
    ["cs"]="max",
    ["en"]="max",
    ["eo"]="maks",
    ["es"]="máx",
    ["mk"]="max",
    ["sk"]="max",
    ["sr"]="max",
    ["sr-latn"]="max",
   },
  },
  ["median"]={
   ["labels"]={
    ["cs"]="\\tilde",
    ["en"]="median",
    ["eo"]="mediano",
    ["es"]="Mediana",
    ["sk"]="\\tilde",
    ["sr"]="median",
    ["sr-latn"]="median",
   },
  },
  ["min"]={
   ["labels"]={
    ["cs"]="min",
    ["en"]="min",
    ["eo"]="min",
    ["es"]="mín",
    ["mk"]="min",
    ["sk"]="min",
    ["sr"]="min",
    ["sr-latn"]="min",
   },
  },
  ["mod"]={
   ["labels"]={
    ["cs"]="mod",
    ["en"]="mod",
    ["eo"]="mod",
    ["es"]="mod",
    ["mk"]="mod",
    ["sk"]="mod",
    ["sr"]="mod",
    ["sr-latn"]="mod",
   },
  },
  ["projlim"]={
   ["labels"]={
    ["cs"]="proj\\sixperemspace lim",
    ["en"]="proj\\sixperemspace lim",
    ["eo"]="",
    ["es"]="lím\\sixperemspace proy",
    ["sk"]="proj\\sixperemspace lim",
    ["sr"]="proj\\sixperemspace lim",
    ["sr-latn"]="proj\\sixperemspace lim",
   },
  },
  ["sec"]={
   ["labels"]={
    ["cs"]="sec",
    ["en"]="sec",
    ["eo"]="sek",
    ["es"]="sec",
    ["mk"]="sec",
    ["sk"]="sec",
    ["sr"]="sec",
    ["sr-latn"]="sec",
   },
  },
  ["sin"]={
   ["labels"]={
    ["cs"]="sin",
    ["en"]="sin",
    ["eo"]="sin",
    ["es"]="sen",
    ["mk"]="sin",
    ["sk"]="sin",
    ["sr"]="sin",
    ["sr-latn"]="sin",
   },
  },
  ["sinh"]={
   ["labels"]={
    ["cs"]="sinh",
    ["en"]="sinh",
    ["eo"]="sinh",
    ["es"]="senh",
    ["mk"]="sinh",
    ["sk"]="sinh",
    ["sr"]="sinh",
    ["sr-latn"]="sinh",
   },
  },
  ["sup"]={
   ["labels"]={
    ["cs"]="sup",
    ["en"]="sup",
    ["eo"]="sup",
    ["es"]="sup",
    ["mk"]="sup",
    ["sk"]="sup",
    ["sr"]="sup",
    ["sr-latn"]="sup",
   },
  },
  ["tan"]={
   ["labels"]={
    ["cs"]="tg",
    ["en"]="tan",
    ["eo"]="tan",
    ["es"]="tan",
    ["hr"]="tg",
    ["mk"]="tg",
    ["pl"]="tg",
    ["sk"]="tg",
    ["sr"]="tg",
    ["sr-latn"]="tg",
   },
  },
  ["tanh"]={
   ["labels"]={
    ["cs"]="tgh",
    ["en"]="tanh",
    ["eo"]="tanh",
    ["es"]="tanh",
    ["mk"]="tgh",
    ["sk"]="tgh",
    ["sr"]="tgh",
    ["sr-latn"]="tgh",
   },
  },
 },
 ["texts"]={
  ["and"]={
   ["labels"]={
    ["af"]="",
    ["ca"]="",
    ["cs"]=" a ",
    ["da"]="",
    ["de"]=" und ",
    ["en"]=" and ",
    ["eo"]=" kaj ",
    ["es"]=" y ",
    ["et"]=" ja ",
    ["fa"]=" و ",
    ["fi"]="",
    ["fr"]=" et ",
    ["gr"]="",
    ["hr"]=" i ",
    ["hu"]=" és ",
    ["it"]="",
    ["la"]="",
    ["lt"]="",
    ["mk"]=" и ",
    ["nb"]="",
    ["nl"]=" en ",
    ["nn"]="",
    ["pl"]=" i ",
    ["pt"]="",
    ["ro"]="",
    ["ru"]="",
    ["sk"]=" a ",
    ["sl"]="",
    ["sr"]=" и ",
    ["sv"]="",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="",
    ["vi"]="",
   },
  },
  ["appendix"]={
   ["hidden"]=true,
   ["labels"]={
    ["af"]="Bylae ",
    ["ar"]="ملحق ",
    ["be"]="Апендыцыт",
    ["ca"]="Apèndix ",
    ["cn"]="附录",
    ["cs"]="Příloha ",
    ["da"]="Bilag ",
    ["de"]="Anhang ",
    ["en"]="Appendix ",
    ["eo"]="Anekso",
    ["es"]="Apéndice ",
    ["et"]="Lisa ",
    ["fa"]="پیوست ",
    ["fi"]="",
    ["fr"]="Annexe ",
    ["gr"]="Παράρτημα",
    ["hr"]="Dodatak ",
    ["hu"]="Melléklet ",
    ["it"]="",
    ["ja"]="付録",
    ["kr"]="부록",
    ["la"]="",
    ["lt"]="",
    ["mk"]="Додаток ",
    ["nb"]="Tillegg ",
    ["nl"]="",
    ["nn"]="Tillegg ",
    ["pl"]="Dodatek ",
    ["pt"]="",
    ["ro"]="",
    ["ru"]="",
    ["sk"]="Príloha ",
    ["sl"]="Dodatek ",
    ["sr"]="Додатак ",
    ["sr-latn"]="Dodatak ",
    ["sv"]="",
    ["tk"]="Goşmaça",
    ["tr"]="",
    ["ua"]="",
    ["vi"]="",
   },
  },
  ["april"]={
   ["labels"]={
    ["af"]="april",
    ["ar"]="أبريل",
    ["ar-dz"]="أفريل",
    ["ar-sy"]="نيسان",
    ["be"]="красавіка",
    ["bg"]="април",
    ["ca"]="abril",
    ["cn"]="四月",
    ["cs"]="dubna",
    ["da"]="april",
    ["de"]="April",
    ["en"]="April",
    ["eo"]="Aprilo",
    ["es"]="abril",
    ["et"]="aprill",
    ["fa"]="آوریل",
    ["fi"]="huhtikuu",
    ["fr"]="avril",
    ["gr"]="Απρίλιος",
    ["hr"]="travnja",
    ["hu"]="április",
    ["it"]="aprile",
    ["ja"]="4",
    ["kr"]="4",
    ["la"]="Aprilis",
    ["lt"]="balandžio",
    ["mk"]="април",
    ["nb"]="april",
    ["nl"]="april",
    ["nn"]="april",
    ["pl"]="kwietnia",
    ["pt"]="abril",
    ["ro"]="aprilie",
    ["ru"]="апреля",
    ["sk"]="apríla",
    ["sl"]="april",
    ["sr"]="aприл",
    ["sr-latn"]="april",
    ["sv"]="april",
    ["tk"]="aprel",
    ["tr"]="nisan",
    ["ua"]="квітня",
    ["vi"]="tháng tư",
   },
  },
  ["april:jalali"]={
   ["labels"]={
    ["en"]="Tir",
    ["fa"]="تیر",
   },
  },
  ["april:mnem"]={
   ["labels"]={
    ["af"]="",
    ["bg"]="апр.",
    ["ca"]="",
    ["cs"]="dub.",
    ["da"]="",
    ["de"]="Apr.",
    ["en"]="apr",
    ["eo"]="Apr.",
    ["es"]="abr.",
    ["et"]="apr",
    ["fi"]="",
    ["fr"]="",
    ["gr"]="",
    ["hr"]="tra",
    ["hu"]="ápr.",
    ["it"]="",
    ["la"]="",
    ["lt"]="apr",
    ["mk"]="апр.",
    ["nb"]="april",
    ["nl"]="",
    ["nn"]="april",
    ["pl"]="kwi.",
    ["pt"]="",
    ["ro"]="",
    ["ru"]="",
    ["sk"]="apr.",
    ["sl"]="",
    ["sr"]="апр",
    ["sr-latn"]="apr",
    ["sv"]="",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="",
    ["vi"]="",
   },
  },
  ["atpage"]={
   ["labels"]={
    ["af"]="",
    ["ar"]="في صفحة ",
    ["ca"]="",
    ["cs"]="na straně ",
    ["da"]="på side ",
    ["de"]="auf Seite ",
    ["en"]="at page ",
    ["eo"]="je paĝo",
    ["es"]="en la página ",
    ["et"]="leheküljel ",
    ["fa"]="در صفحه ",
    ["fi"]="",
    ["fr"]="à la page ",
    ["gr"]="",
    ["hr"]="na stranici ",
    ["hu"]="oldal ",
    ["it"]="a pagina ",
    ["la"]="",
    ["lt"]="puslapyje ",
    ["mk"]="на страница ",
    ["nb"]="på side ",
    ["nl"]="op pagina ",
    ["nn"]="på side ",
    ["pl"]="na stronie ",
    ["pt"]="",
    ["ro"]="",
    ["ru"]="на странице ",
    ["sk"]="na strane ",
    ["sl"]="na strani ",
    ["sr"]="на страници ",
    ["sr-latn"]="na stranici ",
    ["sv"]="på sida ",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="на сторінці ",
    ["vi"]="",
   },
  },
  ["august"]={
   ["labels"]={
    ["af"]="augustus",
    ["ar"]="أغسطس",
    ["ar-dz"]="أوت",
    ["ar-ma"]="غشت",
    ["ar-sy"]="آب",
    ["be"]="жнівня",
    ["bg"]="август",
    ["ca"]="agost",
    ["cn"]="八月",
    ["cs"]="srpna",
    ["da"]="august",
    ["de"]="August",
    ["en"]="August",
    ["eo"]="Aŭgusto",
    ["es"]="agosto",
    ["et"]="august",
    ["fa"]="اوت",
    ["fi"]="elokuu",
    ["fr"]="août",
    ["gr"]="Αύγουστος",
    ["hr"]="kolovoza",
    ["hu"]="augusztus",
    ["it"]="agosto",
    ["ja"]="8",
    ["kr"]="8",
    ["la"]="Augustus",
    ["lt"]="rugpjūčio",
    ["mk"]="август",
    ["nb"]="august",
    ["nl"]="augustus",
    ["nn"]="august",
    ["pl"]="sierpnia",
    ["pt"]="agosto",
    ["ro"]="august",
    ["ru"]="августа",
    ["sk"]="augusta",
    ["sl"]="avgust",
    ["sr"]="август",
    ["sr-latn"]="avgust",
    ["sv"]="augusti",
    ["tk"]="awgust",
    ["tr"]="ağustos",
    ["ua"]="серпня",
    ["vi"]="tháng tám",
   },
  },
  ["august:jalali"]={
   ["labels"]={
    ["en"]="Aban",
    ["fa"]="آبان",
   },
  },
  ["august:mnem"]={
   ["labels"]={
    ["af"]="",
    ["bg"]="авг.",
    ["ca"]="",
    ["cs"]="srp.",
    ["da"]="",
    ["de"]="Aug.",
    ["en"]="aug",
    ["eo"]="Aŭg.",
    ["es"]="ago.",
    ["et"]="aug",
    ["fi"]="",
    ["fr"]="",
    ["gr"]="",
    ["hr"]="kol",
    ["hu"]="aug.",
    ["it"]="",
    ["la"]="",
    ["lt"]="aug",
    ["mk"]="авг.",
    ["nb"]="aug.",
    ["nl"]="",
    ["nn"]="aug.",
    ["pl"]="sier.",
    ["pt"]="",
    ["ro"]="",
    ["ru"]="",
    ["sk"]="aug.",
    ["sl"]="",
    ["sr"]="авг",
    ["sr-latn"]="avg",
    ["sv"]="",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="",
    ["vi"]="",
   },
  },
  ["chapter"]={
   ["hidden"]=true,
   ["labels"]={
    ["af"]="Hoofstuk ",
    ["ar"]="باب ",
    ["be"]="Глава ",
    ["bg"]="Eпизод ",
    ["ca"]="Capítol ",
    ["cn"]={ "第", "章" },
    ["cs"]="Kapitola ",
    ["da"]="",
    ["de"]="Kapitel ",
    ["en"]="Chapter ",
    ["eo"]="Ĉapitro",
    ["es"]="Capítulo ",
    ["et"]="Peatükk ",
    ["fa"]="فصل ",
    ["fi"]="",
    ["fr"]="Chapitre ",
    ["gr"]="Κεφάλαιο",
    ["hr"]="Poglavlje ",
    ["hu"]={ "", " fejezet" },
    ["it"]="",
    ["ja"]={ "第", "章" },
    ["kr"]={ "제", "장" },
    ["la"]="",
    ["lt"]="",
    ["mk"]="Глава ",
    ["nb"]="",
    ["nl"]="",
    ["nn"]="",
    ["pl"]="Rozdział ",
    ["pt"]="",
    ["ro"]="",
    ["ru"]="",
    ["sk"]="Kapitola ",
    ["sl"]="Poglavje ",
    ["sr"]="Глава ",
    ["sr-latn"]="Glava ",
    ["sv"]="",
    ["tk"]="Bap",
    ["tr"]="",
    ["ua"]="",
    ["vi"]="Chương ",
   },
  },
  ["continued"]={
   ["labels"]={
    ["af"]="",
    ["be"]=" (працяг)",
    ["bg"]=" (продължение)",
    ["ca"]="",
    ["cs"]=" (pokračování)",
    ["da"]="",
    ["de"]="",
    ["en"]=" (continued)",
    ["eo"]=" (daŭrigota)",
    ["es"]=" (continúa)",
    ["et"]=" (jätkub)",
    ["fa"]="(ادامه دارد)",
    ["fi"]="",
    ["fr"]="",
    ["gr"]="",
    ["hr"]=" (nastavak)",
    ["hu"]=" (folytatás)",
    ["it"]="",
    ["la"]="",
    ["lt"]="",
    ["mk"]=" (продолжение)",
    ["nb"]="",
    ["nl"]=" (vervolgd)",
    ["nn"]="",
    ["pl"]="",
    ["pt"]="",
    ["ro"]="",
    ["ru"]="",
    ["sk"]=" (pokračovanie)",
    ["sl"]="",
    ["sr"]=" (наставак)",
    ["sr-latn"]=" (nastavak)",
    ["sv"]="",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="",
    ["vi"]="",
   },
  },
  ["day"]={
   ["labels"]={
    ["bg"]="ден",
    ["en"]="day",
    ["eo"]="tago",
    ["et"]="päev",
    ["fa"]="روز",
    ["kr"]="일",
    ["mk"]="ден",
    ["nl"]="dag",
    ["sr"]="дан",
    ["sr-latn"]="dan",
   },
  },
  ["december"]={
   ["labels"]={
    ["af"]="desember",
    ["ar"]="ديسمبر",
    ["ar-ma"]="دجنبر",
    ["ar-sy"]="كانون الأول",
    ["be"]="снежня",
    ["bg"]="декември",
    ["ca"]="desembre",
    ["cn"]="十二月",
    ["cs"]="prosince",
    ["da"]="december",
    ["de"]="Dezember",
    ["en"]="December",
    ["eo"]="Decembro",
    ["es"]="diciembre",
    ["et"]="detsember",
    ["fa"]="دسامبر",
    ["fi"]="joulukuu",
    ["fr"]="décembre",
    ["gr"]="Δεκέμβριος",
    ["hr"]="prosinca",
    ["hu"]="december",
    ["it"]="dicembre",
    ["ja"]="12",
    ["kr"]="12",
    ["la"]="December",
    ["lt"]="gruodžio",
    ["mk"]="декември",
    ["nb"]="desember",
    ["nl"]="december",
    ["nn"]="desember",
    ["pl"]="grudnia",
    ["pt"]="dezembro",
    ["ro"]="decembrie",
    ["ru"]="декабря",
    ["sk"]="decembra",
    ["sl"]="december",
    ["sr"]="децембар",
    ["sr-latn"]="decembar",
    ["sv"]="december",
    ["tk"]="dekabr",
    ["tr"]="aralık",
    ["ua"]="грудня",
    ["vi"]="tháng mười hai",
   },
  },
  ["december:jalali"]={
   ["labels"]={
    ["en"]="Esfand",
    ["fa"]="اسفند",
   },
  },
  ["december:mnem"]={
   ["labels"]={
    ["af"]="",
    ["bg"]="дек.",
    ["ca"]="",
    ["cs"]="pros.",
    ["da"]="",
    ["de"]="Dez.",
    ["en"]="dec",
    ["eo"]="Dec.",
    ["es"]="dic.",
    ["et"]="dets",
    ["fi"]="",
    ["fr"]="",
    ["gr"]="",
    ["hr"]="pro",
    ["hu"]="dec.",
    ["it"]="",
    ["la"]="",
    ["lt"]="dec",
    ["mk"]="дек.",
    ["nb"]="des.",
    ["nl"]="",
    ["nn"]="des.",
    ["pl"]="gru.",
    ["pt"]="",
    ["ro"]="",
    ["ru"]="",
    ["sk"]="dec.",
    ["sl"]="",
    ["sr"]="дец",
    ["sr-latn"]="dec",
    ["sv"]="",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="",
    ["vi"]="",
   },
  },
  ["february"]={
   ["labels"]={
    ["af"]="februarie",
    ["ar"]="فبراير",
    ["ar-dz"]="فيفري",
    ["ar-sy"]="شباط",
    ["be"]="лютага",
    ["bg"]="февруари",
    ["ca"]="febrer",
    ["cn"]="二月",
    ["cs"]="února",
    ["da"]="februar",
    ["de"]="Februar",
    ["en"]="February",
    ["eo"]="Februaro",
    ["es"]="febrero",
    ["et"]="veebruar",
    ["fa"]="فوریه",
    ["fi"]="helmikuu",
    ["fr"]="février",
    ["gr"]="Φεβρουάριος",
    ["hr"]="veljače",
    ["hu"]="február",
    ["it"]="febbraio",
    ["ja"]="2",
    ["kr"]="2",
    ["la"]="Februarius",
    ["lt"]="vasario",
    ["mk"]="февруари",
    ["nb"]="februar",
    ["nl"]="februari",
    ["nn"]="februar",
    ["pl"]="lutego",
    ["pt"]="fevereiro",
    ["ro"]="februarie",
    ["ru"]="февраля",
    ["sk"]="februára",
    ["sl"]="februar",
    ["sr"]="фебруар",
    ["sr-latn"]="februar",
    ["sv"]="februari",
    ["tk"]="fewral",
    ["tr"]="Şubat",
    ["ua"]="лютого",
    ["vi"]="tháng hai",
   },
  },
  ["february:jalali"]={
   ["labels"]={
    ["en"]="Ordibehesht",
    ["fa"]="اردیبهشت",
   },
  },
  ["february:mnem"]={
   ["labels"]={
    ["af"]="",
    ["bg"]="февр.",
    ["ca"]="",
    ["cs"]="ún.",
    ["da"]="",
    ["de"]="Feb.",
    ["en"]="feb",
    ["eo"]="Feb.",
    ["es"]="feb.",
    ["et"]="veebr",
    ["fi"]="",
    ["fr"]="",
    ["gr"]="",
    ["hr"]="velj",
    ["hu"]="feb.",
    ["it"]="",
    ["la"]="",
    ["lt"]="feb",
    ["mk"]="фев.",
    ["nb"]="feb.",
    ["nl"]="",
    ["nn"]="feb.",
    ["pl"]="lut.",
    ["pt"]="",
    ["ro"]="",
    ["ru"]="",
    ["sk"]="feb.",
    ["sl"]="",
    ["sr"]="феб",
    ["sr-latn"]="feb",
    ["sv"]="",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="",
    ["vi"]="",
   },
  },
  ["figure"]={
   ["labels"]={
    ["af"]="Figuur ",
    ["ar"]="شكل ",
    ["be"]="Малюнак",
    ["bg"]="Фигура",
    ["ca"]="Figura ",
    ["cn"]="图",
    ["cs"]="Obrázek ",
    ["da"]="Figur ",
    ["de"]="Abbildung ",
    ["en"]="Figure ",
    ["eo"]="Figuro ",
    ["es"]="Figura ",
    ["et"]="Joonis ",
    ["fa"]="شکل ",
    ["fi"]="Kuva ",
    ["fr"]="Figure ",
    ["gr"]="Σχήμα",
    ["hr"]="Slika ",
    ["hu"]={ "", " ábra" },
    ["it"]="Fig. ",
    ["ja"]="図",
    ["kr"]="그림 ",
    ["la"]="Imago ",
    ["lt"]={ "", " pav." },
    ["mk"]="Слика ",
    ["nb"]="Figur ",
    ["nl"]="Figuur ",
    ["nn"]="Figur ",
    ["pl"]="Ilustracja ",
    ["pt"]="Figura ",
    ["ro"]="Figura ",
    ["ru"]="Рисунок ",
    ["sk"]="Obrázok ",
    ["sl"]="Slika ",
    ["sr"]="Слика ",
    ["sr-latn"]="Slika ",
    ["sv"]="Figur ",
    ["tk"]="Surat",
    ["tr"]="Şekil ",
    ["ua"]="Малюнок ",
    ["vi"]="Hình ",
   },
  },
  ["following:plural"]={
   ["labels"]={
    ["en"]="ff.",
    ["eo"]="sekvv",
    ["fr"]=hairspace .. "sqq",
   },
  },
  ["following:singular"]={
   ["labels"]={
    ["en"]="f.",
    ["eo"]="sekv",
    ["fr"]=hairspace .. "sq",
   },
  },
  ["followingpage"]={
   ["labels"]={
    ["en"]="on a following page",
    ["eo"]="je sekvanta paĝo",
    ["et"]="järgmisel leheküljel",
    ["fa"]="در صفحات آینده",
    ["mk"]="на следната страница",
    ["nl"]="op een volgende bladzijde",
    ["sr"]="на следећој страници",
    ["sr-latn"]="na sledećoj stranici",
   },
  },
  ["friday"]={
   ["labels"]={
    ["af"]="vrydag",
    ["ar"]="الجمعة",
    ["be"]="пятніца",
    ["bg"]="петък",
    ["ca"]="divendres",
    ["cn"]="星期五",
    ["cs"]="pátek",
    ["da"]="fredag",
    ["de"]="Freitag",
    ["en"]="Friday",
    ["eo"]="vendredo",
    ["es"]="viernes",
    ["et"]="reede",
    ["fa"]="جمعه",
    ["fi"]="perjantai",
    ["fr"]="vendredi",
    ["gr"]="Παρασκευή",
    ["hr"]="petak",
    ["hu"]="péntek",
    ["it"]="venerdì",
    ["ja"]="金曜日",
    ["kr"]="금요일",
    ["la"]="Dies Veneris",
    ["lt"]="penktadienis",
    ["mk"]="петок",
    ["nb"]="fredag",
    ["nl"]="vrijdag",
    ["nn"]="fredag",
    ["pl"]="piątek",
    ["pt"]="sexta-feira",
    ["ro"]="vineri",
    ["ru"]="пятница",
    ["sk"]="piatok",
    ["sl"]="petek",
    ["sr"]="петак",
    ["sr-latn"]="petak",
    ["sv"]="fredag",
    ["tk"]="bäşinji gün",
    ["tr"]="cuma",
    ["ua"]="п'ятниця",
    ["vi"]="thứ sáu",
   },
  },
  ["friday:mnem"]={
   ["labels"]={
    ["bg"]="пт",
    ["cs"]="pá",
    ["de"]="Fr.",
    ["en"]="fri",
    ["eo"]="ven.",
    ["sk"]="pi",
    ["sr"]="пет",
    ["sr-latn"]="pet",
   },
  },
  ["graphic"]={
   ["labels"]={
    ["af"]="Grafiek ",
    ["ar"]="رسم ",
    ["be"]="Графіка ",
    ["bg"]="Графичен ",
    ["ca"]="Gràfica ",
    ["cn"]="插图",
    ["cs"]="Graf ",
    ["da"]="Grafik ",
    ["de"]="Graphik ",
    ["en"]="Graphic ",
    ["eo"]="Grafiko",
    ["es"]="Gráfico ",
    ["et"]="Pilt ",
    ["fa"]="طرح ",
    ["fi"]="Grafiikka ",
    ["fr"]="Illustration ",
    ["gr"]="Γραφικό",
    ["hr"]="Slika ",
    ["hu"]={ "", " kép" },
    ["it"]="Grafico ",
    ["ja"]="イラスト",
    ["la"]="Typus ",
    ["lt"]="Graphic ",
    ["mk"]="График ",
    ["nb"]="Bilde ",
    ["nl"]="Grafiek ",
    ["nn"]="Bilete ",
    ["pl"]="Grafika ",
    ["pt"]="Gráfico ",
    ["ro"]="Graficul ",
    ["ru"]="График ",
    ["sk"]="Graf ",
    ["sl"]="Slika ",
    ["sr"]="График ",
    ["sr-latn"]="Grafik ",
    ["sv"]="Grafik ",
    ["tk"]="Grafik",
    ["tr"]="Grafik",
    ["ua"]="График ",
    ["vi"]="Đồ thị",
   },
  },
  ["hencefore"]={
   ["labels"]={
    ["af"]="",
    ["ar"]="كما وضحنا سابقا",
    ["be"]="гл. вышэй",
    ["bg"]="виж по-горе",
    ["ca"]="",
    ["cs"]="viz výše",
    ["da"]="se foroven",
    ["de"]="siehe oben",
    ["en"]="as we show above",
    ["eo"]="laŭsupre",
    ["es"]="como se muestra arriba",
    ["et"]="nii nagu üleval näidatud",
    ["fa"]="چنان‌که شرح دادیم",
    ["fi"]="",
    ["fr"]="ci-dessus",
    ["gr"]="",
    ["hr"]="vidi gore",
    ["hu"]="lásd feljebb",
    ["it"]="come mostrato sopra",
    ["kr"]="그러므로",
    ["la"]="",
    ["lt"]="kaip parodyta aukščiau",
    ["mk"]="како што е прикажано погоре",
    ["nb"]="som vist over",
    ["nl"]="hierboven",
    ["nn"]="som vist over",
    ["pl"]="jak pokazano wyżej",
    ["pt"]="",
    ["ro"]="",
    ["ru"]="см. выше",
    ["sk"]="pozri hore",
    ["sl"]="glej zgoraj",
    ["sr"]="као што је показано изнад",
    ["sr-latn"]="kao što je pokazano iznad",
    ["sv"]="se ovan",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="як показано вище",
    ["vi"]="",
   },
  },
  ["hereafter"]={
   ["labels"]={
    ["af"]="",
    ["ar"]="كما نوضح لاحقا",
    ["be"]="гл. ніжэй",
    ["bg"]="ў далейшым",
    ["ca"]="",
    ["cs"]="viz níže",
    ["da"]="se forneden",
    ["de"]="siehe unten",
    ["en"]="as we show below",
    ["eo"]="laŭsube",
    ["es"]="como se muestra abajo",
    ["et"]="nii nagu all näidatud",
    ["fa"]="چنان‌که شرح خواهیم داد",
    ["fi"]="",
    ["fr"]="ci-dessous",
    ["gr"]="",
    ["hr"]="vidi ispod",
    ["hu"]="lásd lejjebb",
    ["it"]="come mostrato sotto",
    ["kr"]="이후로",
    ["la"]="",
    ["lt"]="kaip parodyta žemiau",
    ["mk"]="како што е прикажано подолу",
    ["nb"]="som vist under",
    ["nl"]="hieronder",
    ["nn"]="som vist under",
    ["pl"]="jak pokazano niżej",
    ["pt"]="",
    ["ro"]="",
    ["ru"]="см. ниже",
    ["sk"]="pozri ďalej",
    ["sl"]="glej spodaj",
    ["sr"]="као што је показано ниже",
    ["sr-latn"]="kao što je pokazano niže",
    ["sv"]="se nedan",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="як показано нижче",
    ["vi"]="",
   },
  },
  ["intermezzo"]={
   ["labels"]={
    ["af"]="Intermezzo ",
    ["ar"]="فسحة ",
    ["be"]="Інтэрмецца ",
    ["bg"]="Интермецо ",
    ["ca"]="Intermedi ",
    ["cn"]="퉣",
    ["cs"]="Intermezzo ",
    ["da"]="Intermezzo ",
    ["de"]="Intermezzo ",
    ["en"]="Intermezzo ",
    ["eo"]="Intermezo",
    ["es"]="Intermedio ",
    ["et"]="Vahemäng ",
    ["fi"]="Intermezzo ",
    ["fr"]="Intermède ",
    ["gr"]="Παύση",
    ["hr"]="Intermeco ",
    ["hu"]={ "", " intermezzo" },
    ["it"]="Intermezzo ",
    ["ja"]="間奏曲",
    ["kr"]="간주곡",
    ["la"]="Intermissum ",
    ["lt"]="Intermezzo ",
    ["mk"]="Дигресија ",
    ["nb"]="Intermesso ",
    ["nl"]="Intermezzo ",
    ["nn"]="Intermesso ",
    ["pl"]="Intermezzo ",
    ["pt"]="Intermédio ",
    ["ro"]="Intermezzo ",
    ["ru"]="Вставка ",
    ["sk"]="Intermezzo ",
    ["sl"]="Intermezzo ",
    ["sr"]="Дигресија ",
    ["sr-latn"]="Digresija ",
    ["sv"]="Intermezzo ",
    ["tk"]="Arakesme",
    ["tr"]="",
    ["ua"]="Вставка ",
    ["vi"]="intermezzo",
   },
  },
  ["january"]={
   ["labels"]={
    ["af"]="januarie",
    ["ar"]="يناير",
    ["ar-dz"]="جانفي",
    ["ar-sy"]="كانون الثاني",
    ["be"]="студзеня",
    ["bg"]="януари",
    ["ca"]="gener",
    ["cn"]="一月",
    ["cs"]="ledna",
    ["da"]="januar",
    ["de"]="Januar",
    ["en"]="January",
    ["eo"]="Januaro",
    ["es"]="enero",
    ["et"]="jaanuar",
    ["fa"]="ژانویه",
    ["fi"]="tammikuu",
    ["fr"]="janvier",
    ["gr"]="Ιανουάριος",
    ["hr"]="siječnja",
    ["hu"]="január",
    ["it"]="gennaio",
    ["ja"]="1",
    ["kr"]="1",
    ["la"]="Ianuarius",
    ["lt"]="sausio",
    ["mk"]="јануари",
    ["nb"]="januar",
    ["nl"]="januari",
    ["nn"]="januar",
    ["pl"]="stycznia",
    ["pt"]="janeiro",
    ["ro"]="ianuarie",
    ["ru"]="января",
    ["sk"]="januára",
    ["sl"]="januar",
    ["sr"]="јануар",
    ["sr-latn"]="januar",
    ["sv"]="januari",
    ["tk"]="ýanwar",
    ["tr"]="ocak",
    ["ua"]="січня",
    ["vi"]="tháng giêng",
   },
  },
  ["january:jalali"]={
   ["labels"]={
    ["en"]="Farvardin",
    ["fa"]="فروردین",
   },
  },
  ["january:mnem"]={
   ["labels"]={
    ["af"]="",
    ["bg"]="ян.",
    ["ca"]="",
    ["cs"]="led.",
    ["da"]="",
    ["de"]="Jan.",
    ["en"]="jan",
    ["eo"]="Jan.",
    ["es"]="ene.",
    ["et"]="jaan",
    ["fi"]="",
    ["fr"]="",
    ["gr"]="",
    ["hr"]="sij",
    ["hu"]="jan.",
    ["it"]="",
    ["la"]="",
    ["lt"]="jan",
    ["mk"]="jан.",
    ["nb"]="jan.",
    ["nl"]="",
    ["nn"]="jan.",
    ["pl"]="sty.",
    ["pt"]="",
    ["ro"]="",
    ["ru"]="",
    ["sk"]="jan.",
    ["sl"]="",
    ["sr"]="јан",
    ["sr-latn"]="jan",
    ["sv"]="",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="",
    ["vi"]="",
   },
  },
  ["july"]={
   ["labels"]={
    ["af"]="julie",
    ["ar"]="يوليو",
    ["ar-dz"]="جويلة",
    ["ar-ma"]="يوليوز",
    ["ar-sy"]="تموز",
    ["be"]="ліпня",
    ["bg"]="юли",
    ["ca"]="juliol",
    ["cn"]="七月",
    ["cs"]="července",
    ["da"]="juli",
    ["de"]="Juli",
    ["en"]="July",
    ["eo"]="Julio",
    ["es"]="julio",
    ["et"]="juuli",
    ["fa"]="ژوئیه",
    ["fi"]="heinäkuu",
    ["fr"]="juillet",
    ["gr"]="Ιούλιος",
    ["hr"]="srpnja",
    ["hu"]="július",
    ["it"]="luglio",
    ["ja"]="7",
    ["kr"]="7",
    ["la"]="Iulius",
    ["lt"]="liepos",
    ["mk"]="јули",
    ["nb"]="juli",
    ["nl"]="juli",
    ["nn"]="juli",
    ["pl"]="lipca",
    ["pt"]="julho",
    ["ro"]="iulie",
    ["ru"]="июля",
    ["sk"]="júla",
    ["sl"]="julij",
    ["sr"]="jул",
    ["sr-latn"]="jul",
    ["sv"]="juli",
    ["tk"]="iýul",
    ["tr"]="temmuz",
    ["ua"]="липня",
    ["vi"]="tháng bảy",
   },
  },
  ["july:jalali"]={
   ["labels"]={
    ["en"]="Mehr",
    ["fa"]="مهر",
   },
  },
  ["july:mnem"]={
   ["labels"]={
    ["af"]="",
    ["bg"]="юли",
    ["ca"]="",
    ["cs"]="čce",
    ["da"]="",
    ["de"]="Jul.",
    ["en"]="jul",
    ["eo"]="Jul.",
    ["es"]="jul.",
    ["et"]="juuli",
    ["fi"]="",
    ["fr"]="",
    ["gr"]="",
    ["hr"]="srp",
    ["hu"]="júl.",
    ["it"]="",
    ["la"]="",
    ["lt"]="jul",
    ["mk"]="јул.",
    ["nb"]="juli",
    ["nl"]="",
    ["nn"]="juli",
    ["pl"]="lip.",
    ["pt"]="",
    ["ro"]="",
    ["ru"]="",
    ["sk"]="júla",
    ["sl"]="",
    ["sr"]="јул",
    ["sr-latn"]="jul",
    ["sv"]="",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="",
    ["vi"]="",
   },
  },
  ["june"]={
   ["labels"]={
    ["af"]="junie",
    ["ar"]="يونيو",
    ["ar-dz"]="جوان",
    ["ar-sy"]="حزيران",
    ["be"]="чэрвня",
    ["bg"]="юни",
    ["ca"]="juny",
    ["cn"]="六月",
    ["cs"]="června",
    ["da"]="juni",
    ["de"]="Juni",
    ["en"]="June",
    ["eo"]="Junio",
    ["es"]="junio",
    ["et"]="juuni",
    ["fa"]="ژوئن",
    ["fi"]="kesäkuu",
    ["fr"]="juin",
    ["gr"]="Ιούνιος",
    ["hr"]="lipnja",
    ["hu"]="június",
    ["it"]="giugno",
    ["ja"]="6",
    ["kr"]="6",
    ["la"]="Iunius",
    ["lt"]="birželio",
    ["mk"]="јуни",
    ["nb"]="juni",
    ["nl"]="juni",
    ["nn"]="juni",
    ["pl"]="czerwca",
    ["pt"]="junho",
    ["ro"]="iunie",
    ["ru"]="июня",
    ["sk"]="júna",
    ["sl"]="junij",
    ["sr"]="јун",
    ["sr-latn"]="jun",
    ["sv"]="juni",
    ["tk"]="iýun",
    ["tr"]="haziran",
    ["ua"]="червня",
    ["vi"]="tháng sáu",
   },
  },
  ["june:jalali"]={
   ["labels"]={
    ["en"]="Shahrivar",
    ["fa"]="شهریور",
   },
  },
  ["june:mnem"]={
   ["labels"]={
    ["af"]="",
    ["bg"]="юни",
    ["ca"]="",
    ["cs"]="čer.",
    ["da"]="",
    ["de"]="Jun.",
    ["en"]="jun",
    ["eo"]="Jun.",
    ["es"]="jun.",
    ["et"]="juuni",
    ["fi"]="",
    ["fr"]="",
    ["gr"]="",
    ["hr"]="lip",
    ["hu"]="jún.",
    ["it"]="",
    ["la"]="",
    ["lt"]="jun",
    ["mk"]="јун.",
    ["nb"]="juni",
    ["nl"]="",
    ["nn"]="juni",
    ["pl"]="czerw.",
    ["pt"]="",
    ["ro"]="",
    ["ru"]="",
    ["sk"]="júna",
    ["sl"]="",
    ["sr"]="јун",
    ["sr-latn"]="jun",
    ["sv"]="",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="",
    ["vi"]="",
   },
  },
  ["line"]={
   ["labels"]={
    ["af"]="reël ",
    ["ar"]="سطر ",
    ["be"]="радок ",
    ["bg"]="ред ",
    ["ca"]="línia ",
    ["cn"]="行",
    ["cs"]="řádek ",
    ["da"]="linie ",
    ["de"]="Zeile ",
    ["en"]="line ",
    ["eo"]="linio ",
    ["es"]="línea ",
    ["et"]="joon ",
    ["fa"]="سطر ",
    ["fi"]="rivi ",
    ["fr"]="ligne ",
    ["gr"]="Γραμμή",
    ["hr"]="redak ",
    ["hu"]={ "", " sor" },
    ["it"]="riga ",
    ["ja"]="線",
    ["kr"]="행",
    ["la"]="versus ",
    ["lt"]="line ",
    ["mk"]="линија ",
    ["nb"]="linje ",
    ["nl"]="regel ",
    ["nn"]="linje ",
    ["pl"]="wiersz ",
    ["pt"]="linha ",
    ["ro"]="linia ",
    ["ru"]="строка ",
    ["sk"]="riadok ",
    ["sl"]="vrstica ",
    ["sr"]="линија ",
    ["sr-latn"]="linija ",
    ["sv"]="rad ",
    ["tk"]="setir",
    ["tr"]="satır ",
    ["ua"]="рядок ",
    ["vi"]="dòng ",
   },
  },
  ["lines"]={
   ["labels"]={
    ["af"]="reëls ",
    ["ar"]="السطور ",
    ["be"]="радкi ",
    ["bg"]="редове ",
    ["ca"]="línies ",
    ["cn"]="行",
    ["cs"]="řádky ",
    ["da"]="linier ",
    ["de"]="Zeilen ",
    ["en"]="lines ",
    ["eo"]="linioj ",
    ["es"]="líneas ",
    ["et"]="jooned ",
    ["fa"]="سطرهای ",
    ["fi"]="rivie ",
    ["fr"]="lignes ",
    ["gr"]="Γραμμές",
    ["hr"]="retci ",
    ["hu"]="sorok ",
    ["it"]="righe ",
    ["ja"]="線",
    ["kr"]="행",
    ["la"]="versus ",
    ["lt"]="lines ",
    ["mk"]="линии ",
    ["nb"]="linjer ",
    ["nl"]="regels ",
    ["nn"]="linjer ",
    ["pl"]="wiersze ",
    ["pt"]="linhas ",
    ["ro"]="liniile ",
    ["ru"]="строки ",
    ["sk"]="riadky ",
    ["sl"]="vrstice ",
    ["sr"]="линије ",
    ["sr-latn"]="linije ",
    ["sv"]="rader ",
    ["tk"]="setirler",
    ["tr"]="satırlar ",
    ["ua"]="рядки ",
    ["vi"]="dòng ",
   },
  },
  ["march"]={
   ["labels"]={
    ["af"]="maart",
    ["ar"]="مارس",
    ["ar-sy"]="آذار",
    ["be"]="сакавіка",
    ["bg"]="март",
    ["ca"]="març",
    ["cn"]="三月",
    ["cs"]="března",
    ["da"]="marts",
    ["de"]="März",
    ["en"]="March",
    ["eo"]="Marto",
    ["es"]="marzo",
    ["et"]="märts",
    ["fa"]="مارس",
    ["fi"]="maaliskuu",
    ["fr"]="mars",
    ["gr"]="Μάρτιος",
    ["hr"]="ožujka",
    ["hu"]="március",
    ["it"]="marzo",
    ["ja"]="3",
    ["kr"]="3",
    ["la"]="Martius",
    ["lt"]="kovo",
    ["mk"]="март",
    ["nb"]="mars",
    ["nl"]="maart",
    ["nn"]="mars",
    ["pl"]="marca",
    ["pt"]="março",
    ["ro"]="martie",
    ["ru"]="марта",
    ["sk"]="marca",
    ["sl"]="marec",
    ["sr"]="март",
    ["sr-latn"]="mart",
    ["sv"]="mars",
    ["tk"]="mart",
    ["tr"]="mart",
    ["ua"]="березня",
    ["vi"]="tháng ba",
   },
  },
  ["march:jalali"]={
   ["labels"]={
    ["en"]="Khordad",
    ["fa"]="خرداد",
   },
  },
  ["march:mnem"]={
   ["labels"]={
    ["af"]="",
    ["bg"]="март",
    ["ca"]="",
    ["cs"]="břez.",
    ["da"]="",
    ["de"]="Mrz.",
    ["en"]="mar",
    ["eo"]="Mar.",
    ["es"]="mar.",
    ["et"]="märts",
    ["fi"]="",
    ["fr"]="",
    ["gr"]="",
    ["hr"]="ožu",
    ["hu"]="már.",
    ["it"]="",
    ["la"]="",
    ["lt"]="mar",
    ["mk"]="мар.",
    ["nb"]="mars",
    ["nl"]="",
    ["nn"]="mars",
    ["pl"]="mar.",
    ["pt"]="",
    ["ro"]="",
    ["ru"]="",
    ["sk"]="mar.",
    ["sl"]="",
    ["sr"]="мар",
    ["sr-latn"]="mar",
    ["sv"]="",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="",
    ["vi"]="",
   },
  },
  ["may"]={
   ["labels"]={
    ["af"]="mei",
    ["ar"]="مايو",
    ["ar-dz"]="ماي",
    ["ar-ma"]="ماي",
    ["ar-sy"]="أيار",
    ["be"]="мая",
    ["bg"]="маӣ",
    ["ca"]="maig",
    ["cn"]="五月",
    ["cs"]="května",
    ["da"]="maj",
    ["de"]="Mai",
    ["en"]="May",
    ["eo"]="Majo",
    ["es"]="mayo",
    ["et"]="mai",
    ["fa"]="مه",
    ["fi"]="toukokuu",
    ["fr"]="mai",
    ["gr"]="Μάιος",
    ["hr"]="svibnja",
    ["hu"]="május",
    ["it"]="maggio",
    ["ja"]="5",
    ["kr"]="5",
    ["la"]="Maius",
    ["lt"]="gegužės",
    ["mk"]="мај",
    ["nb"]="mai",
    ["nl"]="mei",
    ["nn"]="mai",
    ["pl"]="maja",
    ["pt"]="maio",
    ["ro"]="mai",
    ["ru"]="мая",
    ["sk"]="mája",
    ["sl"]="maj",
    ["sr"]="мај",
    ["sr-latn"]="maj",
    ["sv"]="maj",
    ["tk"]="maý",
    ["tr"]="mayıs",
    ["ua"]="травня",
    ["vi"]="tháng năm",
   },
  },
  ["may:jalali"]={
   ["labels"]={
    ["en"]="Mordad",
    ["fa"]="مرداد",
   },
  },
  ["may:mnem"]={
   ["labels"]={
    ["af"]="",
    ["bg"]="май",
    ["ca"]="",
    ["cs"]="květ.",
    ["da"]="",
    ["de"]="Mai",
    ["en"]="may",
    ["eo"]="Maj.",
    ["es"]="may.",
    ["et"]="mai",
    ["fi"]="",
    ["fr"]="",
    ["gr"]="",
    ["hr"]="svi",
    ["hu"]="máj.",
    ["it"]="",
    ["la"]="",
    ["lt"]="may",
    ["mk"]="мај",
    ["nb"]="mai",
    ["nl"]="",
    ["nn"]="mai",
    ["pl"]="maja",
    ["pt"]="",
    ["ro"]="",
    ["ru"]="",
    ["sk"]="mája",
    ["sl"]="",
    ["sr"]="мај",
    ["sr-latn"]="maj",
    ["sv"]="",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="",
    ["vi"]="",
   },
  },
  ["monday"]={
   ["labels"]={
    ["af"]="maandag",
    ["ar"]="الاثنين",
    ["be"]="панядзелак",
    ["bg"]="понеделник",
    ["ca"]="dilluns",
    ["cn"]="星期一",
    ["cs"]="pondělí",
    ["da"]="mandag",
    ["de"]="Montag",
    ["en"]="Monday",
    ["eo"]="lundo",
    ["es"]="lunes",
    ["et"]="esmaspäev",
    ["fa"]="دوشنبه",
    ["fi"]="maanantai",
    ["fr"]="lundi",
    ["gr"]="Δευτέρα",
    ["hr"]="ponedjeljak",
    ["hu"]="hétfő",
    ["it"]="lunedì",
    ["ja"]="月曜日",
    ["kr"]="월요일",
    ["la"]="Dies Lunae",
    ["lt"]="pirmadienis",
    ["mk"]="понеделник",
    ["nb"]="mandag",
    ["nl"]="maandag",
    ["nn"]="måndag",
    ["pl"]="poniedziałek",
    ["pt"]="segunda-feira",
    ["ro"]="luni",
    ["ru"]="понедельник",
    ["sk"]="pondelok",
    ["sl"]="ponedeljek",
    ["sr"]="понедељак",
    ["sr-latn"]="ponedeljak",
    ["sv"]="måndag",
    ["tk"]="birinji gün",
    ["tr"]="pazartesi",
    ["ua"]="понеділок",
    ["vi"]="thứ hai",
   },
  },
  ["monday:mnem"]={
   ["labels"]={
    ["bg"]="пн",
    ["cs"]="po",
    ["de"]="Mo.",
    ["en"]="mon",
    ["eo"]="lun.",
    ["sk"]="po",
    ["sr"]="пон",
    ["sr-latn"]="pon",
   },
  },
  ["month"]={
   ["labels"]={
    ["be"]="месяц",
    ["bg"]="месец",
    ["en"]="month",
    ["eo"]="monato",
    ["et"]="kuu",
    ["fa"]="ماه",
    ["kr"]="월",
    ["mk"]="месец",
    ["nl"]="maand",
    ["sr"]="месец",
    ["sr-latn"]="mesec",
   },
  },
  ["november"]={
   ["labels"]={
    ["af"]="november",
    ["ar"]="نوفمبر",
    ["ar-ma"]="نونبر",
    ["ar-sy"]="تشرين الثاني",
    ["be"]="лістапада",
    ["bg"]="ноември",
    ["ca"]="novembre",
    ["cn"]="十一月",
    ["cs"]="listopadu",
    ["da"]="november",
    ["de"]="November",
    ["en"]="November",
    ["eo"]="Novembro",
    ["es"]="noviembre",
    ["et"]="november",
    ["fa"]="نوامبر",
    ["fi"]="marraskuu",
    ["fr"]="novembre",
    ["gr"]="Νοέμβριος",
    ["hr"]="studenog",
    ["hu"]="november",
    ["it"]="novembre",
    ["ja"]="11",
    ["kr"]="11",
    ["la"]="November",
    ["lt"]="lapkričio",
    ["mk"]="ноември",
    ["nb"]="november",
    ["nl"]="november",
    ["nn"]="november",
    ["pl"]="listopada",
    ["pt"]="novembro",
    ["ro"]="noiembrie",
    ["ru"]="ноября",
    ["sk"]="novembra",
    ["sl"]="november",
    ["sr"]="новембар",
    ["sr-latn"]="novembar",
    ["sv"]="november",
    ["tk"]="noýabr",
    ["tr"]="kasım",
    ["ua"]="листопада",
    ["vi"]="tháng mười một",
   },
  },
  ["november:jalali"]={
   ["labels"]={
    ["en"]="Bahman",
    ["fa"]="بهمن",
   },
  },
  ["november:mnem"]={
   ["labels"]={
    ["af"]="",
    ["bg"]="ноем.",
    ["ca"]="",
    ["cs"]="list.",
    ["da"]="",
    ["de"]="Nov.",
    ["en"]="nov",
    ["eo"]="Nov.",
    ["es"]="nov.",
    ["et"]="nov",
    ["fi"]="",
    ["fr"]="",
    ["gr"]="",
    ["hr"]="stu",
    ["hu"]="nov.",
    ["it"]="",
    ["la"]="",
    ["lt"]="nov",
    ["mk"]="ноем.",
    ["nb"]="nov.",
    ["nl"]="",
    ["nn"]="nov.",
    ["pl"]="lis.",
    ["pt"]="",
    ["ro"]="",
    ["ru"]="",
    ["sk"]="nov.",
    ["sl"]="",
    ["sr"]="нов",
    ["sr-latn"]="nov",
    ["sv"]="",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="",
    ["vi"]="",
   },
  },
  ["october"]={
   ["labels"]={
    ["af"]="oktober",
    ["ar"]="أكتوبر",
    ["ar-sy"]="تشرين الأول",
    ["be"]="кастрычніка",
    ["bg"]="октомври",
    ["ca"]="octubre",
    ["cn"]="十月",
    ["cs"]="října",
    ["da"]="oktober",
    ["de"]="Oktober",
    ["en"]="October",
    ["eo"]="Oktobro",
    ["es"]="octubre",
    ["et"]="oktoober",
    ["fa"]="اکتبر",
    ["fi"]="lokakuu",
    ["fr"]="octobre",
    ["gr"]="Οκτώβριος",
    ["hr"]="listopada",
    ["hu"]="október",
    ["it"]="ottobre",
    ["ja"]="10",
    ["kr"]="10",
    ["la"]="October",
    ["lt"]="spalio",
    ["mk"]="октомври",
    ["nb"]="oktober",
    ["nl"]="oktober",
    ["nn"]="oktober",
    ["pl"]="października",
    ["pt"]="outubro",
    ["ro"]="octombrie",
    ["ru"]="октября",
    ["sk"]="októbra",
    ["sl"]="oktober",
    ["sr"]="октобар",
    ["sr-latn"]="oktobar",
    ["sv"]="oktober",
    ["tk"]="oktýabr",
    ["tr"]="ekim",
    ["ua"]="жовтня",
    ["vi"]="tháng mười",
   },
  },
  ["october:jalali"]={
   ["labels"]={
    ["en"]="Dey",
    ["fa"]="دی",
   },
  },
  ["october:mnem"]={
   ["labels"]={
    ["af"]="",
    ["bg"]="окт.",
    ["ca"]="",
    ["cs"]="říj.",
    ["da"]="",
    ["de"]="Okt.",
    ["en"]="oct",
    ["eo"]="Okt.",
    ["es"]="oct.",
    ["et"]="okt",
    ["fi"]="",
    ["fr"]="",
    ["gr"]="",
    ["hr"]="lis",
    ["hu"]="okt.",
    ["it"]="",
    ["la"]="",
    ["lt"]="oct",
    ["mk"]="окт.",
    ["nb"]="okt.",
    ["nl"]="",
    ["nn"]="okt.",
    ["pl"]="paź.",
    ["pt"]="",
    ["ro"]="",
    ["ru"]="",
    ["sk"]="okt.",
    ["sl"]="",
    ["sr"]="окт",
    ["sr-latn"]="okt",
    ["sv"]="",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="",
    ["vi"]="",
   },
  },
  ["page"]={
   ["labels"]={
    ["af"]="",
    ["ar"]="صفحة ",
    ["be"]="старонка ",
    ["bg"]="страна",
    ["ca"]="",
    ["cs"]="strana ",
    ["da"]="Side ",
    ["de"]="Seite ",
    ["en"]="page ",
    ["eo"]="paĝo ",
    ["es"]="página ",
    ["et"]="lehekülg ",
    ["fa"]="صفحه ",
    ["fi"]="",
    ["fr"]="page ",
    ["gr"]="",
    ["hr"]="stranica ",
    ["hu"]="oldal ",
    ["it"]="pagina ",
    ["kr"]="쪽",
    ["la"]="",
    ["lt"]="puslapis ",
    ["mk"]="страница ",
    ["nb"]="side ",
    ["nl"]="pagina ",
    ["nn"]="side ",
    ["pl"]="strona ",
    ["pt"]="",
    ["ro"]="",
    ["ru"]="страница ",
    ["sk"]="strana ",
    ["sl"]="stran ",
    ["sr"]="страница ",
    ["sr-latn"]="stranica ",
    ["sv"]="Sida ",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="сторінка ",
    ["vi"]="",
   },
  },
  ["part"]={
   ["labels"]={
    ["af"]="Deel ",
    ["ar"]="جزء ",
    ["be"]="Частка ",
    ["bg"]="Частка ",
    ["ca"]="Part ",
    ["cn"]={ "第", "部分" },
    ["cs"]="Část ",
    ["da"]="Del ",
    ["de"]="Teil ",
    ["en"]="Part ",
    ["eo"]="Parto ",
    ["es"]="Parte ",
    ["et"]="Osa ",
    ["fa"]="قسمت ",
    ["fi"]="Osa ",
    ["fr"]="Partie ",
    ["gr"]="Μέρος",
    ["hr"]="Dio ",
    ["hu"]={ "", " rész" },
    ["it"]="Parte ",
    ["ja"]={ "第", "パート" },
    ["kr"]={ "제", "부" },
    ["la"]="Pars ",
    ["lt"]={ "", " dalis" },
    ["mk"]="Дел ",
    ["nb"]="Del ",
    ["nl"]="Deel ",
    ["nn"]="Del",
    ["pl"]="Część ",
    ["pt"]="Parte ",
    ["ro"]="Partea ",
    ["ru"]="Часть ",
    ["sk"]="Časť ",
    ["sl"]="Del ",
    ["sr"]="Део ",
    ["sr-latn"]="Deo ",
    ["sv"]="Del ",
    ["tk"]="Bölüm",
    ["tr"]="Cilt ",
    ["ua"]="Частина ",
    ["vi"]="Phần ",
   },
  },
  ["precedingpage"]={
   ["labels"]={
    ["en"]="on a preceding page",
    ["eo"]="sur antaŭa paĝo",
    ["et"]="eelmisel lehel",
    ["fa"]="در صفحات گذشته",
    ["mk"]="на претходната страница",
    ["nl"]="op een voorgaande bladzijde",
    ["sr"]="на претходној страници",
    ["sr-latn"]="na prethodnoj stranici",
   },
  },
  ["saturday"]={
   ["labels"]={
    ["af"]="saterdag",
    ["ar"]="السبت",
    ["be"]="субота",
    ["bg"]="сряда",
    ["ca"]="dissabte",
    ["cn"]="星期六",
    ["cs"]="sobota",
    ["da"]="lørdag",
    ["de"]="Samstag",
    ["en"]="Saturday",
    ["eo"]="sabato",
    ["es"]="sábado",
    ["et"]="laupäev",
    ["fa"]="شنبه",
    ["fi"]="lauantai",
    ["fr"]="samedi",
    ["gr"]="Σάββατο",
    ["hr"]="subota",
    ["hu"]="szombat",
    ["it"]="sabato",
    ["ja"]="土曜日",
    ["kr"]="토요일",
    ["la"]="Dies Saturni",
    ["lt"]="šeštadienis",
    ["mk"]="сабота",
    ["nb"]="lørdag",
    ["nl"]="zaterdag",
    ["nn"]="laurdag",
    ["pl"]="sobota",
    ["pt"]="sábado",
    ["ro"]="sâmbătă",
    ["ru"]="суббота",
    ["sk"]="sobota",
    ["sl"]="sobota",
    ["sr"]="субота",
    ["sr-latn"]="subota",
    ["sv"]="lördag",
    ["tk"]="altynjy gün",
    ["tr"]="cumartesi",
    ["ua"]="субота",
    ["vi"]="thứ bảy",
   },
  },
  ["saturday:mnem"]={
   ["labels"]={
    ["bg"]="сб",
    ["cs"]="so",
    ["de"]="Sa.",
    ["en"]="sat",
    ["eo"]="sab.",
    ["sk"]="so",
    ["sr"]="суб",
    ["sr-latn"]="sub",
   },
  },
  ["section"]={
   ["hidden"]=true,
   ["labels"]={
    ["af"]="Paragraaf ",
    ["ar"]="فصل ",
    ["bg"]="Cекция ",
    ["ca"]="Secció ",
    ["cn"]={ "第", "节" },
    ["cs"]="Sekce ",
    ["da"]="",
    ["de"]="",
    ["en"]="Section",
    ["eo"]="Sekcio ",
    ["es"]="Sección ",
    ["et"]="jaos ",
    ["fa"]="بخش ",
    ["fi"]="",
    ["fr"]="Section ",
    ["gr"]="Ενότητα",
    ["hr"]="Odjeljak ",
    ["hu"]="Fejezet ",
    ["it"]="",
    ["ja"]={ "第", "項" },
    ["kr"]={ "제", "절" },
    ["la"]="",
    ["lt"]="",
    ["mk"]="Поглавје ",
    ["nb"]="",
    ["nl"]="",
    ["nn"]="",
    ["pl"]="Podrozdział ",
    ["pt"]="",
    ["ro"]="",
    ["ru"]="",
    ["sk"]="Sekcia ",
    ["sl"]="",
    ["sr"]="Одељак ",
    ["sr-latn"]="Odeljak ",
    ["sv"]="",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="",
    ["vi"]="",
   },
  },
  ["see"]={
   ["labels"]={
    ["af"]="",
    ["ar"]="انظر ",
    ["be"]="гл. ",
    ["bg"]="погледни",
    ["ca"]="",
    ["cs"]="viz ",
    ["da"]="se ",
    ["de"]="siehe ",
    ["en"]="see ",
    ["eo"]="vidu ",
    ["es"]="ver: ",
    ["et"]="vaadake ",
    ["fa"]="نگاه کنید به ",
    ["fi"]="",
    ["fr"]="cf. ",
    ["gr"]="",
    ["hr"]="vidi ",
    ["hu"]="lásd ",
    ["it"]="cf. ",
    ["kr"]="",
    ["la"]="",
    ["lt"]="žiūrėti ",
    ["mk"]="види ",
    ["nb"]="se ",
    ["nl"]="zie ",
    ["nn"]="sjå ",
    ["pl"]="patrz ",
    ["pt"]="",
    ["ro"]="",
    ["ru"]="см. ",
    ["sk"]="pozri ",
    ["sl"]="glej ",
    ["sr"]="види ",
    ["sr-latn"]="vidi ",
    ["sv"]="se ",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="див. ",
    ["vi"]="",
   },
  },
  ["september"]={
   ["labels"]={
    ["af"]="september",
    ["ar"]="سبتمبر",
    ["ar-ma"]="شتنبر",
    ["ar-sy"]="أيلول",
    ["be"]="верасня",
    ["bg"]="септември",
    ["ca"]="setembre",
    ["cn"]="九月",
    ["cs"]="září",
    ["da"]="september",
    ["de"]="September",
    ["en"]="September",
    ["eo"]="Septembro",
    ["es"]="septiembre",
    ["et"]="september",
    ["fa"]="سپتامبر",
    ["fi"]="syyskuu",
    ["fr"]="septembre",
    ["gr"]="Σεπτέμβριος",
    ["hr"]="rujna",
    ["hu"]="szeptember",
    ["it"]="settembre",
    ["ja"]="9",
    ["kr"]="9",
    ["la"]="September",
    ["lt"]="rugsėjo",
    ["mk"]="септември",
    ["nb"]="september",
    ["nl"]="september",
    ["nn"]="september",
    ["pl"]="września",
    ["pt"]="setembro",
    ["ro"]="septembrie",
    ["ru"]="сентября",
    ["sk"]="septembra",
    ["sl"]="september",
    ["sr"]="септембар",
    ["sr-latn"]="septembar",
    ["sv"]="september",
    ["tk"]="sentýabr",
    ["tr"]="eylül",
    ["ua"]="вересня",
    ["vi"]="tháng chín",
   },
  },
  ["september:jalali"]={
   ["labels"]={
    ["en"]="Azar",
    ["fa"]="آذر",
   },
  },
  ["september:mnem"]={
   ["labels"]={
    ["af"]="",
    ["bg"]="септ.",
    ["ca"]="",
    ["cs"]="září",
    ["da"]="",
    ["de"]="Sep.",
    ["en"]="sep",
    ["eo"]="Sep.",
    ["es"]="sep.",
    ["et"]="sept",
    ["fi"]="",
    ["fr"]="",
    ["gr"]="",
    ["hr"]="ruj",
    ["hu"]="szep.",
    ["it"]="",
    ["la"]="",
    ["lt"]="sep",
    ["mk"]="септ.",
    ["nb"]="sep.",
    ["nl"]="",
    ["nn"]="sep.",
    ["pl"]="wrz.",
    ["pt"]="",
    ["ro"]="",
    ["ru"]="",
    ["sk"]="sept.",
    ["sl"]="",
    ["sr"]="сеп.",
    ["sr-latn"]="sep.",
    ["sv"]="",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="",
    ["vi"]="",
   },
  },
  ["subsection"]={
   ["hidden"]=true,
   ["labels"]={
    ["af"]="",
    ["ar"]="فصل أدنى ",
    ["bg"]="Подсекция ",
    ["ca"]="Subsecció ",
    ["cn"]="",
    ["cs"]="Podsekce ",
    ["da"]="",
    ["de"]="",
    ["en"]="Subsection",
    ["eo"]="Subsekcio ",
    ["es"]="Subsección ",
    ["et"]="alajaotis ",
    ["fa"]="زیربخش ",
    ["fi"]="",
    ["fr"]="Soussection ",
    ["gr"]="Υπόενότητα",
    ["hr"]="Pododjeljak ",
    ["hu"]="Alfejezet ",
    ["it"]="",
    ["ja"]="",
    ["la"]="",
    ["lt"]="",
    ["mk"]="Подпоглавје ",
    ["nb"]="",
    ["nl"]="",
    ["nn"]="",
    ["pl"]="Podpodrozdział ",
    ["pt"]="",
    ["ro"]="",
    ["ru"]="",
    ["sk"]="Podsekcia ",
    ["sl"]="",
    ["sr"]="Пододељак ",
    ["sr-latn"]="Pododeljak ",
    ["sv"]="",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="",
    ["vi"]="",
   },
  },
  ["subsubsection"]={
   ["hidden"]=true,
   ["labels"]={
    ["af"]="",
    ["ar"]="فصل أدنى أدنى ",
    ["bg"]="Подподсекция ",
    ["ca"]="Subsubsecció ",
    ["cn"]="",
    ["cs"]="Podpodsekce ",
    ["da"]="",
    ["de"]="",
    ["en"]="Subsubsection",
    ["eo"]="Subsubsekcio ",
    ["es"]="Subsubsección ",
    ["et"]="alamjaotis ",
    ["fa"]="زیرزیربخش ",
    ["fi"]="",
    ["fr"]="Soussoussection ",
    ["gr"]="",
    ["hr"]="Podpododjeljak ",
    ["hu"]="Al-alfejezet ",
    ["it"]="",
    ["ja"]="",
    ["la"]="",
    ["lt"]="",
    ["mk"]="Подподпоглавје ",
    ["nb"]="",
    ["nl"]="",
    ["nn"]="",
    ["pl"]="",
    ["pt"]="",
    ["ro"]="",
    ["ru"]="",
    ["sk"]="Podpodsekcia ",
    ["sl"]="",
    ["sr"]="Подпододељак ",
    ["sr-latn"]="Podpododeljak ",
    ["sv"]="",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="",
    ["vi"]="",
   },
  },
  ["subsubsubsection"]={
   ["hidden"]=true,
   ["labels"]={
    ["af"]="",
    ["ar"]="فصل أدنى أدنى أدنى ",
    ["bg"]="Подподподсекция ",
    ["ca"]="Subsubsubsecció ",
    ["cn"]="",
    ["cs"]="Podpodpodsekce ",
    ["da"]="",
    ["de"]="",
    ["en"]="Subsubsubsection",
    ["eo"]="Subsubsubsekcio ",
    ["es"]="Subsubsubsección ",
    ["et"]="",
    ["fa"]="زیرزیرزیربخش ",
    ["fi"]="",
    ["fr"]="Soussoussoussection ",
    ["gr"]="",
    ["hr"]="Podpodpododjeljak ",
    ["hu"]="Al-al-alfejezet ",
    ["it"]="",
    ["ja"]="",
    ["la"]="",
    ["lt"]="",
    ["mk"]="Подподподпоглавје ",
    ["nb"]="",
    ["nl"]="",
    ["nn"]="",
    ["pl"]="",
    ["pt"]="",
    ["ro"]="",
    ["ru"]="",
    ["sk"]="Podpodpodsekcia ",
    ["sl"]="",
    ["sr"]="Подподпододељак ",
    ["sr-latn"]="Podpodpododeljak ",
    ["sv"]="",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="",
    ["vi"]="",
   },
  },
  ["sunday"]={
   ["labels"]={
    ["af"]="sondag",
    ["ar"]="الأحد",
    ["be"]="нядзеля",
    ["bg"]="неделя",
    ["ca"]="diumenge",
    ["cn"]="星期日",
    ["cs"]="neděle",
    ["da"]="søndag",
    ["de"]="Sonntag",
    ["en"]="Sunday",
    ["eo"]="dimanĉo",
    ["es"]="domingo",
    ["et"]="pühapäev",
    ["fa"]="یکشنبه",
    ["fi"]="sunnuntai",
    ["fr"]="dimanche",
    ["gr"]="Κυριακή",
    ["hr"]="nedjelja",
    ["hu"]="vasárnap",
    ["it"]="domenica",
    ["ja"]="日曜日",
    ["kr"]="일요일",
    ["la"]="Dies Solis",
    ["lt"]="sekmadienis",
    ["mk"]="недела",
    ["nb"]="søndag",
    ["nl"]="zondag",
    ["nn"]="sundag",
    ["pl"]="niedziela",
    ["pt"]="domingo",
    ["ro"]="duminică",
    ["ru"]="воскресенье",
    ["sk"]="nedeľa",
    ["sl"]="nedelja",
    ["sr"]="недеља",
    ["sr-latn"]="nedelja",
    ["sv"]="söndag",
    ["tk"]="dynç gün",
    ["tr"]="pazar",
    ["ua"]="неділя",
    ["vi"]="chủ nhật",
   },
  },
  ["sunday:mnem"]={
   ["labels"]={
    ["bg"]="нд",
    ["cs"]="ne",
    ["de"]="So.",
    ["en"]="sun",
    ["eo"]="dim.",
    ["sk"]="ne",
    ["sr"]="нед",
    ["sr-latn"]="ned",
   },
  },
  ["table"]={
   ["labels"]={
    ["af"]="Tabel",
    ["ar"]="جدول ",
    ["be"]="Табліца ",
    ["bg"]="Таблица ",
    ["ca"]="Taula ",
    ["cn"]="表",
    ["cs"]="Tabulka ",
    ["da"]="Tabel ",
    ["de"]="Tabelle ",
    ["en"]="Table ",
    ["eo"]="Tabelo ",
    ["es"]="Tabla ",
    ["et"]="Tabel ",
    ["fa"]="جدول ",
    ["fi"]="Taulukko ",
    ["fr"]="Tableau ",
    ["gr"]="Πίνακας",
    ["hr"]="Tablica ",
    ["hu"]={ "", " táblázat" },
    ["it"]="Tabella ",
    ["ja"]="表",
    ["kr"]="표 ",
    ["la"]="Tabula ",
    ["lt"]={ "", " lentelė." },
    ["mk"]="Табела ",
    ["nb"]="Tabell ",
    ["nl"]="Tabel ",
    ["nn"]="Tabell ",
    ["pl"]="Tabela ",
    ["pt"]="Tabela ",
    ["ro"]="Tabelul ",
    ["ru"]="Таблица ",
    ["sk"]="Tabuľka ",
    ["sl"]="Tabela ",
    ["sr"]="Табела ",
    ["sr-latn"]="Tabela ",
    ["sv"]="Tabell ",
    ["tk"]="Tablisa",
    ["tr"]="Tablo ",
    ["ua"]="Таблиця ",
    ["vi"]="Bảng ",
   },
  },
  ["thursday"]={
   ["labels"]={
    ["af"]="donderdag",
    ["ar"]="الخميس",
    ["be"]="чацвер",
    ["bg"]="четвъртък",
    ["ca"]="dijous",
    ["cn"]="星期四",
    ["cs"]="čtvrtek",
    ["da"]="torsdag",
    ["de"]="Donnerstag",
    ["en"]="Thursday",
    ["eo"]="ĵaŭdo",
    ["es"]="jueves",
    ["et"]="neljapäev",
    ["fa"]="پنج‌شنبه",
    ["fi"]="torstai",
    ["fr"]="jeudi",
    ["gr"]="Πέμπτη",
    ["hr"]="četvrtak",
    ["hu"]="csütörtök",
    ["it"]="giovedì",
    ["ja"]="木曜日",
    ["kr"]="목요일",
    ["la"]="Dies Iovis",
    ["lt"]="ketvirtadienis",
    ["mk"]="четврток",
    ["nb"]="torsdag",
    ["nl"]="donderdag",
    ["nn"]="torsdag",
    ["pl"]="czwartek",
    ["pt"]="quinta-feira",
    ["ro"]="joi",
    ["ru"]="четверг",
    ["sk"]="štvrtok",
    ["sl"]="četrtek",
    ["sr"]="четвртак",
    ["sr-latn"]="četvrtak",
    ["sv"]="torsdag",
    ["tk"]="dördünji gün",
    ["tr"]="perşembe",
    ["ua"]="четвер",
    ["vi"]="thứ năm",
   },
  },
  ["thursday:mnem"]={
   ["labels"]={
    ["bg"]="чт",
    ["cs"]="čt",
    ["de"]="Do.",
    ["en"]="thu",
    ["eo"]="ĵaŭ.",
    ["sk"]="št",
    ["sr"]="чет",
    ["sr-latn"]="čet",
   },
  },
  ["tuesday"]={
   ["labels"]={
    ["af"]="dinsdag",
    ["ar"]="الثلاثاء",
    ["be"]="аўторак",
    ["bg"]="вторник",
    ["ca"]="dimarts",
    ["cn"]="星期二",
    ["cs"]="úterý",
    ["da"]="tirsdag",
    ["de"]="Dienstag",
    ["en"]="Tuesday",
    ["eo"]="mardo",
    ["es"]="martes",
    ["et"]="teisipäev",
    ["fa"]="سه‌شنبه",
    ["fi"]="tiistai",
    ["fr"]="mardi",
    ["gr"]="Τρίτη",
    ["hr"]="utorak",
    ["hu"]="kedd",
    ["it"]="martedì",
    ["ja"]="火曜日",
    ["kr"]="화요일",
    ["la"]="Dies Martis",
    ["lt"]="antradienis",
    ["mk"]="вторник",
    ["nb"]="tirsdag",
    ["nl"]="dinsdag",
    ["nn"]="tysdag",
    ["pl"]="wtorek",
    ["pt"]="terça-feira",
    ["ro"]="marți",
    ["ru"]="вторник",
    ["sk"]="utorok",
    ["sl"]="torek",
    ["sr"]="уторак",
    ["sr-latn"]="utorak",
    ["sv"]="tisdag",
    ["tk"]="ikinji gün",
    ["tr"]="salı",
    ["ua"]="вівторок",
    ["vi"]="thứ ba",
   },
  },
  ["tuesday:mnem"]={
   ["labels"]={
    ["bg"]="вт",
    ["cs"]="út",
    ["de"]="Di.",
    ["en"]="tue",
    ["eo"]="mar.",
    ["sk"]="út",
    ["sr"]="уто",
    ["sr-latn"]="uto",
   },
  },
  ["wednesday"]={
   ["labels"]={
    ["af"]="woensdag",
    ["ar"]="الأربعاء",
    ["be"]="серада",
    ["bg"]="сряда",
    ["ca"]="dimecres",
    ["cn"]="星期三",
    ["cs"]="středa",
    ["da"]="onsdag",
    ["de"]="Mittwoch",
    ["en"]="Wednesday",
    ["eo"]="merkredo",
    ["es"]="miércoles",
    ["et"]="kolmapäev",
    ["fa"]="چهارشنبه",
    ["fi"]="keskiviikko",
    ["fr"]="mercredi",
    ["gr"]="Τετάρτη",
    ["hr"]="srijeda",
    ["hu"]="szerda",
    ["it"]="mercoledì",
    ["ja"]="水曜日",
    ["kr"]="수요일",
    ["la"]="Dies Mercuri",
    ["lt"]="trečiadienis",
    ["mk"]="среда",
    ["nb"]="onsdag",
    ["nl"]="woensdag",
    ["nn"]="onsdag",
    ["pl"]="środa",
    ["pt"]="quarta-feira",
    ["ro"]="miercuri",
    ["ru"]="среда",
    ["sk"]="streda",
    ["sl"]="sreda",
    ["sr"]="среда",
    ["sr-latn"]="sreda",
    ["sv"]="onsdag",
    ["tk"]="üçünji",
    ["tr"]="çarşamba",
    ["ua"]="середа",
    ["vi"]="thứ tư",
   },
  },
  ["wednesday:mnem"]={
   ["labels"]={
    ["bg"]="ср",
    ["cs"]="st",
    ["de"]="Mi.",
    ["en"]="wed",
    ["eo"]="mer.",
    ["sk"]="st",
    ["sr"]="сре",
    ["sr-latn"]="sre",
   },
  },
  ["year"]={
   ["labels"]={
    ["bg"]="година",
    ["en"]="year",
    ["eo"]="jaro",
    ["et"]="aasta",
    ["fa"]="سال",
    ["kr"]="년",
    ["mk"]="година",
    ["nl"]="jaar",
    ["sr"]="година",
    ["sr-latn"]="godina",
   },
  },
 },
 ["titles"]={
  ["abbreviations"]={
   ["labels"]={
    ["af"]="Afkortings",
    ["ar"]="الاختصارات",
    ["be"]="Спіс скарачэнняў",
    ["bg"]="Съкращения",
    ["ca"]="Abreviacions",
    ["cn"]="缩略语",
    ["cs"]="Zkratky",
    ["da"]="Forkortelser",
    ["de"]="Abkürzungen",
    ["en"]="Abbreviations",
    ["eo"]="Mallongigoj",
    ["es"]="Abreviaturas",
    ["et"]="Lühend",
    ["fa"]="نشانه‌های اختصاری",
    ["fi"]="Lyhennyksi",
    ["fr"]="Abréviations",
    ["gr"]="Συντομογραφίες",
    ["hr"]="Kratice",
    ["hu"]="Rövidítések",
    ["it"]="Abbreviazioni",
    ["ja"]="略語",
    ["kr"]="약어",
    ["la"]="Notae",
    ["lt"]="Santrumpos",
    ["mk"]="Скратеници",
    ["nb"]="Forkortelser",
    ["nl"]="Afkortingen",
    ["nn"]="Forkortingar",
    ["pl"]="Wykaz skrótów",
    ["pt"]="Abreviaturas",
    ["ro"]="Abrevieri",
    ["ru"]="Список сокращений",
    ["sk"]="Skratky",
    ["sl"]="Kratice",
    ["sr"]="Скраћенице",
    ["sr-latn"]="Skraćenice",
    ["sv"]="Förkortningar",
    ["tk"]="Gysgaltmalar",
    ["tr"]="Kısaltmalar",
    ["ua"]="Перелік скорочень",
    ["vi"]="Chữ viết tắt",
   },
  },
  ["content"]={
   ["labels"]={
    ["af"]="Inhoud",
    ["ar"]="المحتويات",
    ["be"]="Змест",
    ["bg"]="Съдържание",
    ["ca"]="Índex de continguts",
    ["cn"]="目录",
    ["cs"]="Obsah",
    ["da"]="Indhold",
    ["de"]="Inhalt",
    ["en"]="Contents",
    ["eo"]="Enhavo",
    ["es"]="Contenido",
    ["et"]="Sisu",
    ["fa"]="فهرست مطالب",
    ["fi"]="Sisällys",
    ["fr"]="Table des matières",
    ["gr"]="Περιεχόμενα",
    ["hr"]="Sadržaj",
    ["hu"]="Tartalom",
    ["it"]="Indice",
    ["ja"]="目次",
    ["kr"]="목차",
    ["la"]="Quod in libro continetur",
    ["lt"]="Turinys",
    ["mk"]="Содржина",
    ["nb"]="Innhold",
    ["nl"]="Inhoud",
    ["nn"]="Innhald",
    ["pl"]="Spis treści",
    ["pt"]="Conteúdo",
    ["ro"]="Cuprins",
    ["ru"]="Содержание",
    ["sk"]="Obsah",
    ["sl"]="Kazalo",
    ["sr"]="Садржај",
    ["sr-latn"]="Sadržaj",
    ["sv"]="Innehåll",
    ["tk"]="Mazmuny",
    ["tr"]="Fihrist",
    ["ua"]="Зміст",
    ["vi"]="Mục lục",
   },
  },
  ["figures"]={
   ["labels"]={
    ["af"]="Figure",
    ["ar"]="الأشكال",
    ["be"]="Спіс ілюстрацый",
    ["ca"]="Figures",
    ["cn"]="图形",
    ["cs"]="Seznam obrázků",
    ["da"]="Figurer",
    ["de"]="Abbildungen",
    ["en"]="Figures",
    ["eo"]="Figuroj",
    ["es"]="Figuras",
    ["et"]="Arvandmed",
    ["fa"]="فهرست اشکال",
    ["fi"]="Kuvi",
    ["fr"]="Figures",
    ["gr"]="Σχήματα",
    ["hr"]="Slike",
    ["hu"]="Ábrák",
    ["it"]="Figure",
    ["ja"]="図",
    ["kr"]="그림 ",
    ["la"]="Imagines",
    ["lt"]="Iliustracijos",
    ["mk"]="Листа на слики",
    ["nb"]="Figurer",
    ["nl"]="Figuren",
    ["nn"]="Figurar",
    ["pl"]="Ilustracje",
    ["pt"]="Figuras",
    ["ro"]="Figuri",
    ["ru"]="Список иллюстраций",
    ["sk"]="Zoznam obrázkov",
    ["sl"]="Slike",
    ["sr"]="Слике",
    ["sr-latn"]="Slike",
    ["sv"]="Figurer",
    ["tk"]="Suratlar",
    ["tr"]="Şekiller",
    ["ua"]="Перелік ілюстрацій",
    ["vi"]="Danh sách hình vẽ",
   },
  },
  ["graphics"]={
   ["labels"]={
    ["af"]="Grafieke",
    ["ar"]="الرسوم",
    ["be"]="Графiка",
    ["bg"]="Графики",
    ["ca"]="Gràfiques",
    ["cn"]="图",
    ["cs"]="Seznam grafů",
    ["da"]="Grafik",
    ["de"]="Graphiken",
    ["en"]="Graphics",
    ["eo"]="Grafikoj",
    ["es"]="Gráficos",
    ["et"]="Graafika",
    ["fa"]="فهرست طرح‌ها",
    ["fi"]="Grafiikkaoi",
    ["fr"]="Graphiques",
    ["gr"]="Γραφικά",
    ["hr"]="Slike",
    ["hu"]="Grafikák",
    ["it"]="Grafici",
    ["ja"]="グラフ",
    ["kr"]="그래픽 ",
    ["la"]="Typi",
    ["lt"]="Graphics",
    ["mk"]="Листа на графици",
    ["nb"]="Bilde",
    ["nl"]="Grafieken",
    ["nn"]="Bilete",
    ["pl"]="Grafiki",
    ["pt"]="Gráficos",
    ["ro"]="Grafice",
    ["ru"]="Список графиков",
    ["sk"]="Zoznam grafov",
    ["sl"]="Slike",
    ["sr"]="Графици",
    ["sr-latn"]="Grafici",
    ["sv"]="Grafik",
    ["tk"]="Grafikler",
    ["tr"]="Grafikler",
    ["ua"]="Перелік графіков",
    ["vi"]="Đồ thị",
   },
  },
  ["index"]={
   ["labels"]={
    ["af"]="Indeks",
    ["ar"]="الفهرس",
    ["be"]="Алфавітны паказальнік",
    ["bg"]="Индэкс",
    ["ca"]="Índex alfabètic",
    ["cn"]="索引",
    ["cs"]="Rejstřík",
    ["da"]="Indeks",
    ["de"]="Index",
    ["en"]="Index",
    ["eo"]="Indekso",
    ["es"]="Índice",
    ["et"]="Indeks",
    ["fa"]="نمایه",
    ["fi"]="Indeksiluku",
    ["fr"]="Index",
    ["gr"]="Ευρετήριο",
    ["hr"]="Indeks",
    ["hu"]="Index",
    ["it"]="Indice",
    ["ja"]="目次",
    ["kr"]="찾아보기",
    ["la"]="Indices",
    ["lt"]="Rodyklė",
    ["mk"]="Индекс",
    ["nb"]="Register",
    ["nl"]="Index",
    ["nn"]="Register",
    ["pl"]="Indeks",
    ["pt"]="Índice",
    ["ro"]="Index",
    ["ru"]="Алфавитный указатель",
    ["sk"]="Zoznam",
    ["sl"]="Stvarno kazalo",
    ["sr"]="Индекс појмова",
    ["sr-latn"]="Indeks pojmova",
    ["sv"]="Sakregister",
    ["tk"]="Indeks",
    ["tr"]="İndex",
    ["ua"]="Покажчик",
    ["vi"]="Chỉ số",
   },
  },
  ["intermezzi"]={
   ["labels"]={
    ["af"]="Intermezzos",
    ["ar"]="فسح",
    ["be"]="Спіс уставак",
    ["bg"]="Интермеца",
    ["ca"]="Intermedis",
    ["cn"]="퉣",
    ["cs"]="Intermezza",
    ["da"]="Intermezzoer",
    ["de"]="Intermezzi",
    ["en"]="Intermezzos",
    ["eo"]="Intermezoj",
    ["es"]="Intermedios",
    ["et"]="Vahemängud",
    ["fi"]="Intermezzos",
    ["fr"]="Intermèdes",
    ["gr"]="Παύσεις",
    ["hr"]="Intermeci",
    ["hu"]="Intermezzok",
    ["it"]="Intermezzi",
    ["ja"]="間奏曲",
    ["kr"]="간주곡",
    ["la"]="Intermissa",
    ["lt"]="Intermezzos",
    ["mk"]="Листа на дигресии",
    ["nb"]="Intermesso",
    ["nl"]="Intermezzo's",
    ["nn"]="Intermesso",
    ["pl"]="Intermezza",
    ["pt"]="Intermédios",
    ["ro"]="Intermzzo",
    ["ru"]="Список вставок",
    ["sk"]="Intermezzá",
    ["sl"]="Intermezzi",
    ["sr"]="Списак дигресија",
    ["sr-latn"]="Spisak digresija",
    ["sv"]="Intermezzon",
    ["tk"]="Arakesmeler",
    ["tr"]="",
    ["ua"]="Перелік вставок",
    ["vi"]="Intermezzos",
   },
  },
  ["logos"]={
   ["labels"]={
    ["af"]="Logos",
    ["ar"]="الشعارات",
    ["be"]="Лагатыпы",
    ["bg"]="Логотипи",
    ["ca"]="Logotips",
    ["cn"]="徽贬",
    ["cs"]="Loga",
    ["da"]="Logoer",
    ["de"]="Logos",
    ["en"]="Logos",
    ["eo"]="Markemblemoj",
    ["es"]="Logotipos",
    ["et"]="Logos",
    ["fa"]="فهرست لوگوها",
    ["fi"]="Vertauskuva",
    ["fr"]="Logos",
    ["gr"]="Λογότυπα",
    ["hr"]="Logotipi",
    ["hu"]="Fejlécek",
    ["it"]="Logotipi",
    ["ja"]="理性",
    ["kr"]="이성",
    ["la"]="Typi negotiales",
    ["lt"]="Logos",
    ["mk"]="Логоа",
    ["nb"]="Logoer",
    ["nl"]="Logo's",
    ["nn"]="Logoar",
    ["pl"]="Znaki",
    ["pt"]="Logotipos",
    ["ro"]="Logo-uri",
    ["ru"]="Логотипы",
    ["sk"]="Logá",
    ["sl"]="Logotipi",
    ["sr"]="Логотипи",
    ["sr-latn"]="Logotipi",
    ["sv"]="Loggor",
    ["tk"]="Logolar",
    ["tr"]="Logolar",
    ["ua"]="Логотипи",
    ["vi"]="Biểu tượng",
   },
  },
  ["pubs"]={
   ["labels"]={
    ["af"]="",
    ["ca"]="Referències",
    ["cs"]="Literatura",
    ["da"]="",
    ["de"]="Literatur",
    ["en"]="References",
    ["eo"]="Referencoj",
    ["es"]="Bibliografía",
    ["et"]="Viited",
    ["fa"]="کتاب‌نامه",
    ["fi"]="",
    ["fr"]="Bibliographie",
    ["gr"]="",
    ["hr"]="Literatura",
    ["hu"]="Bibliográfia",
    ["it"]="Bibliografia",
    ["kr"]="참고문헌",
    ["la"]="",
    ["lt"]="Literatūra",
    ["mk"]="Литература",
    ["nb"]="",
    ["nl"]="Literatuur",
    ["nn"]="",
    ["pl"]="Bibliografia",
    ["pt"]="",
    ["ro"]="",
    ["ru"]="",
    ["sk"]="Literatúra",
    ["sl"]="Literatura",
    ["sr"]="Литература",
    ["sr-latn"]="Literatura",
    ["sv"]="",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="",
    ["vi"]="",
   },
  },
  ["tables"]={
   ["labels"]={
    ["af"]="Tabelle",
    ["ar"]="الجداول",
    ["be"]="Спіс табліц",
    ["ca"]="Taules",
    ["cn"]="表格",
    ["cs"]="Seznam tabulek",
    ["da"]="Tabeller",
    ["de"]="Tabellen",
    ["en"]="Tables",
    ["eo"]="Tabeloj",
    ["es"]="Tablas",
    ["et"]="Tabelid",
    ["fa"]="فهرست جداول",
    ["fi"]="Taulukkoj",
    ["fr"]="Tableaux",
    ["gr"]="Πίνακες",
    ["hr"]="Tablice",
    ["hu"]="Táblázatok",
    ["it"]="Tabelle",
    ["ja"]="机",
    ["kr"]="표 ",
    ["la"]="Tabulae",
    ["lt"]="Lentelės",
    ["mk"]="Листа на табели",
    ["nb"]="Tabeller",
    ["nl"]="Tabellen",
    ["nn"]="Tabellar",
    ["pl"]="Tabele",
    ["pt"]="Tabelas",
    ["ro"]="Tabele",
    ["ru"]="Список таблиц",
    ["sk"]="Zoznam tabuliek",
    ["sl"]="Tabele",
    ["sr"]="Табеле",
    ["sr-latn"]="Tabele",
    ["sv"]="Tabeller",
    ["tk"]="Tablisalar",
    ["tr"]="Tablolar",
    ["ua"]="Перелік таблиць",
    ["vi"]="Danh sách bảng",
   },
  },
  ["units"]={
   ["labels"]={
    ["af"]="Eenhede",
    ["ar"]="الوحدات",
    ["be"]="Адзінкі вымярэння",
    ["bg"]="Адзінкі",
    ["ca"]="Unitats",
    ["cn"]="计量单位",
    ["cs"]="Jednotky",
    ["da"]="Enheder",
    ["de"]="Einheiten",
    ["en"]="Units",
    ["eo"]="Unuoj",
    ["es"]="Unidades",
    ["et"]="Ühikud",
    ["fa"]="واحدها",
    ["fi"]="Yksiköt",
    ["fr"]="Unités",
    ["gr"]="Μονάδες",
    ["hr"]="Jedinice",
    ["hu"]="Mértékegységek",
    ["it"]="Unità",
    ["ja"]="ユニッツ",
    ["kr"]="측정단위",
    ["la"]="Modi",
    ["lt"]="Units",
    ["mk"]="Единици",
    ["nb"]="Enheter",
    ["nl"]="Eenheden",
    ["nn"]="Einingar",
    ["pl"]="Jednostki",
    ["pt"]="Unidades",
    ["ro"]="Unități",
    ["ru"]="Единицы измерения",
    ["sk"]="Jednotky",
    ["sl"]="Enote",
    ["sr"]="Јединице",
    ["sr-latn"]="Jedinice",
    ["sv"]="Enheter",
    ["tk"]="Birlikler",
    ["tr"]="Birimler",
    ["ua"]="Одиниці виміру",
    ["vi"]="Đơn vị",
   },
  },
 },
}

local functions = data.labels.functions

functions.asin   = functions.arcsin
functions.acos   = functions.arccos
functions.atan   = functions.arctan
functions.asinh  = functions.arcsinh
functions.acosh  = functions.arccosh
functions.atanh  = functions.arctanh

functions.tg     = functions.tan
functions.arctg  = functions.arctan
functions.arctgh = functions.arctanh

