/* allow5c.c : public domain (2018/05/27 --ak).
 * a preprocessor for dvipdfmx.
 *
 * support kanji characters which contain 0x5c in CP932-like
 * code page as image file names in (e)-pTeX on Windows.
 * 
 * a dviout utility 'dvispc' is used to duplicate 0x5c as an
 * escape sequence in dvi.
 *
 * Usate: allow5c DVIname
 * Here, DVIname is a DVI file name created by (e)-pTeX on Windows.
 * The file DVIname is rewritten by allow5c and the original DVI
 * is saved with a suffix .bak.
 *
 * bug fix: 2019/11/09
 * remove dependence on kpathsea: 2019/11/29
 * add "pdf:dest" and "pdf:out" in order to escape
 * ASCII 0x5c: 2020/04/18
 */

#include <stdio.h>
#include <string.h>
#include <process.h>
#include <windows.h>

static int is_cp932_like_system = 0x7fffffff;

static int
isknj(int c)
{
  if (is_cp932_like_system == 0x7fffffff) {
    is_cp932_like_system = GetACP();
  }
  c &= 0xff;
  switch (is_cp932_like_system) {
  case 932:
    return((c>=0x81 && c<=0x9f) || (c>=0xe0 && c<=0xfc));
  case 936:
    return(c>=0x81 && c<=0xfe);
  case 950:
    return((c>=0xa1 && c<=0xc6) || (c>=0xc9 && c<=0xf9));
  default:
    return(0);
  }
}

static int
isknj2(int c)
{
  if (is_cp932_like_system == 0x7fffffff) {
    is_cp932_like_system = GetACP();
  }
  c &= 0xff;
  switch (is_cp932_like_system) {
  case 932:
    return(c>=0x40 && c<=0xfc && c!=0x7f);
  case 936:
    return(c>=0x40 && c<=0xfe && c!=0x7f);
  case 950:
    return((c>=0x40 && c<=0x7e) || (c>=0xa1 && c<=0xfe));
  default:
    return(0);
  }
}

static int
file_existp(char *name)
{
  FILE *fp;
  fp = fopen(name, "r");
  if (fp) {
    fclose(fp);
    return 1;
  } else {
    return 0;
  }
}

int main(int argc, char **argv)
{
  char fname[256];
  char bakname[256];
  char txtname1[256];
  char txtname2[256];
  unsigned char cmdline[1024];
  unsigned char buffer[4096];
  unsigned char buffer2[4096];
  unsigned char *p, *q;
  FILE *f, *g;
  int  ret, c, cc;

  if (argc != 2) {
    fprintf(stderr, "Usage: allow5c DVIname\n");
    return 0;
  }

  if (strlen(argv[1]) > 250) {
    fprintf(stderr, "dvi name is too long.\n");
    return 4;
  }
  strcpy(fname, argv[1]);
  p = strrchr(fname, '.');
  if (p == NULL || stricmp(p, ".dvi"))
    strcat(fname, ".dvi");

  if (!file_existp(fname)) {
    fprintf(stderr, "%s does not exist.\n", fname);
    return 3;
  }

  if (strlen(fname) > 250) {
    fprintf(stderr, "dvi name is too long.\n");
    return 4;
  }
  strcpy(bakname, fname);
  strcat(bakname, ".bak");

  CopyFile(fname, bakname, 0);

  if (strlen(bakname) > 250) {
    fprintf(stderr, "dvi name is too long.\n");
    return 4;
  }
  strcpy(txtname1, bakname);
  strcat(txtname1, ".txt");

  if(strlen(fname) + strlen(txtname1) > 1012) {
    fprintf(stderr, "dvi name is too long.\n");
    return 4;
  }
  strcpy(cmdline, "dvispc ");
  strcat(cmdline, "-a ");
  strcat(cmdline, fname);
  strcat(cmdline, " ");
  strcat(cmdline, txtname1);

  ret = system(cmdline);

  if (ret == 0) {
    f = fopen(txtname1, "rb");
    if (strlen(txtname1) > 254) {
      fprintf(stderr, "dvi name is too long.\n");
      return 4;
    }
    strcpy(txtname2, txtname1);
    strcat(txtname2, "2");
    g = fopen(txtname2, "wb");

    while((fgets(buffer, 4000, f))) {
      if (strncmp(buffer, "xxx", 3) == 0 &&
          (strstr(buffer, "pdf:img") != NULL ||
           strstr(buffer, "pdf:image") != NULL ||
           strstr(buffer, "pdf:epdf") != NULL)) {
        int n1, n2 = 0;
        p = buffer;
        q = buffer2;
        while (*p != ' ')
          p++;
        while (*p == ' ')
          p++;
        sscanf(p, "%d ", &n1);
        while (*p != ' ')
          p++;
        while (*p == ' ')
          p++;
        while (*p) {
          if (isknj(*p)) {
            *q++ = *p++;
            if (!*p)
              break;
            else {
              *q++ = *p;
              if (isknj2(*p) && (*p & 0xff) == '\\') {
                if ((*(p+1) & 0xff) != '\\') {
                  *q++ = '\\';
                  n2++;
                }
              }
            }
          } else {
            *q++ = *p;
          }
          p++;
        }
        *q = '\0';

        p = buffer;
        while (*p != ' ') {
          putc(*p, g);
          p++;
        }
        while (*p == ' ') {
          putc(*p, g);
          p++;
        }
        fprintf(g, "%d ", n1 + n2);
        p = buffer2;
        while (*p) {
          putc(*p, g);
          p++;
        }
      } else if (strncmp(buffer, "xxx", 3) == 0 &&
                 (strstr(buffer, "pdf:dest") != NULL ||
                  strstr(buffer, "pdf:out") != NULL)) {
        int n1, n2 = 0;
        p = buffer;
        q = buffer2;
        while (*p != ' ')
          p++;
        while (*p == ' ')
          p++;
        sscanf(p, "%d ", &n1);
        while (*p != ' ')
          p++;
        while (*p == ' ')
          p++;
        while (*p) {
          if (isknj(*p) && isknj2(*(p+1))) {
            /* skip in this case, because it is OK
             * by tounicode special
             */
            *q++ = *p++;
            *q++ = *p;
          } else if (*p == '\\') {
            *q++ = *p++;
            if (!*p)
              break;
            else {
              if (*p != '\\') {
                *q++ = '\\';
                n2++;
              }
              *q++ = *p;
            }
          } else {
            *q++ = *p;
          }
          p++;
        }
        *q = '\0';

        p = buffer;
        while (*p != ' ') {
          putc(*p, g);
          p++;
        }
        while (*p == ' ') {
          putc(*p, g);
          p++;
        }
        fprintf(g, "%d ", n1 + n2);
        p = buffer2;
        while (*p) {
          putc(*p, g);
          p++;
        }
      } else {
        fputs(buffer, g);
      }
    }

    fclose(f);
    fclose(g);

    if(strlen(fname) + strlen(txtname2) > 1012) {
      fprintf(stderr, "dvi name is too long.\n");
      return 4;
    }

    strcpy(cmdline, "dvispc ");
    strcat(cmdline, "-x ");
    strcat(cmdline, txtname2);
    strcat(cmdline, " ");
    strcat(cmdline, fname);

    ret = system(cmdline);

    if (ret == 0) {
      fprintf(stdout, "%s is now a new dvi.\n", fname);
      fprintf(stdout, "Original dvi is saved as %s.\n", bakname);

      if (file_existp(txtname1))
        remove(txtname1);
      if (file_existp(txtname2))
        remove(txtname2);

      return 0;
    } else {
      fprintf(stdout, "dvispc command faild.\n");
      if (file_existp(txtname1))
        remove(txtname1);
      if (file_existp(txtname2))
        remove(txtname2);
      if (file_existp(bakname)) {
        CopyFile(bakname, fname, 0);
        remove(bakname);
      }
      return 2;
    }
  } else {
    fprintf(stdout, "dvispc command faild.\n");
    if (file_existp(txtname1))
      remove(txtname1);
    if (file_existp(txtname2))
      remove(txtname2);
    if (file_existp(bakname)) {
      CopyFile(bakname, fname, 0);
      remove(bakname);
    }
    return 1;
  }
}
