/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.terminal;

import com.github.ajalt.colormath.Ansi16;
import com.github.ajalt.colormath.Ansi256;
import com.github.ajalt.colormath.CMYK;
import com.github.ajalt.colormath.Color;
import com.github.ajalt.colormath.HSL;
import com.github.ajalt.colormath.HSV;
import com.github.ajalt.colormath.LAB;
import com.github.ajalt.colormath.RGB;
import com.github.ajalt.colormath.RenderCondition;
import com.github.ajalt.colormath.XYZ;
import com.github.ajalt.mordant.rendering.TextStyle;
import com.github.ajalt.mordant.rendering.TextStyleKt;
import com.github.ajalt.mordant.terminal.AnsiLevel;
import com.github.ajalt.mordant.terminal.TextColors$Companion$WhenMappings;
import com.github.ajalt.mordant.terminal.TextStyles;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\b\u0086\u0001\u0018\u0000 Q2\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u00022\u00020\u0003:\u0001QB\u000f\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0011\u0010&\u001a\u00020\u00192\u0006\u0010'\u001a\u00020\u0019H\u0096\u0003J\u0011\u0010(\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003H\u0096\u0005J\u0011\u0010)\u001a\u00020\u00032\u0006\u0010*\u001a\u00020\u0003H\u0096\u0003J\u0011\u0010)\u001a\u00020\u00032\u0006\u0010*\u001a\u00020+H\u0096\u0003J\t\u0010,\u001a\u00020-H\u0096\u0001J\t\u0010.\u001a\u00020/H\u0096\u0001J\t\u00100\u001a\u000201H\u0096\u0001J\t\u00102\u001a\u000203H\u0096\u0001J\t\u00104\u001a\u000205H\u0096\u0001J\u001d\u00106\u001a\u00020\u00192\b\b\u0002\u00107\u001a\u00020\u00112\b\b\u0002\u00108\u001a\u000209H\u0096\u0001J\t\u0010:\u001a\u00020;H\u0096\u0001J\t\u0010<\u001a\u00020=H\u0096\u0001J\b\u0010>\u001a\u00020\u0019H\u0016J\t\u0010?\u001a\u00020@H\u0096\u0001R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u0003X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u0004\u0018\u00010\u0002X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00020\u0011X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u0004\u0018\u00010\u0002X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000fR\u0012\u0010\u0016\u001a\u00020\u0011X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0013R\u0014\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u0004\u0018\u00010\u0019X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001bR\u0012\u0010\u001e\u001a\u00020\u0011X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0013R\u0012\u0010 \u001a\u00020\u0011X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0013R\u0012\u0010\"\u001a\u00020\u0011X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0013R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010$\u001a\u00020\u0011X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0013j\u0002\bAj\u0002\bBj\u0002\bCj\u0002\bDj\u0002\bEj\u0002\bFj\u0002\bGj\u0002\bHj\u0002\bIj\u0002\bJj\u0002\bKj\u0002\bLj\u0002\bMj\u0002\bNj\u0002\bOj\u0002\bP\u00a8\u0006R"}, d2={"Lcom/github/ajalt/mordant/terminal/TextColors;", "", "Lcom/github/ajalt/colormath/Color;", "Lcom/github/ajalt/mordant/rendering/TextStyle;", "textStyle", "(Ljava/lang/String;ILcom/github/ajalt/mordant/rendering/TextStyle;)V", "alpha", "", "getAlpha", "()F", "bg", "getBg", "()Lcom/github/ajalt/mordant/rendering/TextStyle;", "bgColor", "getBgColor", "()Lcom/github/ajalt/colormath/Color;", "bold", "", "getBold", "()Z", "color", "getColor", "dim", "getDim", "hyperlink", "", "getHyperlink", "()Ljava/lang/String;", "hyperlinkId", "getHyperlinkId", "inverse", "getInverse", "italic", "getItalic", "strikethrough", "getStrikethrough", "underline", "getUnderline", "invoke", "text", "on", "plus", "other", "Lcom/github/ajalt/mordant/terminal/TextStyles;", "toAnsi16", "Lcom/github/ajalt/colormath/Ansi16;", "toAnsi256", "Lcom/github/ajalt/colormath/Ansi256;", "toCMYK", "Lcom/github/ajalt/colormath/CMYK;", "toHSL", "Lcom/github/ajalt/colormath/HSL;", "toHSV", "Lcom/github/ajalt/colormath/HSV;", "toHex", "withNumberSign", "renderAlpha", "Lcom/github/ajalt/colormath/RenderCondition;", "toLAB", "Lcom/github/ajalt/colormath/LAB;", "toRGB", "Lcom/github/ajalt/colormath/RGB;", "toString", "toXYZ", "Lcom/github/ajalt/colormath/XYZ;", "black", "red", "green", "yellow", "blue", "magenta", "cyan", "white", "gray", "brightRed", "brightGreen", "brightYellow", "brightBlue", "brightMagenta", "brightCyan", "brightWhite", "Companion", "mordant"})
public final class TextColors
extends Enum<TextColors>
implements Color,
TextStyle {
    public static final /* enum */ TextColors black;
    public static final /* enum */ TextColors red;
    public static final /* enum */ TextColors green;
    public static final /* enum */ TextColors yellow;
    public static final /* enum */ TextColors blue;
    public static final /* enum */ TextColors magenta;
    public static final /* enum */ TextColors cyan;
    public static final /* enum */ TextColors white;
    public static final /* enum */ TextColors gray;
    public static final /* enum */ TextColors brightRed;
    public static final /* enum */ TextColors brightGreen;
    public static final /* enum */ TextColors brightYellow;
    public static final /* enum */ TextColors brightBlue;
    public static final /* enum */ TextColors brightMagenta;
    public static final /* enum */ TextColors brightCyan;
    public static final /* enum */ TextColors brightWhite;
    private static final /* synthetic */ TextColors[] $VALUES;
    private final TextStyle textStyle;
    public static final Companion Companion;
    private final /* synthetic */ Color $$delegate_0;

    static {
        TextColors[] textColorsArray = new TextColors[16];
        TextColors[] textColorsArray2 = textColorsArray;
        textColorsArray[0] = black = new TextColors(TextStyleKt.TextStyle$default(new Ansi16(30), null, false, false, false, false, false, false, null, 510, null));
        textColorsArray[1] = red = new TextColors(TextStyleKt.TextStyle$default(new Ansi16(31), null, false, false, false, false, false, false, null, 510, null));
        textColorsArray[2] = green = new TextColors(TextStyleKt.TextStyle$default(new Ansi16(32), null, false, false, false, false, false, false, null, 510, null));
        textColorsArray[3] = yellow = new TextColors(TextStyleKt.TextStyle$default(new Ansi16(33), null, false, false, false, false, false, false, null, 510, null));
        textColorsArray[4] = blue = new TextColors(TextStyleKt.TextStyle$default(new Ansi16(34), null, false, false, false, false, false, false, null, 510, null));
        textColorsArray[5] = magenta = new TextColors(TextStyleKt.TextStyle$default(new Ansi16(35), null, false, false, false, false, false, false, null, 510, null));
        textColorsArray[6] = cyan = new TextColors(TextStyleKt.TextStyle$default(new Ansi16(36), null, false, false, false, false, false, false, null, 510, null));
        textColorsArray[7] = white = new TextColors(TextStyleKt.TextStyle$default(new Ansi16(37), null, false, false, false, false, false, false, null, 510, null));
        textColorsArray[8] = gray = new TextColors(TextStyleKt.TextStyle$default(new Ansi16(90), null, false, false, false, false, false, false, null, 510, null));
        textColorsArray[9] = brightRed = new TextColors(TextStyleKt.TextStyle$default(new Ansi16(91), null, false, false, false, false, false, false, null, 510, null));
        textColorsArray[10] = brightGreen = new TextColors(TextStyleKt.TextStyle$default(new Ansi16(92), null, false, false, false, false, false, false, null, 510, null));
        textColorsArray[11] = brightYellow = new TextColors(TextStyleKt.TextStyle$default(new Ansi16(93), null, false, false, false, false, false, false, null, 510, null));
        textColorsArray[12] = brightBlue = new TextColors(TextStyleKt.TextStyle$default(new Ansi16(94), null, false, false, false, false, false, false, null, 510, null));
        textColorsArray[13] = brightMagenta = new TextColors(TextStyleKt.TextStyle$default(new Ansi16(95), null, false, false, false, false, false, false, null, 510, null));
        textColorsArray[14] = brightCyan = new TextColors(TextStyleKt.TextStyle$default(new Ansi16(96), null, false, false, false, false, false, false, null, 510, null));
        textColorsArray[15] = brightWhite = new TextColors(TextStyleKt.TextStyle$default(new Ansi16(97), null, false, false, false, false, false, false, null, 510, null));
        $VALUES = textColorsArray;
        Companion = new Companion(null);
    }

    @NotNull
    public String toString() {
        return this.textStyle.toString();
    }

    private TextColors(TextStyle textStyle) {
        Color color = textStyle.getColor();
        Intrinsics.checkNotNull(color);
        this.$$delegate_0 = color;
        this.textStyle = textStyle;
    }

    @Override
    public float getAlpha() {
        return this.$$delegate_0.getAlpha();
    }

    @Override
    @NotNull
    public Ansi16 toAnsi16() {
        return this.$$delegate_0.toAnsi16();
    }

    @Override
    @NotNull
    public Ansi256 toAnsi256() {
        return this.$$delegate_0.toAnsi256();
    }

    @Override
    @NotNull
    public CMYK toCMYK() {
        return this.$$delegate_0.toCMYK();
    }

    @Override
    @NotNull
    public HSL toHSL() {
        return this.$$delegate_0.toHSL();
    }

    @Override
    @NotNull
    public HSV toHSV() {
        return this.$$delegate_0.toHSV();
    }

    @Override
    @NotNull
    public String toHex(boolean withNumberSign, @NotNull RenderCondition renderAlpha) {
        Intrinsics.checkNotNullParameter((Object)renderAlpha, "renderAlpha");
        return this.$$delegate_0.toHex(withNumberSign, renderAlpha);
    }

    @Override
    @NotNull
    public LAB toLAB() {
        return this.$$delegate_0.toLAB();
    }

    @Override
    @NotNull
    public RGB toRGB() {
        return this.$$delegate_0.toRGB();
    }

    @Override
    @NotNull
    public XYZ toXYZ() {
        return this.$$delegate_0.toXYZ();
    }

    @Override
    @NotNull
    public TextStyle getBg() {
        return this.textStyle.getBg();
    }

    @Override
    @Nullable
    public Color getBgColor() {
        return this.textStyle.getBgColor();
    }

    @Override
    public boolean getBold() {
        return this.textStyle.getBold();
    }

    @Override
    @Nullable
    public Color getColor() {
        return this.textStyle.getColor();
    }

    @Override
    public boolean getDim() {
        return this.textStyle.getDim();
    }

    @Override
    @Nullable
    public String getHyperlink() {
        return this.textStyle.getHyperlink();
    }

    @Override
    @Nullable
    public String getHyperlinkId() {
        return this.textStyle.getHyperlinkId();
    }

    @Override
    public boolean getInverse() {
        return this.textStyle.getInverse();
    }

    @Override
    public boolean getItalic() {
        return this.textStyle.getItalic();
    }

    @Override
    public boolean getStrikethrough() {
        return this.textStyle.getStrikethrough();
    }

    @Override
    public boolean getUnderline() {
        return this.textStyle.getUnderline();
    }

    @Override
    @NotNull
    public String invoke(@NotNull String text) {
        Intrinsics.checkNotNullParameter(text, "text");
        return this.textStyle.invoke(text);
    }

    @Override
    @NotNull
    public TextStyle on(@NotNull TextStyle bg) {
        Intrinsics.checkNotNullParameter(bg, "bg");
        return this.textStyle.on(bg);
    }

    @Override
    @NotNull
    public TextStyle plus(@NotNull TextStyle other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.textStyle.plus(other);
    }

    @Override
    @NotNull
    public TextStyle plus(@NotNull TextStyles other) {
        Intrinsics.checkNotNullParameter((Object)other, "other");
        return this.textStyle.plus(other);
    }

    public static TextColors[] values() {
        return (TextColors[])$VALUES.clone();
    }

    public static TextColors valueOf(String string) {
        return Enum.valueOf(TextColors.class, string);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\r\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\b\b\u0002\u0010\n\u001a\u00020\u000bJ\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\n\u001a\u00020\u000bJ\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\n\u001a\u00020\u000bJ(\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00062\b\b\u0002\u0010\n\u001a\u00020\u000bJ(\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00062\b\b\u0002\u0010\n\u001a\u00020\u000bJ(\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u00102\b\b\u0002\u0010\n\u001a\u00020\u000bJ(\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u00062\b\b\u0002\u0010\n\u001a\u00020\u000bJ\u0018\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001e2\b\b\u0002\u0010\n\u001a\u00020\u000bJ(\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u00102\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a8\u0006\""}, d2={"Lcom/github/ajalt/mordant/terminal/TextColors$Companion;", "", "()V", "cmyk", "Lcom/github/ajalt/mordant/rendering/TextStyle;", "c", "", "m", "y", "k", "level", "Lcom/github/ajalt/mordant/terminal/AnsiLevel;", "color", "Lcom/github/ajalt/colormath/Color;", "gray", "fraction", "", "hsl", "h", "s", "l", "hsv", "v", "lab", "a", "b", "rgb", "r", "g", "hex", "", "xyz", "x", "z", "mordant"})
    public static final class Companion {
        @NotNull
        public final TextStyle rgb(@NotNull String hex, @NotNull AnsiLevel level) {
            Intrinsics.checkNotNullParameter(hex, "hex");
            Intrinsics.checkNotNullParameter((Object)level, "level");
            return this.color(new RGB(hex), level);
        }

        public static /* synthetic */ TextStyle rgb$default(Companion companion, String string, AnsiLevel ansiLevel, int n, Object object) {
            if ((n & 2) != 0) {
                ansiLevel = AnsiLevel.TRUECOLOR;
            }
            return companion.rgb(string, ansiLevel);
        }

        @NotNull
        public final TextStyle rgb(int r, int g, int b, @NotNull AnsiLevel level) {
            Intrinsics.checkNotNullParameter((Object)level, "level");
            return this.color(new RGB(r, g, b, 0.0f, 8, null), level);
        }

        public static /* synthetic */ TextStyle rgb$default(Companion companion, int n, int n2, int n3, AnsiLevel ansiLevel, int n4, Object object) {
            if ((n4 & 8) != 0) {
                ansiLevel = AnsiLevel.TRUECOLOR;
            }
            return companion.rgb(n, n2, n3, ansiLevel);
        }

        @NotNull
        public final TextStyle hsl(int h, int s, int l, @NotNull AnsiLevel level) {
            Intrinsics.checkNotNullParameter((Object)level, "level");
            return this.color(new HSL(h, s, l, 0.0f, 8, null), level);
        }

        public static /* synthetic */ TextStyle hsl$default(Companion companion, int n, int n2, int n3, AnsiLevel ansiLevel, int n4, Object object) {
            if ((n4 & 8) != 0) {
                ansiLevel = AnsiLevel.TRUECOLOR;
            }
            return companion.hsl(n, n2, n3, ansiLevel);
        }

        @NotNull
        public final TextStyle hsv(int h, int s, int v, @NotNull AnsiLevel level) {
            Intrinsics.checkNotNullParameter((Object)level, "level");
            return this.color(new HSV(h, s, v, 0.0f, 8, null), level);
        }

        public static /* synthetic */ TextStyle hsv$default(Companion companion, int n, int n2, int n3, AnsiLevel ansiLevel, int n4, Object object) {
            if ((n4 & 8) != 0) {
                ansiLevel = AnsiLevel.TRUECOLOR;
            }
            return companion.hsv(n, n2, n3, ansiLevel);
        }

        @NotNull
        public final TextStyle cmyk(int c, int m, int y, int k, @NotNull AnsiLevel level) {
            Intrinsics.checkNotNullParameter((Object)level, "level");
            return this.color(new CMYK(c, m, y, k, 0.0f, 16, null), level);
        }

        public static /* synthetic */ TextStyle cmyk$default(Companion companion, int n, int n2, int n3, int n4, AnsiLevel ansiLevel, int n5, Object object) {
            if ((n5 & 0x10) != 0) {
                ansiLevel = AnsiLevel.TRUECOLOR;
            }
            return companion.cmyk(n, n2, n3, n4, ansiLevel);
        }

        @NotNull
        public final TextStyle gray(double fraction, @NotNull AnsiLevel level) {
            Intrinsics.checkNotNullParameter((Object)level, "level");
            double d = fraction;
            int n = d >= 0.0 && d <= 1.0 ? 1 : 0;
            boolean bl = false;
            boolean bl2 = false;
            if (n == 0) {
                boolean bl3 = false;
                String string = "fraction must be in the range [0, 1]";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            n = MathKt.roundToInt((double)255 * fraction);
            bl = false;
            bl2 = false;
            int it = n;
            boolean bl4 = false;
            return Companion.rgb(it, it, it, level);
        }

        public static /* synthetic */ TextStyle gray$default(Companion companion, double d, AnsiLevel ansiLevel, int n, Object object) {
            if ((n & 2) != 0) {
                ansiLevel = AnsiLevel.TRUECOLOR;
            }
            return companion.gray(d, ansiLevel);
        }

        @NotNull
        public final TextStyle xyz(double x, double y, double z, @NotNull AnsiLevel level) {
            Intrinsics.checkNotNullParameter((Object)level, "level");
            return this.color(new XYZ(x, y, z, 0.0f, 8, null), level);
        }

        public static /* synthetic */ TextStyle xyz$default(Companion companion, double d, double d2, double d3, AnsiLevel ansiLevel, int n, Object object) {
            if ((n & 8) != 0) {
                ansiLevel = AnsiLevel.TRUECOLOR;
            }
            return companion.xyz(d, d2, d3, ansiLevel);
        }

        @NotNull
        public final TextStyle lab(double l, double a, double b, @NotNull AnsiLevel level) {
            Intrinsics.checkNotNullParameter((Object)level, "level");
            return this.color(new LAB(l, a, b, 0.0f, 8, null), level);
        }

        public static /* synthetic */ TextStyle lab$default(Companion companion, double d, double d2, double d3, AnsiLevel ansiLevel, int n, Object object) {
            if ((n & 8) != 0) {
                ansiLevel = AnsiLevel.TRUECOLOR;
            }
            return companion.lab(d, d2, d3, ansiLevel);
        }

        @NotNull
        public final TextStyle color(@NotNull Color color, @NotNull AnsiLevel level) {
            Color color2;
            Color color3;
            Intrinsics.checkNotNullParameter(color, "color");
            Intrinsics.checkNotNullParameter((Object)level, "level");
            Color color4 = color;
            if (color4 instanceof TextStyle) {
                color3 = ((TextStyle)((Object)color)).getColor();
                if (color3 == null) {
                    return TextStyleKt.getDEFAULT_STYLE();
                }
            } else {
                color3 = color;
            }
            Color c = color3;
            switch (TextColors$Companion$WhenMappings.$EnumSwitchMapping$0[level.ordinal()]) {
                case 1: {
                    color2 = null;
                    break;
                }
                case 2: {
                    color2 = c.toAnsi16();
                    break;
                }
                case 3: {
                    if (c instanceof Ansi16) {
                        color2 = c;
                        break;
                    }
                    color2 = c.toAnsi256();
                    break;
                }
                case 4: {
                    color2 = c;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return TextStyleKt.TextStyle$default(color2, null, false, false, false, false, false, false, null, 510, null);
        }

        public static /* synthetic */ TextStyle color$default(Companion companion, Color color, AnsiLevel ansiLevel, int n, Object object) {
            if ((n & 2) != 0) {
                ansiLevel = AnsiLevel.TRUECOLOR;
            }
            return companion.color(color, ansiLevel);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

