/*
 *
 * Copyright (C) 1992 by Z. Wagner, bug correction 1993
 *
 */

#define CS_MAIN
#include "csindex.h"

char cscode;

/*
 * 0 = original sort
 * 1 = keybcs2
 * 2 = latin2
 * 3 = koi8cs
 */

#include <string.h>

typedef unsigned char uchar;

static uchar _latin2 [] =
  {128,131,134,245,209,135,136,137,138,139,140,143,151,141,207,152,
   157,158,164,165,168,169,219,220,223,177,178,182,184,185,186,187,
   188,189,190,198,199,200,246,201,202,203,204,205,206,173,174,175,
   208,225,211,215,170,171,221,176,227,228,235,238,239,240,242,244,
   218,160,192,159,212,216,234,196,129,161,133,146,150,148,229,162,
   147,132,253,231,156,163,195,130,247,236,167,194,'c','h',249,197,
   191,181,217,172,210,183,232,179,154,214,222,145,149,153,213,224,
   226,142,252,230,155,233,180,144,250,237,166,193,'C','H',254,255,0};

static uchar _kamen [] =
  {177,178,206,173,181,182,183,184,185,186,187,188,189,190,198,199,
   200,201,202,203,204,205,219,220,223,209,210,211,212,213,214,215,
   240,241,242,243,244,245,246,247,248,251,253,208,172,176,174,175,
   224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
   218,160,192,135,131,136,170,196,129,161,150,141,140,148,164,162,
   147,132,169,168,159,163,195,130,216,152,145,194,'c','h',222,197,
   191,143,217,128,133,137,171,179,154,139,166,138,156,153,165,149,
   167,142,158,155,134,151,180,144,149,157,146,193,'C','H',254,255,0};
                                                        
char koi8cs[] = { 0,
0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x21,0x21,0x21,0x21,0x21,0x20,0x20,
0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
0x01,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,
0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x40,0x40,0x40,0x40,0x40,0x40,
0x40,0x14,0x14,0x14,0x14,0x14,0x14,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x40,0x40,0x40,0x40,0x40,
0x40,0x18,0x18,0x18,0x18,0x18,0x18,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,
0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x40,0x40,0x40,0x40,0x20,
0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,
0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,
0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,
0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,
0x40,0x08,0x40,0x08,0x08,0x08,0x08,0x40,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,
0x08,0x08,0x08,0x08,0x08,0x08,0x40,0x08,0x08,0x08,0x08,0x40,0x08,0x08,0x40,0x40,
0x40,0x04,0x40,0x04,0x04,0x04,0x04,0x40,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
0x04,0x04,0x04,0x04,0x04,0x04,0x40,0x04,0x04,0x04,0x04,0x40,0x04,0x04,0x40,0x20};

static void tocode (uchar *convstr, const uchar *mask) {
while (*convstr) {
  if (*convstr > 127)
    *convstr = mask[*convstr-128];
  convstr++;
}}

static int itocode (int conv, const uchar *mask) {
return (conv > 127) ? mask[conv-128] : conv;
}

static int fromcode (int conv, const uchar *mask) {
int i;
if (conv > 127)
  for (i = 0;  i < 128;  i++)
    if (conv == mask[i]) { conv = i + 128;   break; }
return conv;
}

static uchar *tolatin (uchar *stg) {
tocode(stg, _latin2);       return stg;
}

int itolatin (int stg) {
return stg = itocode (stg, _latin2);
}

static uchar *tokamen (uchar *stg) {
tocode(stg, _kamen);        return stg;
}

int itokamen (int stg) {
return stg = itocode (stg, _kamen);
}

int fromlatin (int stg) {
return stg = fromcode (stg, _latin2);
}

int fromkamen (int stg) {
return stg = fromcode (stg, _kamen);
}

char *cs2ind (char *stg) {
char *c;
switch (cscode) {
case 1: tokamen ((uchar*)stg);  break;
case 2: tolatin ((uchar*)stg);  break;
case 3: for (c = stg; *c; c++) *c = ccs2ind (*c);  break;
}
return stg;
}

char ccs2ind (char c) {
int ch = (unsigned char)c;
switch (cscode) {
case 1: ch = itokamen (ch);  break;
case 2: ch = itolatin (ch);  break;
case 3:
  switch (ch) {
  case 220: ch = 'c';  break;
  case 221: ch = 'h';  break;
  case 252: ch = 'C';  break;
  case 253: ch = 'H';  break;
  }
  break;
}
return ch;
}

char idx2cs (char ch) {
int c = (unsigned char)ch;
switch (cscode) {
case 1: c = fromkamen (c);  break;
case 2: c = fromlatin (c);  break;
}
return c;
}

static int preview = EOF;

int csgetc (FILE *fptr) {
int ch;
if (preview != EOF) {
  ch = preview;  preview = EOF;
  return ch;
}
ch = getc (fptr);
if (!cscode) return ch;
while (ch != EOF && (ch == '{' || ch == 'c' || ch == 'C')) {
  preview = getc (fptr);
  if (ch == '{') {
    if (preview == '}') {
      ch = getc (fptr);  preview = EOF;
    }
    else {
      ungetc (preview, fptr);  preview = EOF;  break;
    }
  }
  else {
    if (preview == 'h') {
      preview = 221;
      return (ch == 'C' ? 252 : 220);
    }
    else
    if (preview == 'H' && ch == 'C') {
      preview = 253;
      return 252;
    }
    ungetc (preview, fptr);  preview = EOF;  break;
  }
}
return idx2cs (ch);
}

static uchar Same [] = {193,209,216,215,197,201,207,205,208,213,202,
       200,217,196,198,203,204,206,212,225,241,248,247,229,233,239,237,
       240,245,234,232,249,228,230,235,236,238,244,0};
static uchar SameAs [] = "AAAEEIOOOUUUYDRLLNTaaaeeiooouuuydrllnt";
static uchar After []  = {227,242,243,250,195,210,211,218,252,220,0};
static uchar Before [] = "crszCRSZhH";

#if __TURBOC__
#pragma warn -pia
#pragma warn -sig
#endif

int cslower (int ch) {
char *p;
if (!cscode) return tolower(ch);
if (p = strchr((char*)Same, ch)) ch = SameAs[p-(char*)Same];
return isupper(ch) ? ch ^ 32 : ch;
}

int csupper (int ch) {
char *p;
if (!cscode) return toupper(ch);
if (p = strchr((char*)Same, ch)) ch = SameAs[p-(char*)Same];
return islower(ch) ? ch ^ 32 : ch;
}

#if __TURBOC__
#pragma warn .sig
#pragma warn .pia
#endif

int cstrcmp (char *s1, char *s2) {
int x1, x2;     char *p, *c1, *c2;
int st1, st2, result = 0;
uchar d1, d2;
int pass;
if (!cscode) return strcmp (s1, s2);
for (pass = 0;  !result && pass < 4;  pass++) {
  c1 = s1;  c2 = s2;
  do {
    st1 = st2 = 0;
    if (pass < 3) {
      if (*(uchar*)c1 == 221 || *(uchar*)c1 == 253) c1++;
      if (*(uchar*)c2 == 221 || *(uchar*)c2 == 253) c2++;
    }
    d1 = *(uchar*)c1;  d2 = *(uchar*)c2;
    if (pass > 1) {
      if (isalpha (d1) && d1 < 128) d1 ^= 0x20;
      if (isalpha (d2) && d2 < 128) d2 ^= 0x20;
    }
    else {
      if (isalpha (d1)) d1 |= 0x20;
      if (isalpha (d2)) d2 |= 0x20;
    }
    #if __TURBOC__
    #pragma warn -pia
    #pragma warn -sig
    #endif
    if (d1 < 193) x1 = d1;
    else
    if (p = strchr((char*)Same, d1))
      x1 = pass ? p - (char*)Same + 128 : SameAs[p-(char*)Same];
    else
    if (p = strchr((char*)After, d1)) {
      x1 = Before[p-(char*)After];  st1 = 1;
    }
    else x1 = d1;
    if (d2 < 193) x2 = d2;
    else
    if (p = strchr((char*)Same, d2))
      x2 = pass ? p - (char*)Same + 128 : SameAs[p-(char*)Same];
    else
    if (p = strchr((char*)After, d2)) {
      x2 = Before[p-(char*)After];  st2 = 1;
    }
    else x2 = d2;
    #if __TURBOC__
    #pragma warn .sig
    #pragma warn .pia
    #endif
    if (!(result = x1 - x2)) result = st1 - st2;
  } while (!result && *c1++ && *c2++);
}
return result;
}
