unit strings;

INTERFACE

const  nocodes     = 12;  {number of codes}
       nocodesseq  =  2;  {number of codes given by sequences}
       nochars     = 56;  {number of characters}
       nocharsalw  = 45;  {number of characters always converted}
       lastsingle  = 52;  {chars with greater index might be converted to more}

{ 1..nocharsalw: accented letters ordered by accent/capitals/alphabet, & }
{ nocharsalw+1..nochars: no-break space, en/em-dash,                     }
{ left/righ single quote, left/right single Czech quote,                 }
{ left/right double quote, left/right double Czech quote;                }
{ left single Czech quote in t1 is not given [=CR]                       }

const  tables : array[1..nocodes,0..2] of string =
       {name of code}
       {inputs:  0 - character does not exist}
       {outputs: 0 - nothing, 1 - space, 2 - expansion according tables2}
(
  ( 'ASC' , '00000000000000000000000000000000000000000000&000`''000000'  ,
            'AEILORUYaeiloruyOoCDELNRSTZcdelnrstzUuAOUaou& --`'',`2222' ),
  ( 'US'  , '0000000000000000000000000000000&0`''000000'  ,
            'AILORUYlryOCDELNRSTZcdelnrstzUu&`'',`2222' ),
  ( 'KAM' , '&0`''000000'  ,
            '&`'',`2222' ),
  ( 'PL1' , '000000000000000000000000&0`''000000'  ,
            'LRlrCDELNRSTZcdelnrstzUu&`'',`2222' ),
  ( 'PL2' , '֑⓬ҷ曦ؖ眧ޅ&0`''000000'  ,
            '֑⓬ҷ曦ؖ眧ޅ&`'',`2222' ),
  ( 'IBM' , '֑⓫ҷ曥ؖ眦ޅ&0`''000000'  ,
            '֑⓫ҷ曥ؖ眦ޅ&`'',`2222' ),
  ( 'IL1' , '000000000000000000000000&00`''000000'  ,
            'LRlrCDELNRSTZcdelnrstzUu&--`'',`2222' ),
  ( 'IL2' , '̥ة&00`''000000'  ,
            '̥ة&--`'',`2222' ),
  ( 'WIN' , '̼؊&00'   ,
            '̼؊&'  ),
  ( 'MAC' , 'ڜ닓󀅆&00'   ,
            'ڜ닓󀅆&'  ),
  ( 'KOI' , '&0`''000000'  ,
            '&`'',`2222' ),
  ( 'T1'  , '͈ӏ􃄅&0`''000'  ,
            '͈ӏ􃄅& `'',`' )
);

const  tables2 : array[1..nocodes,lastsingle..nochars] of string =
       {should be ordered as the input/output tables !!!}
(
  ( 'ASC' ,  '``' , '''''' , ',,' ,  '``' ),
  ( 'US'  ,  '``' , '''''' , ',,' ,  '``' ),
  ( 'KAM' ,  '``' , '''''' , ',,' ,  '``' ),
  ( 'PL1' ,  '``' , '''''' , ',,' ,  '``' ),
  ( 'PL2' ,  '``' , '''''' , ',,' ,  '``' ),
  ( 'IBM' ,  '``' , '''''' , ',,' ,  '``' ),
  ( 'IL1' ,  '``' , '''''' , ',,' ,  '``' ),
  ( 'IL2' ,  '``' , '''''' , ',,' ,  '``' ),
  ( 'WIN' ,  '``' , '''''' , ',,' ,  '``' ),
  ( 'MAC' ,  '``' , '''''' , ',,' ,  '``' ),
  ( 'KOI' ,  '``' , '''''' , ',,' ,  '``' ),
  ( 'T1'  ,  '``' , '''''' , ',,' ,  '``' )
);

const  tablesseq : array[1..nocodesseq,-1..nochars] of string =
       {escape character, name of code, expansions of characters}
(
 ( '\' , 'TEX' ,
   '\''A' , '\''E' , '\''I' ,   '\''L' , '\''O' , '\''R' , '\''U' , '\''Y' ,
   '\''a' , '\''e' , '\''{\i}', '\''l' , '\''o' , '\''r' , '\''u' , '\''y' ,
   '\^O' , '\^o',
   '\v{C}','\v{D}','\v{E}','\v{L}','\v{N}','\v{R}','\v{S}','\v{T}','\v{Z}',
   '\v{c}','\v{d}','\v{e}','\v{l}','\v{n}','\v{r}','\v{s}','\v{t}','\v{z}',
   '\accent23U' , '\accent23u' ,
   '\"A' , '\"O' , '\"U' , '\"a' , '\"o' , '\"u' , '&' ,
   '~' , '--' , '---' ,
   '`' , '''' , '\clq ' , '\crq ' , '``' , '''''' , '\clqq ' , '\crqq '
 ),
 ( '&' , 'HTM' ,
   '&Aacute', '&Eacute', '&Iacute', 'L', '&Oacute', 'R', '&Uacute', '&Yacute',
   '&aacute', '&eacute', '&iacute', 'l', '&oacute', 'r', '&uacute', '&yacute',
   '&Ocirc' , '&ocirc',
   'C' , 'D' , 'E' , 'L' , 'N' , 'R' , 'S', 'T' , 'Z' ,
   'c' , 'd' , 'e' , 'l' , 'n' , 'r' , 's', 't' , 'z' ,
   'U' , 'u' ,
   '&Auml' , '&Ouml' , '&Uuml' , '&auml' , '&ouml' , '&uuml' , '&amp' ,
   ' ' , '-' , '-' , '`' , '''' , ',' , '`' , '``' , '''''' , ',,' , '``'
 )
);

IMPLEMENTATION

begin
end.

