/* Pomocny program pro vymazani souboru pk v adresarich
   ****************************************************
   24.11.96                                  Petr Olsak

   22. 3.97 -- oprava chyby: program cte nyni i velka pismena disku.

   Program se vola se tremi parametry:
     1. Zakladni cesta
     2. Adresare v zakladni ceste (muze jich byt vice pomoci * nebo ?)
     3. Jmeno vymazavaneho souboru
   Program vymaze soubor s nazvem podle 3. parametru z adresaru podle
   2. parametru s tim, ze se zanori jeste do jedne urovne adresaru.

   Priklad: rempks c:\emtex\fonts pixel.* obrazek.pk
   vymaze vsechny soubory c:\emtex\fonts\pixel.*\*.*\obrazek.pk

   Prametr 1 muze obsahovat strednikem oddelene cesty. Pak program
   pracuje jen s prvni alternativou.
*/

# include <stdio.h>
# include <dir.h>
# include <dos.h>

void challdir (filename)
  char *filename;
{
  int i;
  struct ffblk ffblk;
  char currentdir[130];
  i = findfirst ("*.*",&ffblk,FA_DIREC);
  while (!i)
  {
    if (ffblk.ff_name[0]!='.') if (!chdir (ffblk.ff_name))
    {
      if (!unlink (filename))
      {
	getcurdir (0, currentdir);
	printf ("/%s\\%s removed\n", currentdir, filename);
      }
      chdir ("..") ;
    }
    i = findnext (&ffblk);
  }
  return;
}

int main (argc, argv)
  int argc;
  char *argv[];
{
  struct ffblk ffblk;
  char curdir[130];
  int curdisk, d;

  if (argc < 4)
    return printf ("rempks: program needs three parameters\n\
    1. the base path\n\
    2. the directories in base path\n\
    3. the file name to be removed\n\
  example:  rempks c:\\emtex\\fonts pixel.* pic.pk\n\
  this command removes all files c:\\emtex\\fonts\\pixel.*\\*.*\\pic.pk\n"), 1;

  getcurdir (0, curdir); curdisk = getdisk ();

  d = 0;
  while (argv[1][d]) if (argv[1][d++]==';') argv[1][d-1]=0;

  if (chdir(argv[1]))
    return printf ("rempks: There is no directory %s\n",argv[1]), 2;

  if (argv[1][1]==':') setdisk ((d=argv[1][0])-(d<'a'? 'A':'a'));

  d = findfirst (argv[2],&ffblk,FA_DIREC);
  while (!d)
  {
    if (ffblk.ff_name[0]!='.') if(!chdir(ffblk.ff_name))
      {
	challdir (argv[3]) ;
	chdir ("..") ;
      }
    d = findnext(&ffblk);
  }

  setdisk (curdisk); chdir ("\\"); chdir (curdir);
  return 0;
}
