/*	FIX.C 3.2 -- uprava programu fix.c pro praci i ve Windows.
	Na rozdil od predchozi verze, je-li treba, zmeni
	aktualni adresar na adresar uvedeny v prnim parametru.

	Dle programu Petra OLSAKA upravil
	Hans GINZEL <Hans@kolej.mff.cuni.cz>.
 */

#define VERSION 3.2

#include <stdio.h>
#include <dir.h>

char s1d[MAXDRIVE], s1p[MAXDIR], s1n[MAXFILE], s1e[MAXEXT],
     s2d[MAXDRIVE], s2p[MAXDIR], s2n[MAXFILE], s2e[MAXEXT];
char cwd[MAXPATH];
int  ret=0, slave(), printvalidpath(char *path);

int main(int argc, char *argv[]) {
	/*
		  Debugging tool
		printf("rem First parameter  = %s\n", argv[1]);
		printf("rem Second parameter = %s\n", argv[2]);
	 */
	/*
		About me
	 */
	printf("rem This batch is generated automaticly by Fix %g \
(part of TeX-MNU system).\n", VERSION);
	/*
		kontrola poctu parametru (1 || 2)
	 */
	if ((argc < 2) || (argc > 3)) {
		printf("rem Error. Sorry, I need one or two parameters.\n");
		return 1;}
	/*
		rozdeli parametry ziskane z prikazove radky
		na disk, path, name, extension
	 */
	fnsplit(argv[1],s1d,s1p,s1n,s1e);
	fnsplit(argv[2],s2d,s2p,s2n,s2e);
	/*
		pokud extension == "" dopln ".tex"
	 */
	if (s1e[0] == '\0') strcat(s1e,".tex");
	if (s2e[0] == '\0') strcat(s2e,".tex");
	/*
		----- Output -----
		first_parametr_disk:
		cd \first_parametr_path
		set MAIN=f_p_name
		set MAINF=f_p_name.f_p_ext
		if second_parameter=="" {
			set WORK=MAIN
			set WORKF=MAINF}
		else {
			set WORK=s_p_disk:\s_p_path\s_p_name	// viz nize,
			set WORKF=WORK.s_p_ext}             	// calling slave
	 */
	printf("%s\n", s1d);
	if (s1p[0]!='\0') {
		printf("cd ");
		printvalidpath(s1p);	// uprava kvuli "..\", ".\"
	}
	printf("set MAIN=%s\nset MAINF=%s%s\n", s1n,s1n,s1e);
	if (argc == 2) {
		printf("set WORK=%%MAIN%%\nset WORKF=%%MAINF%%\n");
		return 0;}
	/*
		prvni pokus: set WORK=s_p_disk:\s_p_path\s_p_name
	 */
	printf("set WORK=%s%s%s\n", s2d,s2p,s2n);
	/*
		Dojde-li ke zmene akt. adresare, zavolame na pomoc fci slave
	 */
	if (s1d[0]!='\0' || s1p[0]!='\0') ret=slave();
	/*
		WORKF=WORK+koncovka
	 */
	printf("set WORKF=%%WORK%%%s\n", s2e);
	/*
		vratime, co vratila funkce slave, respektive nulu
	 */
	return ret;
}

/*---------------------------------- slave ----------------------------------*/
/*
	Funkcicka na rozebrani slozitejsich pripadu
 */
int slave() {
	/*
		Je-li f_p_path casti s_p_path,
			set WORK=s_p_disk:\zbytek_s_p_path\s_p_name
	 */
	if (stricmp(s1d,s2d)=='\0') {	// s1d=s2d
		int i=0;
		while (s1p[i]!='\0' && s1p[i]==s2p[i]) i++;
		if (s1p[i]=='\0') {
			printf("set WORK=");
			if (s2p[i]!=0) printf("%s", s2p+i);	// zbytek cesty
			printf("%s\n", s2n);
			return 0;
		}
	}
	/*
	V ostatnich pripadech
	 */
	if (s2d[0]!='\0') {	// second_parameter_disk <> ""
		if (s2p[0]!='\\') {	// second_parameter_path is relative
			if (getcurdir(s2d[0]-(s2d[0]<'a'? 'A':'a')+1, s1p)) {	// error
				printf("echo Error (by Fix)! Sorry, but I can't determinate \
the current directory of disk %s .\n", s2d);
				return 3;
			} else {
				printf("set WORK=%s", s2d);
				printf("\\%s", s1p); if (s1p[0]!='\0') printf("\\");
				printf("%s%s\n", s2p,s2n);
				return 0;
			}
		} else {
			return 0;		// output stejny jako prvni pokus
		}
	} else {        	// second_parameter_disk = ""
		if (getcwd(cwd, MAXPATH)!=NULL) {
			strcat(cwd, "\\");
			fnsplit(cwd, s1d,s1p,NULL,NULL);	// prvni parametr uz neni potreba
			printf("set WORK=%s", s1d);
			if (s2p[0]!='\\')	printf("%s", s1p);	// s_p_path is relative
			printf("%s%s\n", s2p,s2n);
			return 0;
		} else {	// error
			printf("echo Error (by Fix)! Sorry, but I can't determinate \
the current working directory.\n");
		return 2;
		}
	}
};	// slave()

/*------------------------------ printvalidpath ------------------------------*/
/*
	Funkce zplatnujici cestu (nebot pri "cd ..\" hlasi Dos "invalid directory")
 */
int printvalidpath(char *path) {
	char *p;
	if (path[0]=='\0') return 0;
	putchar(*(p=path));
	for(p++; p[0]!='\0'; p++) {
		if (p[0]=='\\' && p[1]=='\0') {
			putchar('\n');
			return 1;
		} else
			putchar(*p);
	}
	putchar('\n');
	return 0;
}	// printvalidpath

/******************************** Dokumentace *********************************/
/*
Program Fix 3.1 testuje postupn monosti, tak jak jsou v nsledujc tabulce
uvedeny. Po nalezen prvn vyhovujc, program tiskne vstup (
	 d:
	 cd
	 set MAIN=
	 set MAINF=%MAIN%first_param_ext or .tex
	 set WORK=
	 set WORKF=%WORK%second_param_ext or .tex
)
a kon.

No  Prarmetry                                         d      cd               MAIN   WORK                            Koment
--------------------------------------------------------------------------------------------------------------------------------
0.                                                    Error  Error            Error  Error                           Bez parametr
1.  [D:][[.[.]]\][dir\]a                              [D:]   [[.[.]]\][dir\]  a      a                               Jeden parametr
2.  a                     [D:][[.[.]]\][dir\]b                                a      [D:][[.[.]]\][dir\]b            Nedojde ke zmn aktualnho adrese
3.  [D:][[.[.]]\][dir1\]a [D:][[.[.]]\][dir1\]b       [D:]   [[.[.]]\][dir1\] a      b                               Shodn adrerse
4.  [D:][[.[.]]\][dir1\]a [D:][[.[.]]\][dir1\]dir2\b  [D:]   [[.[.]]\][dir1\] a      dir2\b                          WORK je "pod" MAIN (f_p_d=s_p_d & f_p_p je st s_p_p)
5.  *                     D:[.[.]\][dir\]b            *      *                *      D:\cur_dir_of_d\[.[.]\][dir\]b  Je poteba pidat aktuln adres disku s_p_d
6.  *                     \[dir\]b                    *      *                *      CurrentWorkDisk:\[dir\]b             - // -       aktuln disk
7.  *                     [.[.]\][dir\]b              *      *                *      CurrentWorkDir\[.[.]\][dir\]b        - // -       aktuln adres


ErrorCodes:
	0 ... All OK
	1 ... Invalid numbor of parameters
	2 ... Can not determinate the current working directory
	3 ... Can not determinate the current directory of disk sec_param_disk

 */
